/**
 * Admin JavaScript for WooCommerce Pickup & Delivery
 *
 * @package    aicoso_pickup_delivery
 * @version    1.0.0
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // Initialize datepickers with enhanced support
    // Check for native date input support
    var isDateSupported = function() {
        var input = document.createElement('input');
        input.setAttribute('type', 'date');
        input.setAttribute('value', 'not-a-date');
        return input.value !== 'not-a-date';
    };
    
    // Initialize jQuery UI datepicker for browsers without native support
    if (!isDateSupported()) {
        $('.datepicker').attr('type', 'text').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: 0,
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            yearRange: 'c:c+5'
        });
    } else {
        // For native date inputs, set min attribute to today
        var today = new Date().toISOString().split('T')[0];
        $('.datepicker[type="date"]').attr('min', today);
    }
    
    // Settings tabs functionality
    function initSettingsTabs() {
        // Tab navigation is handled by page reload, no JavaScript needed
        // Keeping function for future enhancements
    }
    
    // Location management
    function initLocationManagement() {
        // Cancel button
        $('#location_cancel_btn').on('click', function() {
            // Reset form title
            $('#location_form_title').text('Add New Pickup Location');
            
            // Reset form mode
            $('#location_action').val('add');
            $('#original_location_name').val('');
            
            // Clear form fields
            $('#location_name').val('');
            $('#location_address').val('');
            $('#location_map_url').val('');
            $('#location_email').val($('#location_email').attr('data-default'));
            $('#location_max_orders').val('25');
            
            // Reset button text
            $('#location_submit_btn').text('Add Location');
            $('#location_submit_btn').attr('name', 'add_pickup_location');
            
            // Hide cancel button
            $(this).hide();
        });
        
        // Edit button
        $('.edit-location').on('click', function(e) {
            e.preventDefault();
            
            var location = $(this).data('location');
            
            // Update form title
            $('#location_form_title').text('Edit Pickup Location');
            
            // Set form to edit mode
            $('#location_action').val('edit');
            $('#original_location_name').val(location.location_name);
            
            // Fill form fields
            $('#location_name').val(location.location_name);
            $('#location_address').val(location.location_address);
            $('#location_map_url').val(location.location_map_url);
            $('#location_email').val(location.location_email);
            $('#location_max_orders').val(location.max_orders);
            
            // Update button text
            $('#location_submit_btn').text('Update Location');
            $('#location_submit_btn').attr('name', 'update_pickup_location');
            
            // Show cancel button
            $('#location_cancel_btn').show();
            
            // Scroll to form
            $('html, body').animate({
                scrollTop: $('#location_form_title').offset().top - 50
            }, 500);
        });
        
        // Delete button confirmation
        $('.delete-location').on('click', function() {
            return confirm(aicoso_pickup_delivery_admin.i18n.confirm_delete);
        });
    }
    
    // Time slot management
    function initTimeSlotManagement() {
        // Toggle delivery time slots container
        $('#enable_delivery_time_slots').on('change', function() {
            if ($(this).is(':checked')) {
                $('#delivery_time_slots_container').slideDown();
            } else {
                $('#delivery_time_slots_container').slideUp();
            }
        });
        
        // Toggle pickup time slots container
        $('#enable_pickup_time_slots').on('change', function() {
            if ($(this).is(':checked')) {
                $('#pickup_time_slots_container').slideDown();
            } else {
                $('#pickup_time_slots_container').slideUp();
            }
        });
        
        // Delete button confirmation
        $('.delete-time-slot').on('click', function() {
            return confirm(aicoso_pickup_delivery_admin.i18n.confirm_delete);
        });
    }
    
    // Order management
    function initOrderManagement() {
        // Toggle between delivery and pickup fields
        $('#aicoso_pickup_delivery_type').on('change', function() {
            var selectedType = $(this).val();
            
            if (selectedType === 'delivery') {
                $('.aicoso-pickup-delivery-delivery-fields').show();
                $('.aicoso-pickup-delivery-pickup-fields').hide();
            } else {
                $('.aicoso-pickup-delivery-delivery-fields').hide();
                $('.aicoso-pickup-delivery-pickup-fields').show();
            }
        });
        
        // Initialize datepickers on order edit page
        $('#aicoso_pickup_delivery_delivery_date, #aicoso_pickup_delivery_pickup_date').datepicker({
            dateFormat: 'yy-mm-dd',
            minDate: 0
        });
    }
    
    // Reports
    function initReports() {
        // Handle range selector
        $('.aicoso-pickup-delivery-range-selector').on('change', function() {
            $(this).closest('form').submit();
        });
    }
    
    // Initialize all admin scripts
    function init() {
        initSettingsTabs();
        initLocationManagement();
        initTimeSlotManagement();
        initOrderManagement();
        initReports();
    }
    
    // Run initialization
    init();
});