/**
 * Admin Settings Time Slots Scripts
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 */

(function($) {
	'use strict';

	$(document).ready(function() {
		// Toggle delivery time slots container.
		$('#enable_delivery_time_slots').on('change', function() {
			if ($(this).is(':checked')) {
				$('#delivery_time_slots_container').show();
			} else {
				$('#delivery_time_slots_container').hide();
			}
		});
		
		// Toggle pickup time slots container.
		$('#enable_pickup_time_slots').on('change', function() {
			if ($(this).is(':checked')) {
				$('#pickup_time_slots_container').show();
			} else {
				$('#pickup_time_slots_container').hide();
			}
		});
		
		// Edit time slot functionality.
		$('.edit-time-slot').on('click', function() {
			var $row = $(this).closest('tr');
			var slotType = $(this).data('slot-type');
			var slotName = $row.data('slot-name');
			var startTime = $row.data('start-time');
			var endTime = $row.data('end-time');
			var maxOrders = $row.data('max-orders');
			
			if (slotType === 'delivery') {
				// Populate delivery form.
				$('#delivery-form-title').text(wcPickupDeliveryTimeslots.editDeliveryTitle);
				$('#edit_delivery_slot_original').val(slotName);
				$('#delivery_slot_name').val(slotName);
				$('#delivery_start_time').val(startTime);
				$('#delivery_end_time').val(endTime);
				$('#delivery_max_orders').val(maxOrders);
				
				// Show/hide buttons.
				$('#add_delivery_button').hide();
				$('#update_delivery_button').show();
				$('#cancel_delivery_edit').show();
				
				// Scroll to form.
				$('html, body').animate({
					scrollTop: $('#delivery-form-title').offset().top - 50
				}, 500);
			} else {
				// Populate pickup form.
				$('#pickup-form-title').text(wcPickupDeliveryTimeslots.editPickupTitle);
				$('#edit_pickup_slot_original').val(slotName);
				$('#pickup_slot_name').val(slotName);
				$('#pickup_start_time').val(startTime);
				$('#pickup_end_time').val(endTime);
				$('#pickup_max_orders').val(maxOrders);
				
				// Show/hide buttons.
				$('#add_pickup_button').hide();
				$('#update_pickup_button').show();
				$('#cancel_pickup_edit').show();
				
				// Scroll to form.
				$('html, body').animate({
					scrollTop: $('#pickup-form-title').offset().top - 50
				}, 500);
			}
		});
		
		// Cancel edit - Delivery.
		$('#cancel_delivery_edit').on('click', function() {
			// Reset form.
			$('#delivery-form-title').text(wcPickupDeliveryTimeslots.addDeliveryTitle);
			$('#edit_delivery_slot_original').val('');
			$('#delivery_slot_name').val('');
			$('#delivery_start_time').val('');
			$('#delivery_end_time').val('');
			$('#delivery_max_orders').val('10');
			
			// Show/hide buttons.
			$('#add_delivery_button').show();
			$('#update_delivery_button').hide();
			$('#cancel_delivery_edit').hide();
		});
		
		// Cancel edit - Pickup.
		$('#cancel_pickup_edit').on('click', function() {
			// Reset form.
			$('#pickup-form-title').text(wcPickupDeliveryTimeslots.addPickupTitle);
			$('#edit_pickup_slot_original').val('');
			$('#pickup_slot_name').val('');
			$('#pickup_start_time').val('');
			$('#pickup_end_time').val('');
			$('#pickup_max_orders').val('10');
			
			// Show/hide buttons.
			$('#add_pickup_button').show();
			$('#update_pickup_button').hide();
			$('#cancel_pickup_edit').hide();
		});
	});

})(jQuery);
