/**
 * Admin Settings Locations Scripts
 *
 * @package Aicoso_Pickup_Delivery_For_Woocommerce
 */

(function($) {
	'use strict';

	$(document).ready(function() {
		// Edit location.
		$('.edit-location').on('click', function(e) {
			e.preventDefault();
			
			var location = $(this).data('location');
			
			// Update form title.
			$('#location_form_title').text(wcPickupDeliveryLocations.editTitle);
			
			// Set form to edit mode.
			$('#location_action').val('edit');
			$('#original_location_name').val(location.location_name);
			
			// Fill form fields.
			$('#location_name').val(location.location_name);
			$('#location_address').val(location.location_address);
			$('#location_map_url').val(location.location_map_url);
			$('#location_email').val(location.location_email);
			$('#location_max_orders').val(location.max_orders);
			
			// Update button text.
			$('#location_submit_btn').text(wcPickupDeliveryLocations.updateButton);
			$('#location_submit_btn').attr('name', 'update_pickup_location');
			
			// Show cancel button.
			$('#location_cancel_btn').show();
			
			// Scroll to form.
			$('html, body').animate({
				scrollTop: $('#location_form_title').offset().top - 50
			}, 500);
		});
		
		// Cancel edit.
		$('#location_cancel_btn').on('click', function() {
			// Reset form title.
			$('#location_form_title').text(wcPickupDeliveryLocations.addTitle);
			
			// Reset form mode.
			$('#location_action').val('add');
			$('#original_location_name').val('');
			
			// Clear form fields.
			$('#location_name').val('');
			$('#location_address').val('');
			$('#location_map_url').val('');
			$('#location_email').val(wcPickupDeliveryLocations.adminEmail);
			$('#location_max_orders').val('25');
			
			// Reset button text.
			$('#location_submit_btn').text(wcPickupDeliveryLocations.addButton);
			$('#location_submit_btn').attr('name', 'add_pickup_location');
			
			// Hide cancel button.
			$(this).hide();
		});
	});

})(jQuery);
