<?php
/**
 * Uninstall script
 *
 * @package ReplicateWP_Virtual_TryOn
 */

// Exit if accessed directly
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Delete plugin options
delete_option( 'rwpvto_settings' );

// Drop custom table
global $wpdb;
$rwpvto_table_name_raw = $wpdb->prefix . 'rwpvto_generated_images';
// Escape table name for security (table names cannot be parameterized in DROP TABLE)
$rwpvto_table_name = esc_sql( $rwpvto_table_name_raw );
// Table name is escaped and safe - DROP TABLE doesn't support placeholders
$wpdb->query( "DROP TABLE IF EXISTS `{$rwpvto_table_name}`" );

// Clear any cached data
wp_cache_flush();

