<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 * It outputs the HTML structure for the NimBot popup chatbot interface
 * that appears on the front-end of the website.
 *
 * @link       https://ai-tool-center.com/about
 * @since      1.0.0
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/public/partials
 */

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
?>
<style>
    .aitoce-popup-chat-box {
        border-top-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
        border-top-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
        border-bottom-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
        border-bottom-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
    }

    .aitoce-popup-chat-header {
        color: <?php echo esc_attr($agent->styling['aitoce_agent_header_text']); ?>;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_header_background']); ?>;
        border-top-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
        border-top-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
    }

    .aitoce-popup-chat-input-area {
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_header_background']); ?>;
        border-bottom-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
        border-bottom-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
    }

    .aitoce-popup-chat-messages {
        height: <?php echo esc_attr($agent->styling['aitoce_agent_background_height']); ?>px;
        max-height: <?php echo esc_attr($agent->styling['aitoce_agent_background_height']); ?>px;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_background_background']); ?>;
    }

    .aitoce-popup-chat-input {
        color: <?php echo esc_attr($agent->styling['aitoce_agent_input_text']); ?>;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_input_background']); ?>;
        border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_input_radius']); ?>px;
    }

    .aitoce-popup-user-message {
        color: <?php echo esc_attr($agent->styling['aitoce_agent_client_text']); ?>;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_client_background']); ?>;
        border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_client_radius']); ?>px;
    }

    .aitoce-popup-bot-message {
        color: <?php echo esc_attr($agent->styling['aitoce_agent_nimbot_text']); ?>;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_nimbot_background']); ?>;
        border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_nimbot_radius']); ?>px;
    }

    .aitoce-popup-send-btn {
        color: <?php echo esc_attr($agent->styling['aitoce_agent_button_text']); ?>;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_button_background']); ?>;
        border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_button_radius']); ?>px;
    }

    .aitoce-popup-send-btn:hover {
        color: <?php echo esc_attr($agent->styling['aitoce_agent_button_hover_text']); ?>;
        background-color: <?php echo esc_attr($agent->styling['aitoce_agent_button_hover_background']); ?>;
    }
</style>

<?php 
$nimbot_reply_greeting = (isset($agent->styling['aitoce_agent_nimbot_greeting']) && !empty($agent->styling['aitoce_agent_nimbot_greeting'])) ? $agent->styling['aitoce_agent_nimbot_greeting'] : 'Hi, How can I help?';
?>

<div id="aitoce-popup-container" class="aitoce-popup-container">
    <div id="aitoce-popup-chat-box" class="aitoce-popup-chat-box">
        <div id="aitoce-chat-header" class="aitoce-popup-chat-header">
            <div id="aitoce-popup-chat-header-text" class="aitoce-chat-header-text" agent-id="<?php echo esc_attr($popup_agent_id); ?>">
                <?php echo esc_html($agent->connection['aitoce_agent_name']); ?>
            </div>
            <i id="aitoce-popup-refresh-chat" class="fa-solid fa-arrows-rotate" title="Reset"></i>
            <i id="aitoce-popup-close-chat" class="fa-regular fa-circle-xmark" title="Close"></i>
        </div>
        <div id="aitoce-popup-messages" class="aitoce-popup-chat-messages">
            <div id="aitoce-popup-bot-message" class="aitoce-popup-bot-message">
                <b><?php echo esc_html($agent->connection['aitoce_agent_name']); ?>: <i class="fa-solid fa-comment"></i></b><br><?php echo esc_html($nimbot_reply_greeting); ?>
            </div>
        </div>
        <div id="aitoce-chat-input-area" class="aitoce-popup-chat-input-area">
            <textarea id="aitoce-popup-input" class="aitoce-popup-chat-input" rows="2"
                placeholder="<?php esc_html_e('Type a message...', 'ai-tool-center'); ?>" aria-label="Popup Message Input"></textarea>
            <div id="aitoce-popup-send-btn" class="aitoce-popup-send-btn">
                <?php esc_html_e('Send', 'ai-tool-center'); ?>
            </div>
        </div>
    </div>
    <img id="aitoce-icon" class="aitoce-popup-icon"
        src="<?php echo esc_url( plugin_dir_url( __DIR__ ) . 'images/nimbot-speech-bubble.png' ); ?>" alt="Nimbot Icon" />
</div>