jQuery(document).ready(function($) {
    let aitoce_last_prompt;
    let aitoce_message_ids = {
        popup: aitoce_generate_message_id(),
        page: aitoce_generate_message_id(),
    };

    // Toggle chat box visibility
    $('#aitoce-icon, #aitoce-popup-close-chat').click(function() {
        $('#aitoce-popup-chat-box').toggle();
        if ($(window).width() < 765) {
            $('#aitoce-icon').toggle();
        }
        $('#aitoce-popup-input').focus();
    });

    // Reset chat handlers
    $('#aitoce-popup-refresh-chat').click(() => resetChat('popup'));
    $('#aitoce-page-refresh-chat').click(() => resetChat('page'));

    // Send button handlers
    $('#aitoce-popup-send-btn').click(() => sendMessage('popup'));
    $('#aitoce-page-send-btn').click(() => sendMessage('page'));

    // Enter key handlers
    $('#aitoce-popup-input').keypress(e => {
        if (e.which === 13) {
            sendMessage('popup');
        }
    });

    $('#aitoce-page-input').keypress(e => {
        if (e.which === 13 && !e.shiftKey)  {
            sendMessage('page');
        }
    });

    function sendMessage(format) {
        const agent_id = document.getElementById(`aitoce-${format}-chat-header-text`).getAttribute("agent-id");
        const client_input = $(`#aitoce-${format}-input`);
        let userMessage = client_input.val().trim();

        if (userMessage) {
            aitoce_last_prompt = userMessage;
            const parsedMessage = escapeHTML(userMessage);

            appendUserMessage(parsedMessage, format);
            appendThinking(format);
            scrollMessages(format);

            client_input.val('').focus();
            fetchData(agent_id, format);
        }
    }

    function fetchData(agent_id, format) {
        const id = aitoce_message_ids[format] ?? (aitoce_message_ids[format] = aitoce_generate_message_id());

        $.ajax({
            url: aitoce_ai_tool_center_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'aitoce_ajax_request',
                aitoce_security: aitoce_ai_tool_center_ajax.security,
                aitoce_agent_id: agent_id,
                aitoce_message_id: id,
                aitoce_last_prompt: aitoce_last_prompt,
                aitoce_prompt_format: format,
            },
            success: function(response) {
                console.log(response);

                let assistantMessage = marked.parse(response.data.assistant || 'No response');
                let state = response.data.success ? 'success' : 'error';

                appendBotMessage(assistantMessage, state, format);
                scrollMessages(format);
                
                // Unset previous highlights
                document.querySelectorAll('pre code[data-highlighted]').forEach(el => {
                    delete el.dataset.highlighted;
                });

                // Highlight new content
                hljs.highlightAll();
            },
            error: function(error) {
                console.log(error);
                appendBotMessage('Sorry something went wrong!', 'error', format);
                scrollMessages(format);
            }
        });
    }

    function resetChat(format) {
        const messages = $(`#aitoce-${format}-messages`);
        $(`#aitoce-${format}-input`).val('').focus();
        messages.empty();
        appendBotMessage(`Hi, how can I help?`, 'success', format);
        aitoce_message_ids[format] = aitoce_generate_message_id();
    }

    function appendUserMessage(message, format) {
        $(`#aitoce-${format}-messages`).append(`<div class="aitoce-${format}-user-message">${message}</div>`);
    }

    function appendThinking(format) {
        
        assistant_name = document.getElementById("aitoce-"+format+"-chat-header-text");
        if(assistant_name) {
            assistant_name = assistant_name.innerText;
        }else{
            assistant_name = 'NimBot';
        }

        $(`#aitoce-${format}-messages`).append(`
            <div id="aitoce-thinking" class="aitoce-${format}-bot-message">
                <b>${assistant_name}: <i class="fa-solid fa-comment"></i></b><br />
                <span class="aitoce-jumping-dots">
                    <span class="aitoce-dot-1"></span>
                    <span class="aitoce-dot-2"></span>
                    <span class="aitoce-dot-3"></span>
                </span>
            </div>
        `);
    }

    function appendBotMessage(message, state = 'success', format = 'popup') {
        assistant_name = document.getElementById("aitoce-"+format+"-chat-header-text");
        if(assistant_name) {
            assistant_name = assistant_name.innerText;
        }else{
            assistant_name = 'NimBot';
        }
        
        $('#aitoce-thinking').remove(); // remove "thinking" indicator if exists

        const icon = state === 'success' 
            ? '<i class="fa-solid fa-comment"></i>' 
            : '<i class="fa-solid fa-triangle-exclamation"></i>';

        $(`#aitoce-${format}-messages`).append(`
            <div id="aitoce-${format}-bot-message" class="aitoce-${format}-bot-message aitoce-${state}">
                <b>${assistant_name}: ${icon}</b><br>${message}
            </div>
        `);
    }

    function scrollMessages(format) {
        $(`#aitoce-${format}-messages`).animate({
            scrollTop: $(`#aitoce-${format}-messages`)[0].scrollHeight
        }, 3000);
    }

    function escapeHTML(str) {
        return str.replace(/&/g, '&amp;')
                  .replace(/</g, '&lt;')
                  .replace(/>/g, '&gt;');
    }

    function aitoce_generate_message_id() {
        return Math.random().toString(36).slice(-8) + Math.random().toString(36).slice(-8);
    }
});
