<?php

/**
 * Defines all constants used throughout the AI Tool Center plugin.
 *
 * This file sets up constant values for option names, section names, menu slugs,
 * and other identifiers used in the plugin's admin pages, settings, and API integration.
 * Using constants ensures consistency and easier maintenance across the codebase.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/constants
 * @author     sjvision <contact@ai-tool-center.com>
 */

// Prevent direct access to this file.
if (!defined('WPINC')) {
    die;
}

// Account levels (Free, Basic, Advanced)
if (!defined('AITOCE_ACCOUNT_LEVELS')) {
    define('AITOCE_ACCOUNT_LEVELS', ['Free', 'Basic', 'Advanced']);
}

// Main admin menu slug
if (!defined('AITOCE_MENU_SLUG')) {
    define('AITOCE_MENU_SLUG', 'ai-tool-center');
}

/**
 * Account Tab Settings
 * Constants for the Account settings page and its fields.
 */
if (!defined('AITOCE_MENU_SLUG_ACCOUNT')) {
    define('AITOCE_MENU_SLUG_ACCOUNT', 'ai-tool-center');
}
if (!defined('AITOCE_OPTION_SLUG_ACCOUNT')) {
    define('AITOCE_OPTION_SLUG_ACCOUNT', 'aitoce-account-settings');
}
if (!defined('AITOCE_OPTION_NAME_ACCOUNT')) {
    define('AITOCE_OPTION_NAME_ACCOUNT', 'aitoce_account');
}
if (!defined('AITOCE_OPTION_SECTION_ACCOUNT')) {
    define('AITOCE_OPTION_SECTION_ACCOUNT', 'aitoce_account_section');
}

/**
 * Agents Tab
 * Agent menu slug and table variable.
 */
if (!defined('AITOCE_MENU_SLUG_AGENTS')) {
    define('AITOCE_MENU_SLUG_AGENTS', 'aitoce-agents');
}
if (!defined('AITOCE_AGENT_TABLE')) {
    define('AITOCE_AGENT_TABLE', 'aitoce_agents');
}

/**
 * Settings Tabs.
 * PopUp settings Tab.
 * Database settings Tab.
 */
if (!defined('AITOCE_MENU_SLUG_SETTINGS')) {
    define('AITOCE_MENU_SLUG_SETTINGS', 'aitoce-settings');
}
if (!defined('AITOCE_OPTION_SLUG_DATABASE')) {
    define('AITOCE_OPTION_SLUG_DATABASE', 'aitoce-settings-database');
}
if (!defined('AITOCE_OPTION_NAME_DATABASE')) {
    define('AITOCE_OPTION_NAME_DATABASE', 'aitoce_database');
}
if (!defined('AITOCE_OPTION_SECTION_DATABASE')) {
    define('AITOCE_OPTION_SECTION_DATABASE', 'aitoce_database_section');
}
if (!defined('AITOCE_OPTION_SLUG_POPUP')) {
    define('AITOCE_OPTION_SLUG_POPUP', 'aitoce-popup-settings');
}
if (!defined('AITOCE_OPTION_NAME_POPUP')) {
    define('AITOCE_OPTION_NAME_POPUP', 'aitoce_popup');
}
if (!defined('AITOCE_OPTION_SECTION_POPUP')) {
    define('AITOCE_OPTION_SECTION_POPUP', 'aitoce_popup_section');
}