<?php
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/includes
 * @author     sjvision <contact@ai-tool-center.com>
 */
class Aitoce_ai_tool_center
{
    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     *
     * @access   protected
     * @var      Aitoce_Loader    $aitoce_loader    Maintains and registers all hooks for the plugin.
     */
    protected $aitoce_loader;

    /**
     * The unique identifier of this plugin.
     *
     * @access   protected
     * @var      string    $aitoce_plugin_name    The string used to uniquely identify this plugin.
     */
    protected $aitoce_plugin_name;

    /**
     * Define the core functionality of the plugin.
     *
     * Set the plugin name and the plugin version that can be used throughout the plugin.
     * Load the dependencies, define the locale, and set the hooks for the admin area and
     * the public-facing side of the site.
     */
    public function __construct()
    {
        $this->aitoce_plugin_name = 'ai-tool-center';

        // Load all required dependencies for the plugin
        $this->aitoce_load_dependencies();

        // Register hooks for admin area, admin pages, public site, shortcodes, and AJAX
        $this->aitoce_define_admin_hooks();
        $this->aitoce_define_admin_pages();

        $this->aitoce_define_public_hooks();
        $this->aitoce_define_shortcode_hooks();
        $this->aitoce_define_ajax_hooks();

    }

    /**
     * Load the required dependencies for this plugin.
     *
     * Loads all classes needed for admin, public, shortcodes, and AJAX functionality.
     * Instantiates the loader class that registers all hooks with WordPress.
     */
    private function aitoce_load_dependencies()
    {
        // Core loader for registering actions and filters
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-aitoce-loader.php';

        // Admin area functionality
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-aitoce-admin.php';

        // Admin pages
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/account/class-aitoce-account-page.php';

        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/agents/class-aitoce-agent-settings.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/agents/class-aitoce-agent.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/agents/class-aitoce-agent-page.php';

        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/settings/class-aitoce-settings-page.php';

        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-aitoce-notifications.php';

        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-aitoce-api.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-aitoce-options.php';

        // Public-facing functionality
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-aitoce-public.php';

        // Shortcodes
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-aitoce-shortcodes.php';

        // AJAX requests
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-aitoce-ajax-requests.php';

        // Instantiate the loader
        $this->aitoce_loader = new Aitoce_Loader();
    }

    //////////////// ADMIN /////////////////

    /**
     * Register all of the hooks related to the admin area functionality
     * of the plugin (styles, scripts, etc).
     */
    private function aitoce_define_admin_hooks()
    {
        $admin_scripts = new Aitoce_Admin($this->aitoce_get_plugin_name(), AITOCE_VERSION);
        $this->aitoce_loader->add_action('admin_enqueue_scripts', $admin_scripts, 'aitoce_enqueue_styles');
        $this->aitoce_loader->add_action('admin_enqueue_scripts', $admin_scripts, 'aitoce_enqueue_scripts');
    }

    /**
     * Register all of the hooks related to the admin Account area functionality
     * of the plugin (menu pages, settings, etc).
     */
    private function aitoce_define_admin_pages()
    {
        // Load Account page and settings
        $admin_account_page = new Aitoce_Admin_Account_Page();
        $this->aitoce_loader->add_action('admin_menu', $admin_account_page, 'aitoce_add_account_menu');
        $this->aitoce_loader->add_action('admin_init', $admin_account_page, 'aitoce_register_account_settings');

        $admin_agent_page = new Aitoce_Agents_Page();
        add_filter( 'set_screen_option_'.'elements_per_page', 
            function( $status, $option, $value ){
                return (int) $value;
            }, 10, 3 );
        $this->aitoce_loader->add_action('admin_menu', $admin_agent_page, 'aitoce_add_agents_menu');
        
        // Load Account page and settings
        $admin_settings_page = new Aitoce_Admin_Settings_Page();
        $this->aitoce_loader->add_action('admin_menu', $admin_settings_page, 'aitoce_add_settings_menu');
        $this->aitoce_loader->add_action('admin_init', $admin_settings_page, 'aitoce_register_settings_settings');
    }

    ////////////// PUBLIC ///////////////////

    /**
     * Register all of the hooks related to the public-facing functionality
     * of the plugin (styles, scripts, and footer templates).
     */
    private function aitoce_define_public_hooks()
    {
        $public_scripts = new Aitoce_Public($this->aitoce_get_plugin_name(), AITOCE_VERSION);
        // Enqueue styles and scripts for both frontend and admin (for preview)
        $this->aitoce_loader->add_action('wp_enqueue_scripts', $public_scripts, 'aitoce_enqueue_styles');

        $this->aitoce_loader->add_action('wp_enqueue_scripts', $public_scripts, 'aitoce_enqueue_scripts');
        $this->aitoce_loader->add_action('wp_footer', $public_scripts, 'aitoce_enqueue_footer_scripts');
    }

    /**
     * Register all of the hooks related to the shortcodes functionality
     * of the plugin.
     */
    private function aitoce_define_shortcode_hooks()
    {
        // Register the [nimbot-assistant] shortcode
        $shortcodes_scripts = new Aitoce_Shortcodes();
        $this->aitoce_loader->add_shortcode('nimbot-assistant', $shortcodes_scripts, 'aitoce_nimbot_page_shortcode');
    }

    /**
     * Register all of the hooks related to the ajax requests functionality
     * of the plugin.
     */
    private function aitoce_define_ajax_hooks()
    {
        // Register AJAX handlers for logged-in and guest users
        $ajax_scripts = new Aitoce_Ajax();
        $this->aitoce_loader->add_action('wp_ajax_nopriv_aitoce_ajax_request', $ajax_scripts, 'aitoce_ajax_request');
        $this->aitoce_loader->add_action('wp_ajax_aitoce_ajax_request', $ajax_scripts, 'aitoce_ajax_request');
    }

    /**
     * Run the loader to execute all of the hooks with WordPress.
     */
    public function aitoce_run()
    {
        $this->aitoce_loader->aitoce_run_hooks();
    }

    /**
     * The name of the plugin used to uniquely identify it within the context of
     * WordPress and to define internationalization functionality.
     */
    public function aitoce_get_plugin_name()
    {
        return $this->aitoce_plugin_name;
    }

    /**
     * The reference to the class that orchestrates the hooks with the plugin.
     */
    public function aitoce_get_loader()
    {
        return $this->aitoce_loader;
    }

}
