<?php
/**
 * The shortcodes functionality of the plugin.
 *
 * This class defines and registers shortcodes for displaying the NimBot chatbot
 * on the public-facing side of the WordPress site. It also provides examples for
 * enqueuing the necessary styles and scripts for the chatbot interface.
 *
 * @package         ai-tool-center
 * @subpackage      Aitoce/includes
 * @author          sjvision <contact@ai-tool-center.com>
 */
class Aitoce_Shortcodes
{
    /**
     * Register the nimbot display on page shortcode for the public-facing side of the site.
     *
     * Usage: [nimbot-assistant id=#] to show the chatbot on any page or widget.
     * Outputs the HTML structure for the NimBot chat interface, including header,
     * messages area, and input controls.
     * 
     * @since   1.0.0
     * @return  bool|string The buffered HTML for the chatbot, or false on failure.
     */
    public function aitoce_nimbot_page_shortcode($attr): bool|string
    {
        if(!isset($attr['id']) || empty($attr['id']) || !is_numeric($attr['id'])){
            return false;
        }else{
            $id = sanitize_text_field(wp_unslash($attr['id']));
        }

        $agent = new Aitoce_Agent_Settings();

        $mysql_agent_data = $agent->aitoce_get_agent_data($id);
        if($mysql_agent_data){
                    
            $agent->aitoce_load_mysql_into_form($mysql_agent_data);
        }

        ob_start();
        ?>
        
        <style>
            .aitoce-page-chat-box {
                border-top-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
                border-top-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
                border-bottom-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
                border-bottom-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
            }

            .aitoce-page-chat-header {
                color: <?php echo esc_attr($agent->styling['aitoce_agent_header_text']); ?>;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_header_background']); ?>;
                border-top-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
                border-top-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
            }

            .aitoce-page-chat-input-area {
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_header_background']); ?>;
                border-bottom-left-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
                border-bottom-right-radius: <?php echo esc_attr($agent->styling['aitoce_agent_header_radius']); ?>px;
            }

            .aitoce-page-chat-messages {
                height: <?php echo esc_attr($agent->styling['aitoce_agent_background_height']); ?>px;
                max-height: <?php echo esc_attr($agent->styling['aitoce_agent_background_height']); ?>px;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_background_background']); ?>;
            }

            .aitoce-page-chat-input {
                color: <?php echo esc_attr($agent->styling['aitoce_agent_input_text']); ?>;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_input_background']); ?>;
                border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_input_radius']); ?>px;
            }

            .aitoce-page-user-message {
                color: <?php echo esc_attr($agent->styling['aitoce_agent_client_text']); ?>;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_client_background']); ?>;
                border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_client_radius']); ?>px;
            }

            .aitoce-page-bot-message {
                color: <?php echo esc_attr($agent->styling['aitoce_agent_nimbot_text']); ?>;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_nimbot_background']); ?>;
                border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_nimbot_radius']); ?>px;
            }

            .aitoce-page-send-btn {
                color: <?php echo esc_attr($agent->styling['aitoce_agent_button_text']); ?>;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_button_background']); ?>;
                border-radius: <?php echo esc_attr($agent->styling['aitoce_agent_button_radius']); ?>px;
            }

            .aitoce-page-send-btn:hover {
                color: <?php echo esc_attr($agent->styling['aitoce_agent_button_hover_text']); ?>;
                background-color: <?php echo esc_attr($agent->styling['aitoce_agent_button_hover_background']); ?>;
            }
        </style>

        <?php 
        $nimbot_reply_greeting = (isset($agent->styling['aitoce_agent_nimbot_greeting']) && !empty($agent->styling['aitoce_agent_nimbot_greeting'])) ? $agent->styling['aitoce_agent_nimbot_greeting'] : 'Hi, How can I help?';
        ?>

        <div id="aitoce-page-container" class="aitoce-page-container">
            <div id="aitoce-page-chat-box" class="aitoce-page-chat-box">
                <div id="aitoce-chat-header" class="aitoce-page-chat-header">
                    <div id="aitoce-page-chat-header-text" class="aitoce-chat-header-text" agent-id="<?php echo esc_attr($id); ?>">
                        <?php echo esc_html($agent->connection['aitoce_agent_name']); ?>
                    </div>
                    <i id="aitoce-page-refresh-chat" class="fa-solid fa-arrows-rotate" title="Reset"></i>
                </div>
                <div id="aitoce-page-messages" class="aitoce-page-chat-messages">
                    <div id="aitoce-page-bot-message" class="aitoce-page-bot-message">
                        <b><?php echo esc_html($agent->connection['aitoce_agent_name']); ?>: <i class="fa-solid fa-comment"></i></b><br><?php echo esc_html($nimbot_reply_greeting); ?>
                    </div>
                </div>
                <div id="aitoce-chat-input-area" class="aitoce-page-chat-input-area">
                    <textarea id="aitoce-page-input" class="aitoce-page-chat-input" rows="3"
                        placeholder="<?php esc_html_e('Type a message...', 'ai-tool-center'); ?>" aria-label="Page Message Input"></textarea>
                    <div id="aitoce-page-send-btn" class="aitoce-page-send-btn">
                        <?php esc_html_e('Send', 'ai-tool-center'); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}
