<?php
/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/includes
 * @author     sjvision <contact@ai-tool-center.com>
 */
class Aitoce_Deactivator
{
	public static function aitoce_deactivate()
	{
		global $wpdb;
		
		$options = new Aitoce_Admin_Options();
		// Check if delete setting is selected
		$delete = $options->aitoce_get_option(AITOCE_OPTION_NAME_DATABASE);

		if (isset($delete['delete_account_options']) && $delete['delete_account_options'] === 1) {
			delete_option(AITOCE_OPTION_NAME_ACCOUNT);
			delete_option(AITOCE_OPTION_NAME_DATABASE);
		}

		if (isset($delete['delete_agents_options']) && $delete['delete_agents_options'] === 1) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery
			$wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %i", $wpdb->prefix.AITOCE_AGENT_TABLE));
		}

		if (isset($delete['delete_popup_options']) && $delete['delete_popup_options'] === 1) {
			delete_option(AITOCE_OPTION_NAME_POPUP);
		}
	
	}
}
