<?php
/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/includes
 * @author     sjvision <contact@ai-tool-center.com>
 */
class Aitoce_Activator
{
	public static function aitoce_activate()
	{
// phpcs:disable WordPress.DB.DirectDatabaseQuery
		global $wpdb;

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';

		// dynamic table generating code for reviewTypes
		if ($wpdb->get_var("SHOW tables LIKE '%i'", $wpdb->prefix . AITOCE_AGENT_TABLE) != '".$wpdb->prefix.AITOCE_AGENT_TABLE."') {

			$agent_table_query = "CREATE TABLE `" . $wpdb->prefix . AITOCE_AGENT_TABLE . "` (
			`agent_id` int(11) NOT NULL AUTO_INCREMENT,
			`agent_name` varchar(32) NOT NULL,
			`agent_description` text DEFAULT NULL,
			`agent_provider` varchar(32) DEFAULT 'openai' NOT NULL,
			`agent_custom_interface` varchar(32) DEFAULT NULL,
			`agent_url` varchar(255) NOT NULL,
			`agent_api_key` varchar(255) NOT NULL,
			`agent_model` varchar(32) NOT NULL,
			`agent_role` text NOT NULL,
			`agent_retention` int NOT NULL,
			`agent_transcript` int NOT NULL,
			`agent_pages` text DEFAULT NULL,
			`agent_posts` text DEFAULT NULL,
			`agent_styling` longtext DEFAULT NULL,
			`created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
			PRIMARY KEY (`agent_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

			dbDelta($agent_table_query);
		}
	}
}