<?php

/**
 * @wordpress-plugin
 * Plugin Name:			AI Tool Center
 * Plugin URI:			https://ai-tool-center.com/
 * Description:			AI Tool Center is your one stop shop for all your AI needs. AI Tool Center comes with NimBot our default assistant.
 * Version:				1.3.0
 * Requires at least:	6.2
 * Requires PHP:		7.4
 * Author:				sjvision
 * License:				GPL-2.0+
 * License URI:			http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:			ai-tool-center
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 */
if (!defined('AITOCE_VERSION')) {
	define('AITOCE_VERSION', '1.3.0');
}

/**
 * Define plugin constants.
 */
require_once plugin_dir_path(__FILE__) . 'includes/define-aitoce-constants.php';

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-aitoce-activator.php
 */
function aitoce_activate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-aitoce-activator.php';
	Aitoce_Activator::aitoce_activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-aitoce-deactivator.php
 */
function aitoce_deactivate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-aitoce-deactivator.php';
	Aitoce_Deactivator::aitoce_deactivate();
}

register_activation_hook(__FILE__, 'aitoce_activate');
register_deactivation_hook(__FILE__, 'aitoce_deactivate');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-aitoce.php';

/**
 * Begins execution of the plugin.
 */
function aitoce_run_aitoce()
{

	$plugin = new Aitoce_ai_tool_center();
	$plugin->aitoce_run();

}
aitoce_run_aitoce();
