<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * This partial template renders the settings page for the Model configuration
 * in the WordPress admin area. It displays the plugin header, logo, and the
 * settings form for configuring custom LLM provider options.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/admin/settings-display
 * @author     sjvision <contact@ai-tool-center.com>
 */

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly for security

// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage

echo '
<div id="aitoce-settings-tabs">
    <div class="aitoce-header">
        <h1 class="aitoce-admin-header">
            <img src="' . esc_url(plugins_url("images/knot.png", __DIR__)) . '"  alt="AI Tool Center Icon" style="vertical-align: middle;" width="35" height="35" /> AI Tool Center <img src="' . esc_url(plugins_url("images/nimbot-head-left.png", __DIR__)) . '" alt="Nimbot Head" style="vertical-align: middle; margin-left: 10px; margin-bottom: 5px;" width="46" height="37" />
        </h1>';
        // Display any admin settings errors or notifications
        settings_errors();
echo '
        <div id="aitoce-settings-buttons" class="aitoce-tabs">
            <ul>
                <li><a href="#popup">PopUp</a></li>
                <li><a href="#database">Database</a></li>
                <li><a href="#trouble-shoot">Trouble Shoot</a></li>
            </ul>
        </div>
    </div>';
echo '
    <div id="popup">
        <form id="aitoce-popup-form" class="aitoce-admin-form" method="post" action="options.php#popup">
            <div class="aitoce-wrapper">';
                // Output security fields for the registered setting
                settings_fields(AITOCE_OPTION_SLUG_POPUP);
                // Output all settings sections and fields for this page
                do_settings_sections(AITOCE_OPTION_SLUG_POPUP);
                // Output the submit button
    echo '
                <p><input type="submit" name="submit" id="submit-popup" class="button button-primary aitoce-button" value="Save Changes"></p>
            </div>
        </form>
    </div>

    <div id="database">        
        <form id="aitoce-database-form" class="aitoce-admin-form" method="post" action="options.php#database">
            <div class="aitoce-wrapper">';
                // Output security fields for the registered setting
                settings_fields(AITOCE_OPTION_SLUG_DATABASE);
                // Output all settings sections and fields for this page
                do_settings_sections(AITOCE_OPTION_SLUG_DATABASE);
                // Output the submit button
    echo '
                <p><input type="submit" name="submit" id="submit-database" class="button button-primary aitoce-button" value="Save Changes"></p>
            </div>
        </form>
    </div>

    <div id="trouble-shoot">        
        <form id="aitoce-database-form" class="aitoce-admin-form" method="post" action="options.php#database">
            <div class="aitoce-wrapper">
                <table class="form-table" role"presentation">
                    <tbody>
                        <tr>
                            <td width="50%"><h1>Instructions</h1>
                            <p>To view any possible setup errors you can use Google Chrome DevTools.</p>
                            <ol>
                            <li>To use right click on mouse over website page with the Agent on, select Inspect.</li>
                            <li>In the header of the new window select Console.</li>
                            <li>Send a message / question with Agent.</li>
                            <li>When the Agent replies you will see >Object in the Console window and if you expand this you will see if there are any errors.</li>
                            </ol></td>
                            <td><h3>Example</h3>
                            {success: false, data: {…}}<br/>
                            &nbsp;&nbsp;data:<br/>
                            &nbsp;&nbsp;{message: "No agents configured. - Code: 0x80001005", assistant: "Assistant Offline!"}<br/>
                            &nbsp;&nbsp;success: false<br/>
                            &nbsp;&nbsp;[[Prototype]]: Object</td>
                        </tr>
                    </tbody>
                </table>
                <table class="form-table" role"presentation">
                    <tbody>
                        <tr>
                            <th colspan="2"><h1>Plugin And API Receiver Code Errors</h1><h3>Plugin Errors</h3></th>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80000001<br/>Invalid Account - May not have an Account or wrong Account API Key or Domain Name.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80001001<br/>Agent ID missing or invalid.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80001002<br/>Message ID missing or invalid.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80001003<br/>Last prompt / client message missing / null.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80001004<br/>Prompt / message format missing (popup or page).</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80001005<br/>No agents configured.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80001006<br/>Requested agent not found. Free accounts, only first Agent used. Basic accounts, Agent must be one of first 3 Agents listed. Advanced accounts, all agents available.</td>
                        </tr>
                        <tr>
                            <th colspan="2"><h3>Receiver Errors</h3></th>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80002001<br/>Account API Key invalid or Referring Domain invalid.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80002003<br/>Own LLM Model details missing $llm_api_url, $llm_api_key, $llm_model.</td>
                        </tr>
                        <tr>
                            <th>Code :<br/>Error :</th>
                            <td>0x80002004<br/>Missing or invalid message ID or prompt content.</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </form>
    </div>
</div>';
    