jQuery(document).ready(function ($) {
    $("#aitoce-settings-tabs").tabs(); // this activates jQuery UI tabs
    $("#aitoce-model-tabs").tabs(); // this activates jQuery UI tabs
    $('.my-color-field').wpColorPicker(); // This activates the jQuery color picker

    $( document ).tooltip({
      position: {
        my: "center bottom-20",
        at: "center top",
        using: function( position, feedback ) {
          $( this ).css( position );
          $( "<div>" )
            .addClass( "arrow" )
            .addClass( feedback.vertical )
            .addClass( feedback.horizontal )
            .appendTo( this );
        }
      }
    });

    
    // Show hide LLM provider options
    var provider = $('input[name="aitoce_agent_provider"]:checked').val();
    if(provider === 'claude') {
      show_claude();
    }else if(provider === 'custom') {
      show_custom();
    }else {
      show_openai();
    }
    $("#aitoce-openai-options").click(() => show_openai());
    $("#aitoce-claude-options").click(() => show_claude());
    $("#aitoce-custom-options").click(() => show_custom());

    function show_openai(){
      $("#aitoce-openai-model").show();
      $("#aitoce-claude-model").hide();
      $("#aitoce-custom-interface").hide();
      $("#aitoce-custom-url").hide();
      $("#aitoce-custom-model").hide();
    }

    function show_claude(){
      $("#aitoce-openai-model").hide();
      $("#aitoce-claude-model").show();
      $("#aitoce-custom-interface").hide();
      $("#aitoce-custom-url").hide();
      $("#aitoce-custom-model").hide();
    }

    function show_custom() {
      $("#aitoce-openai-model").hide();
      $("#aitoce-claude-model").hide();
      $("#aitoce-custom-interface").show();
      $("#aitoce-custom-url").show();
      $("#aitoce-custom-model").show();
    }

});


function aitoceCopyToClipboard(content, id) {
  // Get the text field
  var copyText = document.getElementById(content);

  // Copy the text inside the text field
  navigator.clipboard.writeText(copyText.innerText);

  document.getElementById(id).classList.remove("aitoce-blue");
  document.getElementById(id).classList.remove("fa-copy");
  document.getElementById(id).classList.add("fa-check");
  document.getElementById(id).classList.add("aitoce-green");
  document.getElementById(id).title = 'Copied to clipboard';

}