<?php

/**
 * The admin-specific notification functionality of the plugin.
 *
 * This class handles displaying admin error and notification messages
 * in the WordPress dashboard for the AI Tool Center plugin.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/admin/notifications
 * @author     sjvision <contact@ai-tool-center.com>
 */
class Aitoce_Admin_Notifications
{
    /**
     * Display relevant admin error messages based on account and model settings.
     *
     * Checks the user's account status and LLM settings, and displays
     * error notifications if there are issues with the account or configuration.
     */
    public function aitoce_display_admin_errors()
    {
        $api_call = new Aitoce_Api;
        $account_membership = $api_call->aitoce_get_account();

        $agent = new Aitoce_Agent_Settings();
        $mysql_agent_data = $agent->aitoce_get_agent_data('ALL');

        // Check if the account is valid.
        if (!in_array($account_membership['label'], AITOCE_ACCOUNT_LEVELS, true)) {

            $type = 'error';
            $message = __( 'It looks like your <strong>Account Membership</strong> or <strong>API Key</strong> is missing or invalid. Head over to <a href="https://ai-tool-center.com" target="_blank">ai-tool-center.com</a> to check your account details and get your API key.', 'ai-tool-center' );

            add_settings_error(
                'aitoce-admin-notice',
                esc_attr( 'settings_updated' ),
                $message,
                $type
            );
        }

        // Check if any Agents created.
        if (!$mysql_agent_data || count($mysql_agent_data) <= 0) {

            $type = 'error';
            $message = __( 'You will need to create an Agent to be able to use AI Tool Centers, AI NimBot Assistant. You can create an Agent <a href="/wp-admin/admin.php?page=aitoce-agents">Here</a>.', 'ai-tool-center' );

            add_settings_error(
                'aitoce-admin-notice',
                esc_attr( 'settings_updated' ),
                $message,
                $type
            );
        }
    }
    
}