<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/admin
 * @author     sjvision <contact@ai-tool-center.com>
 */
class Aitoce_Admin
{
	private $aitoce_plugin_name;
	private $aitoce_version;
	private $aitoce_pages;

	public function __construct($aitoce_plugin_name, $aitoce_version)
	{
		$this->aitoce_plugin_name = "aitoce-{$aitoce_plugin_name}";
		$this->aitoce_version = $aitoce_version;
		$this->aitoce_pages = ['toplevel_page_ai-tool-center', 'ai-tool-center_page_aitoce-agents', 'ai-tool-center_page_aitoce-model', 'ai-tool-center_page_aitoce-popup', 'ai-tool-center_page_aitoce-page', 'ai-tool-center_page_aitoce-settings'];
	}

	/**
	 * Register the stylesheets for the admin area.
	 */
	public function aitoce_enqueue_styles($page)
	{
		if (in_array($page, $this->aitoce_pages)) {
			wp_enqueue_style("{$this->aitoce_plugin_name}-admin", plugin_dir_url(__FILE__) . 'css/aitoce-admin.css', [], $this->aitoce_version, 'all');

			wp_enqueue_style("{$this->aitoce_plugin_name}-jquery", plugin_dir_url(__FILE__) . 'css/aitoce-admin-jquery.css', ['wp-color-picker'], $this->aitoce_version, 'all');

			// Enqueue Google Fonts stylesheet
			wp_enqueue_style("{$this->aitoce_plugin_name}-google-fonts", 'https://fonts.googleapis.com/css?family=Audiowide:400', [], $this->aitoce_version, false);

			// Load FontAwesome icon styles
			wp_enqueue_style("{$this->aitoce_plugin_name}-fontAwesome-main", plugin_dir_url(__FILE__) . '../public/css/fontAwesome-main.min.css', [], "6.7.2", 'all');
			wp_enqueue_style("{$this->aitoce_plugin_name}-fontAwesome-regular", plugin_dir_url(__FILE__) . '../public/css/fontAwesome-regular.min.css', [], "6.7.2", 'all');
			wp_enqueue_style("{$this->aitoce_plugin_name}-fontAwesome-solid", plugin_dir_url(__FILE__) . '../public/css/fontAwesome-solid.min.css', [], "6.7.2", 'all');
		}
	}

	/**
	 * Register the JavaScript for the admin area.
	 */
	public function aitoce_enqueue_scripts($page)
	{
		if (in_array($page, $this->aitoce_pages)) {
			wp_enqueue_script("{$this->aitoce_plugin_name}-jquery", plugin_dir_url(__FILE__) . 'js/aitoce-admin-jquery.js', ['jquery', 'jquery-ui-tabs', 'jquery-ui-tooltip', 'wp-color-picker'], $this->aitoce_version, false);

			wp_enqueue_script("{$this->aitoce_plugin_name}-ajax", plugin_dir_url(__FILE__) . 'js/aitoce-admin-ajax.js', ['jquery'], $this->aitoce_version, false);

			// Setup local variable for the ajax route, name must match js script name
			wp_localize_script("{$this->aitoce_plugin_name}-ajax", 'ai_tool_center_ajax', [
				"name" => "AI Tool Center Ajax",
				'ajax_url' => admin_url('admin-ajax.php'),
				'security' => wp_create_nonce('aitoce_ajax_nonce') // Optional for security
			]);
		}
	}
}
