<?php

/**
 * @package    ai-tool-center
 * @subpackage Aitoce/admin/agent
 * @author     sjvision <contact@ai-tool-center.com>
 */

// Loading WP_List_Table class file
// We need to load it as it's not automatically loaded by WordPress
if (!class_exists('WP_List_Table')) {
      require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

class Aitoce_Agent extends WP_List_Table
{
    private $account_membership;

    // define $table_data property
    private $table_data;

    // Define table columns
    public function get_columns()
    {
        $columns = [
                'cb'                        => '<input type="checkbox" />',
                'agent_name'                => __('Name', 'ai-tool-center'),
                'agent_description'         => __('Description', 'ai-tool-center'),
                'agent_provider'            => __('Provider', 'ai-tool-center'),
                'agent_model'               => __('Model', 'ai-tool-center'),
                'agent_custom_interface'    => __('Interface', 'ai-tool-center'),
                'agent_styling'             => __('Styling', 'ai-tool-center'),
                'agent_shortcode'           => __('Shortcode', 'ai-tool-center')
        ];
        return $columns;
    }

    // Bind table with columns, data and all
    public function prepare_items()
    {
        // phpcs:disable WordPress.Security.NonceVerification

        // Delete agents
        ((isset($_POST['action']) && $_POST['action'] === 'delete_all') || (isset($_GET['action']) && $_GET['action'] === 'delete_agent'))? $this->aitoce_delete_agent():'';
        
        // Search agents if required
        $search = isset($_POST['s'])? sanitize_text_field(wp_unslash($_POST['s'])):'';
        !empty($search)?
            $this->table_data = $this->aitoce_get_table_data($search)
        :
            $this->table_data = $this->aitoce_get_table_data();

        $columns = $this->get_columns();

        $hidden = ( is_array(get_user_meta( get_current_user_id(), 'manageai-tool-center_page_'.AITOCE_MENU_SLUG_AGENTS.'columnshidden', true)) ) ? get_user_meta( get_current_user_id(), 'manageai-tool-center_page_'.AITOCE_MENU_SLUG_AGENTS.'columnshidden', true) : ['agent_custom_interface'];

        $sortable = $this->get_sortable_columns();

        $primary  = 'agent_name';

        $this->_column_headers = [$columns, $hidden, $sortable, $primary];

        usort($this->table_data, [&$this, 'usort_reorder']);
        
        /* pagination */
        $per_page_option = get_current_screen()->get_option('per_page');
        $per_page = get_user_meta( get_current_user_id(), $per_page_option['option'], true ) ?: $per_page_option['default'];

        $current_page = $this->get_pagenum();
        $total_items = count($this->table_data);

        $this->table_data = array_slice($this->table_data, ($current_page - 1) * $per_page, $per_page);

        $this->set_pagination_args(array(
                'total_items' => $total_items, // total number of items
                'per_page'    => $per_page, // items to show on a page
                'total_pages' => ceil( $total_items / $per_page ) // use ceil to round up
        ));
        
        $this->items = $this->table_data;
    }

    private function aitoce_get_table_data($search = '') {
        // phpcs:disable WordPress.DB
        
        global $wpdb;

        // Need to load default settings manually
        $settings = new Aitoce_Agent_Settings();

        $table_name = esc_sql($wpdb->prefix . AITOCE_AGENT_TABLE);
        if ( !empty($search) ) {
            $search = esc_sql($search);

            $sql = "SELECT * FROM {$table_name} WHERE agent_name Like '%{$search}%' OR agent_description Like '%{$search}%'";
            $result_data = (array) $wpdb->get_results($sql,
                ARRAY_A
            );
        }else{
            $sql = "SELECT * FROM {$table_name}";
            $result_data = (array) $wpdb->get_results($sql,
                ARRAY_A
            );
        }
      
        // Translate the data to display in the list
        for ($i=0; $i < count($result_data); $i++) { 
            $result_data[$i]['agent_description'] = (!empty($result_data[$i]['agent_description']))?substr($result_data[$i]['agent_description'], 0, 80).'...':'';
            $result_data[$i]['agent_shortcode'] = '<span id="aitoce-shortcode-'.$i.'" class="aitoce-shortcode">[nimbot-assistant id='.$result_data[$i]['agent_id'].']</span> <span class="aitoce-copy-shortcode"><i id="aitoce-copy-shortcode-'.$i.'" class="fa-solid fa-copy aitoce-blue" title="Copy to clipboard" onclick="aitoceCopyToClipboard(\'aitoce-shortcode-'.$i.'\', \'aitoce-copy-shortcode-'.$i.'\');"></i></span>';
            $result_data[$i]['agent_provider'] = $settings->providers[$result_data[$i]['agent_provider']];
            $result_data[$i]['agent_custom_interface'] = $settings->interfaces[$result_data[$i]['agent_custom_interface']];
            $style = json_decode($result_data[$i]['agent_styling'], true);
            $result_data[$i]['agent_styling'] = '
            <div id="aitoce-style-header" class="aitoce-style-header" style="color:'.$style['aitoce_agent_header_text'].';background-color:'.$style['aitoce_agent_header_background'].';border-radius:'.$style['aitoce_agent_header_radius'].'px '.$style['aitoce_agent_header_radius'].'px 0 0;"><strong>NimBot</strong></div>            
            <div id="aitoce-style-background" class="aitoce-style-background" style="background-color:'.$style['aitoce_agent_background_background'].';border-radius:0 0 '.$style['aitoce_agent_header_radius'].'px '.$style['aitoce_agent_header_radius'].'px;">
                <div class="aitoce_style_client" style="background-color:'.$style['aitoce_agent_client_background'].';"></div>
                <div class="aitoce_style_nimbot" style="background-color:'.$style['aitoce_agent_nimbot_background'].';"></div>
                <div class="aitoce_style_button" style="background-color:'.$style['aitoce_agent_button_background'].';"></div>
            </div>';
        }

        return $result_data;
    }
    
    // Defaults
    public function column_default($item, $column_name)
    {
        switch ($column_name) {
            case 'agent_id':
            case 'agent_name':
            case 'agent_description':
            case 'agent_provider':
            case 'agent_model':
            case 'agent_styling':
            case 'agent_shortcode':
            default:
                return $item[$column_name];
        }
    }

    public function column_cb($item)
    {
        return sprintf(
                '<input type="checkbox" name="element[]" value="%s" />',
                $item['agent_id']
        );
    }

    protected function get_sortable_columns()
    {
        $sortable_columns = [
                'agent_name'  => ['agent_name', false],
                'agent_provider' => ['agent_provider', false],
                'agent_model' => ['agent_model', false],
        ];
        return $sortable_columns;
    }
    
    // Sorting function
    public function usort_reorder($a, $b)
    {
        // phpcs:disable WordPress.Security.NonceVerification
        // If no sort, default to user_login
        $orderby = (!empty($_GET['orderby'])) ? sanitize_text_field(wp_unslash($_GET['orderby'])) : 'agent_id';

        // If no order, default to asc
        $order = (!empty($_GET['order'])) ? sanitize_text_field(wp_unslash($_GET['order'])) : 'asc';

        // Determine sort order
        $result = $a[$orderby] <=> $b[$orderby];

        // Send final sort direction to usort
        return ($order === 'asc') ? $result : -$result;
    }

    // Adding action links to column
    public function column_agent_name($item)
    {
        $edit_nonce = wp_create_nonce( 'edit_agent_wpnonce' );
        $delete_nonce = wp_create_nonce( 'delete_agent_wpnonce' );

        $actions = [
            'edit' => sprintf('<a href="?page='.AITOCE_MENU_SLUG_AGENTS.'&action=edit_agent&element=%s&_wpnonce='.esc_attr($edit_nonce).'">' . __('Edit', 'ai-tool-center') . '</a>', $item['agent_id']),
            'delete' => sprintf('<a href="?page='.AITOCE_MENU_SLUG_AGENTS.'&action=delete_agent&element=%s&_wpnonce='.esc_attr($delete_nonce).'">' . __('Delete', 'ai-tool-center') . '</a>', $item['agent_id']),
        ];

        return sprintf('%1$s %2$s', $item['agent_name'], $this->row_actions($actions));
    }
    
    // To show bulk action dropdown
    public function get_bulk_actions()
    {
        $actions = [
            'delete_all'    => __('Delete', 'ai-tool-center')
        ];
        return $actions;
    }

    private function aitoce_delete_agent(){

		global $wpdb;
    
        if(isset($_GET['action']) && $_GET['action'] === 'delete_agent'){
            if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'delete_agent_wpnonce')) {
                return;
            }
            $element[] = isset($_GET['element'])? sanitize_text_field(wp_unslash($_GET['element'])):[];
        }
        
        if(isset($_POST['action']) && $_POST['action'] === 'delete_all'){
            if (!isset($_POST['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), sanitize_key('bulk-Agents'))) {
                return;
            }
            $element = isset($_POST['element'])? array_map('sanitize_text_field', wp_unslash($_POST['element'])):[];
        }

        $table_name = $wpdb->prefix.AITOCE_AGENT_TABLE;
        foreach ($element as $key => $value) {

            $wpdb->delete($table_name, ['agent_id' => $value], ['%s']);

            $type = 'success';
            $message = 'Deleted Agent ID:'.esc_attr($value).' Successfully.';

            add_settings_error(
                'aitoce-admin-notice',
                esc_attr( 'settings_updated' ),
                $message,
                $type
            );
        }
        
    }
    
    // To show bulk action dropdown
    public function aitoce_display_agent_list()
    {
        $api_call = new Aitoce_Api;
        $raw_account_level = $api_call->aitoce_get_account();

        $this->account_membership = [
            'label' => in_array($raw_account_level['label'], AITOCE_ACCOUNT_LEVELS) ? sanitize_text_field($raw_account_level['label']) : 'Free',
            'level' => isset($raw_account_level['level']) ? intval($raw_account_level['level']) : 0,
            'status' => isset($raw_account_level['status']) ? intval($raw_account_level['status']) : 0,
        ];

        // phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
        echo '
            <div class="aitoce-header">
                <h1 class="aitoce-admin-header">
                    <img src="' . esc_url(plugins_url("images/knot.png", __DIR__)) . '"  alt="AI Tool Center Icon" style="vertical-align: middle;" width="35" height="35" /> AI Tool Center <img src="' . esc_url(plugins_url("images/nimbot-head-left.png", __DIR__)) . '" alt="Nimbot Head" style="vertical-align: middle; margin-left: 10px; margin-bottom: 5px;" width="46" height="37" />
                </h1>';
                
        // Display errors
        settings_errors();
        echo '
                    <div id="aitoce-settings-buttons" class="aitoce-tabs">
                        <ul>
                            <li><a href="/wp-admin/admin.php?page='.esc_attr(AITOCE_MENU_SLUG_AGENTS).'&action=add_agent">Add Agent</a></li>
                        </ul>
                    </div>
            </div>';

        echo '
            <form method="post" action="/wp-admin/admin.php?page=aitoce-agents">
                <div class="aitoce-wrapper">
                    <h2 class="aitoce-section-header">Agents</h2>';
                
                    // Prepare table
                    $this->prepare_items();

                    if($this->account_membership['label'] === 'Basic'){
                        $upgrade = (count($this->aitoce_get_table_data()) >= 3)? ' aitoce-red':'';
                        echo '<span class="aitoce-admin-header aitoce-agent-count-header">Agents: </span><span class="aitoce-admin-header aitoce-agent-count'.esc_attr($upgrade).'">'.count($this->aitoce_get_table_data()).'/3</span>';

                    }elseif($this->account_membership['label'] === 'Free'){
                        $upgrade = (count($this->aitoce_get_table_data()) >= 1)? ' aitoce-red':'';
                        echo '<span class="aitoce-admin-header aitoce-agent-count-header">Agents: </span><span class="aitoce-admin-header aitoce-agent-count'.esc_attr($upgrade).'">'.count($this->aitoce_get_table_data()).'/1</span>';
                    }

                    // Number of Agents before search box appears
                    $number_of_agents = 1;
                    if(count($this->table_data) >= $number_of_agents){
                        // Search form
                        $this->search_box('search', 'search_id');
                    }

                    // Display table
                    $this->display();
        echo '
                </div>
            </form>';
    }

}