<?php

/**
 * @package    ai-tool-center
 * @subpackage Aitoce/admin/agent
 * @author     sjvision <contact@ai-tool-center.com>
 */

class Aitoce_Agent_Settings
{
    public $required_errors;

    public $rag_defaults = [
        'Free' => [
            'aitoce_agent_retention' => [
                'default' => '1',
                'max' => '1',
            ],
            'aitoce_agent_transcript' => [
                'default' => '0',
                'max' => '0',
            ],
        ],
        'Basic' => [
            'aitoce_agent_retention' => [
                'default' => '5',
                'max' => '5',
            ],
            'aitoce_agent_transcript' => [
                'default' => '24',
                'max' => '24',
            ],
        ],
        'Advances' => [
            'aitoce_agent_retention' => [
                'default' => '5',
                'max' => '50',
            ],
            'aitoce_agent_transcript' => [
                'default' => '24',
                'max' => '72',
            ],
        ]
    ];

    public $providers = [
        'openai' => 'OpenAI',
        'claude' => 'Claude',
        'custom' => 'Custom',
    ];

    public $interfaces = [
        'openai' => 'OpenAI',
        'claude' => 'Claude',
        'open_webui' => 'Open WebUI',
    ];

    public $claude_models = [
        'claude-opus-4-0' => [
            'name' => 'Claude Opus 4',
            'config' => 'claude',
            'application' => ['chat'],
            'url' => 'https://api.anthropic.com/v1/messages'
        ],
        'claude-sonnet-4-0' => [
            'name' => 'Claude Sonnet 4',
            'config' => 'claude',
            'application' => ['chat'],
            'url' => 'https://api.anthropic.com/v1/messages'
        ],
        'claude-3-7-sonnet-latest	' => [
            'name' => 'Claude Sonnet 3.7',
            'config' => 'claude',
            'application' => ['chat'],
            'url' => 'https://api.anthropic.com/v1/messages'
        ],
        'claude-3-5-sonnet-latest' => [
            'name' => 'Claude Sonnet 3.5',
            'config' => 'claude',
            'application' => ['chat'],
            'url' => 'https://api.anthropic.com/v1/messages'
        ],
        'claude-3-5-haiku-latest' => [
            'name' => 'Claude Haiku 3.5',
            'config' => 'claude',
            'application' => ['chat'],
            'url' => 'https://api.anthropic.com/v1/messages'
        ],
    ];

    public $openai_models = [
        'gpt-4.1' => [
            'name' => 'GPT-4.1',
            'config' => 'openai',
            'application' => ['chat'],
            'url' => 'https://api.openai.com/v1/responses'
        ],
        'gpt-4.1-mini' => [
            'name' => 'GPT-4.1 mini',
            'config' => 'openai',
            'application' => ['chat'],
            'url' => 'https://api.openai.com/v1/responses'
        ],
        'gpt-4.1-nano' => [
            'name' => 'GPT-4.1 nano',
            'config' => 'openai',
            'application' => ['chat'],
            'url' => 'https://api.openai.com/v1/responses'
        ],
        'o4-mini' => [
            'name' => 'o4-mini',
            'config' => 'openai',
            'application' => ['chat'],
            'url' => 'https://api.openai.com/v1/responses'
        ],
        'o3-mini' => [
            'name' => 'o3-mini',
            'config' => 'openai',
            'application' => ['chat'],
            'url' => 'https://api.openai.com/v1/responses'
        ],
    ];

    public $connection = [
        'aitoce_agent_name' => 'NimBot',
        'aitoce_agent_description' => '',
        'aitoce_agent_provider' => 'openai',
        'aitoce_agent_url' => '',
        'aitoce_agent_api_key' => '',
        'aitoce_agent_openai_interface' => 'openai',
        'aitoce_agent_openai_model' => '',
        'aitoce_agent_claude_interface' => 'claude',
        'aitoce_agent_claude_model' => '',
        'aitoce_agent_custom_interface' => 'open_webui',
        'aitoce_agent_custom_model' => '',
    ];
    public $rag = [
        'aitoce_agent_role' => 'You are a helpful assistant.',
        'aitoce_agent_retention' => '',
        'aitoce_agent_transcript' => '',
        'aitoce_agent_pages' => '',
        'aitoce_agent_posts' => '',
    ];
    public $styling = [
        'aitoce_agent_header_radius' => '8',
        'aitoce_agent_header_text' => '#fbb53b',
        'aitoce_agent_header_background' => '#2d2b33',
        'aitoce_agent_background_height' => '350',
        'aitoce_agent_background_background' => '#3e3c47',
        'aitoce_agent_client_radius' => '5',
        'aitoce_agent_client_text' => '#2d2b33',
        'aitoce_agent_client_background' => '#e4e4e4',
        'aitoce_agent_nimbot_greeting' => '',
        'aitoce_agent_nimbot_radius' => '5',
        'aitoce_agent_nimbot_text' => '#e4e4e4',
        'aitoce_agent_nimbot_background' => '#2d2b33',
        'aitoce_agent_input_radius' => '5',
        'aitoce_agent_input_text' => '#3e3c47',
        'aitoce_agent_input_background' => '#e4e4e4',
        'aitoce_agent_button_radius' => '5',
        'aitoce_agent_button_text' => '#ffffff',
        'aitoce_agent_button_background' => '#fbb53b',
        'aitoce_agent_button_hover_text' => '#ffffff',
        'aitoce_agent_button_hover_background' => '#cb9231',
    ];

    public $allowed_html = [
        'script' => [],
        'div' => [
            'id' => [],
            'class' => [],
            'disabled' => [],
        ],
        'span' => [
            'id' => [],
            'class' => [],
        ],
        'p' => [
            'id' => [],
            'class' => [],
        ],
        'br' => [],
        'ul' => [],
        'li' => [
            'id' => [],
            'class' => [],
        ],
        'i' => [
            'class' => [],
            'title' => [],
        ],
        'a' => [
            'href' => [],
        ],
        'img' => [
            'id' => [],
            'class' => [],
            'src' => [],
            'alt' => [],
            'style' => [],
            'width' => [],
            'height' => [],
        ],
        'h1' => [
            'class' => [],
        ],
        'h2' => [
            'class' => [],
        ],
        'form' => [
            'id' => [],
            'class' => [],
            'method' => [],
            'action' => [],
        ],
        'label' => [
            'id' => [],
            'class' => [],
        ],
        'input' => [
            'id' => [],
            'class' => [],
            'type' => [],
            'name' => [],
            'value' => [],
            'aria-label' => [],
            'placeholder' => [],
            'required' => [],
        ],
        'textarea' => [
            'id' => [],
            'class' => [],
            'name' => [],
            'aria-label' => [],
            'placeholder' => [],
            'rows' => [],
            'cols' => [],
            'required' => [],
        ],
        'select' => [
            'id' => [],
            'class' => [],
            'name' => [],
            'aria-label' => [],
            'disabled' => [],
        ],
        'option' => [
            'value' => [],
            'selected' => [],
            'disabled' => [],
        ],
        'table' => [
            'id' => [],
            'class' => [],
            'role' => [],
        ],
        'tbody' => [],
        'tr' => [
            'class' => [],
        ],
        'th' => [
            'id' => [],
            'class' => [],
            'colspan' => [],
            'rowspan' => [],
            'scope' => [],
        ],
        'td' => [
            'id' => [],
            'class' => [],
            'colspan' => [],
            'rowspan' => [],
            'scope' => [],
        ],
        'strong' => [
            'id' => [],
            'class' => [],
        ],
    ];

    public function aitoce_sanitize_post_data($account_membership)
    {
        if (!isset($_POST['_wpnonce']) || (!wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'add_agent_wpnonce'))) {
            return ["Unauthorized operation canceled"];
        }

        // Connection POST data
        foreach ($this->connection as $key => $value) {
            $this->connection[$key] = isset($_POST[$key]) ? sanitize_text_field(wp_unslash($_POST[$key])) : '';
        }

        // Rag POST data
        foreach ($this->rag as $key => $value) {
            $this->rag[$key] = isset($_POST[$key]) ? sanitize_text_field(wp_unslash($_POST[$key])) : '';
        }

        if (isset($_POST['aitoce_agent_transcript']) && $_POST['aitoce_agent_transcript'] === '0') {
            $this->rag['aitoce_agent_transcript'] = '0';
        }

        // Styling POST data
        foreach ($this->styling as $key => $value) {
            $this->styling[$key] = isset($_POST[$key]) ? sanitize_text_field(wp_unslash($_POST[$key])) : '';
        }

        // Check required fields.
        $required_fields = [
            'Name' => 'aitoce_agent_name',
            'API Key' => 'aitoce_agent_api_key',
        ];

        if ($this->connection['aitoce_agent_provider'] === 'claude') {
            $required_fields['Model'] = 'aitoce_agent_claude_model';
        } elseif ($this->connection['aitoce_agent_provider'] === 'custom') {
            $required_fields['Model'] = 'aitoce_agent_custom_model';
            $required_fields['API URL'] = 'aitoce_agent_url';
        } else {
            $required_fields['Model'] = 'aitoce_agent_openai_model';
        }
        foreach ($required_fields as $key => $value) {
            if (empty($this->connection[$value])) {
                $type = 'error';
                $message = '<strong>' . esc_attr($key) . '</strong> - Input field is Required!';

                add_settings_error(
                    'aitoce-admin-notice',
                    esc_attr('settings_updated'),
                    $message,
                    $type
                );
                $errors = true;
            }
        }
        if (empty($this->rag['aitoce_agent_role'])) {
            $type = 'error';
            $message = __('<strong>Role</strong> - Input field is Required!', 'ai-tool-center');

            add_settings_error(
                'aitoce-admin-notice',
                esc_attr('settings_updated'),
                $message,
                $type
            );
            $errors = true;
        }

        if (isset($errors)) {
            return false;
        } else {
            return true;
        }
    }

    public function aitoce_get_agent_data($agent_id = null, $limit_num = null)
    {
        // phpcs:disable WordPress.DB
        global $wpdb;

        if ($agent_id === null) {
            return false;
        }

        $table_name = esc_sql($wpdb->prefix . AITOCE_AGENT_TABLE);
        $condition = (is_numeric($agent_id)) ? " WHERE agent_id = {$agent_id}" : '';
        $limit = ($limit_num != null) ? " LIMIT {$limit_num}" : "";

        $sql = "SELECT * FROM {$table_name}{$condition}{$limit}";
        $result_data = $wpdb->get_results(
            $sql,
            ARRAY_A
        );

        return $result_data;
    }

    public function aitoce_load_mysql_into_form($agent_data = null)
    {

        // Return early if no agent data is found
        if (empty($agent_data) || !isset($agent_data[0])) {
            return false;
        }

        // Sanitize each field individually
        $row = array_map('sanitize_text_field', $agent_data[0]);

        $this->connection = [
            'aitoce_agent_id' => $row['agent_id'] ?? '',
            'aitoce_agent_name' => $row['agent_name'] ?? '',
            'aitoce_agent_description' => $row['agent_description'] ?? '',
            'aitoce_agent_provider' => $row['agent_provider'] ?? '',
            'aitoce_agent_url' => $row['agent_url'] ?? '',
            'aitoce_agent_api_key' => $row['agent_api_key'] ?? '',
        ];

        $this->connection['aitoce_agent_claude_interface'] = $row['agent_custom_interface'] ?? '';
        $this->connection['aitoce_agent_claude_model'] = $row['agent_model'] ?? '';
        $this->connection['aitoce_agent_custom_interface'] = $row['agent_custom_interface'] ?? '';
        $this->connection['aitoce_agent_custom_model'] = $row['agent_model'] ?? '';
        $this->connection['aitoce_agent_openai_interface'] = $row['agent_custom_interface'] ?? '';
        $this->connection['aitoce_agent_openai_model'] = $row['agent_model'] ?? '';

        // Optional structured RAG data (store if needed)
        $this->rag = [
            'aitoce_agent_role' => $row['agent_role'] ?? '',
            'aitoce_agent_retention' => $row['agent_retention'] ?? '',
            'aitoce_agent_transcript' => $row['agent_transcript'] ?? '',
            'aitoce_agent_pages' => $row['agent_pages'] ?? '',
            'aitoce_agent_posts' => $row['agent_posts'] ?? '',
        ];

        $style = json_decode($row['agent_styling'], true);
        //echo '<pre>';
        //print_r($style);
        $this->styling = [
            'aitoce_agent_header_radius' => $style['aitoce_agent_header_radius'],
            'aitoce_agent_header_text' => $style['aitoce_agent_header_text'],
            'aitoce_agent_header_background' => $style['aitoce_agent_header_background'],
            'aitoce_agent_background_height' => $style['aitoce_agent_background_height'],
            'aitoce_agent_background_background' => $style['aitoce_agent_background_background'],
            'aitoce_agent_client_radius' => $style['aitoce_agent_client_radius'],
            'aitoce_agent_client_text' => $style['aitoce_agent_client_text'],
            'aitoce_agent_client_background' => $style['aitoce_agent_client_background'],
            'aitoce_agent_nimbot_greeting' => $style['aitoce_agent_nimbot_greeting'],
            'aitoce_agent_nimbot_radius' => $style['aitoce_agent_nimbot_radius'],
            'aitoce_agent_nimbot_text' => $style['aitoce_agent_nimbot_text'],
            'aitoce_agent_nimbot_background' => $style['aitoce_agent_nimbot_background'],
            'aitoce_agent_input_radius' => $style['aitoce_agent_input_radius'],
            'aitoce_agent_input_text' => $style['aitoce_agent_input_text'],
            'aitoce_agent_input_background' => $style['aitoce_agent_input_background'],
            'aitoce_agent_button_radius' => $style['aitoce_agent_button_radius'],
            'aitoce_agent_button_text' => $style['aitoce_agent_button_text'],
            'aitoce_agent_button_background' => $style['aitoce_agent_button_background'],
            'aitoce_agent_button_hover_text' => $style['aitoce_agent_button_hover_text'],
            'aitoce_agent_button_hover_background' => $style['aitoce_agent_button_hover_background'],
        ];
    }

    public function aitoce_get_level_1_agents()
    {

        $agents = $this->aitoce_get_agent_data('', 1);
        if ($agents) {
            return $agents;
        } else {
            return [
                'error' => 'No agents configured.',
                'code' => '0x80001005'
            ];
        }
    }

    public function aitoce_get_level_2_agents($agent_id)
    {

        $agents = $this->aitoce_get_agent_data('', 3);
        if ($agents) {
            $agent_exists = false;
            foreach ($agents as $agent) {
                if ($agent['agent_id'] === $agent_id) {
                    return $agent;
                }
            }

            if (!$agent_exists) {
                return $agents[0];
            }
        } else {
            return [
                'error' => 'No agents configured.',
                'code' => '0x80001005'
            ];
        }
    }

    public function aitoce_get_level_3_agents($agent_id)
    {

        $agents = $this->aitoce_get_agent_data($agent_id);
        if ($agents) {
            return $agents;
        } else {
            $agents = $this->aitoce_get_agent_data('', 1);
            if ($agents) {
                return $agents;
            } else {
                return [
                    'error' => 'No agents configured.',
                    'code' => '0x80001005'
                ];
            }
        }
    }
}