<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * This partial template renders the settings page for the Account configuration
 * in the WordPress admin area. It displays the plugin header, logo, and the
 * settings form for entering and viewing the API key and account status.
 *
 * @package    ai-tool-center
 * @subpackage Aitoce/admin/account-display
 * @author     sjvision <contact@ai-tool-center.com>
 */

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage

echo '
    <div class="aitoce-header">
        <h1 class="aitoce-admin-header">
            <img src="' . esc_url(plugins_url("images/knot.png", __DIR__)) . '"  alt="AI Tool Center Icon" style="vertical-align: middle;" width="35" height="35" /> AI Tool Center <img src="' . esc_url(plugins_url("images/nimbot-head-left.png", __DIR__)) . '" alt="Nimbot Head" style="vertical-align: middle; margin-left: 10px; margin-bottom: 5px;" width="46" height="37" />
        </h1>';
        // Display any admin settings errors or notifications
        settings_errors();
echo '
    </div>';

echo '
    <form id="aitoce-account-form" class="aitoce-admin-form" method="post" action="options.php">
        <div class="aitoce-wrapper">';

            // Output security fields for the registered setting
            settings_fields(AITOCE_OPTION_SLUG_ACCOUNT);
            // Output all settings sections and fields for this page
            do_settings_sections(AITOCE_OPTION_SLUG_ACCOUNT);
            // Output the submit button
echo '
            <p style="margin-bottom:25px;"><input type="submit" name="submit" id="submit" class="button button-primary aitoce-button" value="Save Changes"></p>
            <div id="aitoce-account-version" class="aitoce-version">Version ' . esc_html(AITOCE_VERSION) . '</div>
        </div>
    </form>';