<?php
/**
 * AI Snippet SEO Helper — Uninstall Script
 * Version: 1.0.0
 *
 * Purpose
 * -------
 * Remove all plugin-owned data created by the helper:
 * - Options (current + legacy)
 * - Lightweight post meta used by the helper
 * - Soft caches (transients) for token-info and bulk jobs
 * - Optional user meta footprint, if present
 *
 * Notes
 * -----
 * - Rank Math fields are third-party data and are not touched.
 * - In multisite setups, WordPress may invoke this per site.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

/** 1) Plugin options (current + legacy, for back-compat) */
delete_option( 'aish_options' );  // current
delete_option( 'aish_settings' ); // legacy

/** 2) Plugin-specific post meta */
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->postmeta} WHERE meta_key IN ( %s, %s )",
		'_aish_score',
		'_aish_snippet_score'
	)
);

/** 3) Transients: token-info & bulk job caches */
$wpdb->query(
	"DELETE FROM {$wpdb->options}
	 WHERE option_name LIKE '_transient_aish_tok_%'
	    OR option_name LIKE '_transient_timeout_aish_tok_%'
	    OR option_name LIKE '_transient_aish_job_%'
	    OR option_name LIKE '_transient_timeout_aish_job_%'"
);

/** 4) Optional user meta (if the helper stored token markers) */
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->usermeta} WHERE meta_key = %s",
		'ai-snippet-seo-helper_membership_tokens'
	)
);

/* Rank Math fields (title/description/keyword/slug) are external and remain intact. */
