<?php
/* ==================================================================
 *  AI Snippet SEO Helper — Settings UI (Admin)
 *  Version: 1.0.0
 * =================================================================*/

if ( ! defined( 'ABSPATH' ) ) { exit; }

if ( ! function_exists( 'aish_register_settings' ) ) {
	function aish_register_settings() {}
}

if ( ! function_exists( 'aish_default_allowed_matrix' ) ) {
	function aish_default_allowed_matrix( $lvl = 15 ){
		return [
			15 => [ 'gpt-4-turbo' ],
			16 => [ 'gpt-4-turbo', 'gpt-4.1' ],
			17 => [ 'gpt-4-turbo', 'gpt-4.1', 'gpt-4o' ],
			18 => [ 'gpt-4-turbo', 'gpt-4.1', 'gpt-4o' ],
		][$lvl] ?? [ 'gpt-4-turbo' ];
	}
}

if ( ! function_exists( 'aish_render_settings_page' ) ) {
function aish_render_settings_page() {

	$opts  = get_option( AISH_OPT_KEY, [] );
	$token = $opts['site_token']   ?? '';
	$model = $opts['model_choice'] ?? 'gpt-4-turbo';
	$tab   = ( isset($_GET['tab']) && $_GET['tab']==='seo-settings' ) ? 'seo-settings' : 'site-key';

	/* POST handlers */
	if ( isset($_POST['aish_action']) && check_admin_referer($_POST['aish_action']) ){
		if ( ! current_user_can('manage_options') ) {
			wp_die('Insufficient permissions');
		}

		if ( $_POST['aish_action'] === 'aish_save_site_key' ){

			$newKey = sanitize_text_field( wp_unslash( $_POST['site_token'] ?? '' ) );

			try {
				$test = aish_check_token_status( $newKey, true );
			} catch (Throwable $e) {
				$test = aish_check_token_status( $newKey );
			}

			if ( ! empty( $test['error'] ) ){
				echo '<div class="notice notice-error"><p><strong>Site Key Error:</strong> '
				     . esc_html( $test['error'] ) . '</p></div>';
				unset( $opts['site_token'] );
			}else{
				$opts['site_token'] = $newKey;
				echo '<div class="notice notice-success is-dismissible"><p>Site Key saved.</p></div>';
			}
			update_option( AISH_OPT_KEY, $opts );
			$token = $opts['site_token'] ?? '';
			$tab   = 'site-key';

		}elseif ( $_POST['aish_action'] === 'aish_save_seo_settings' ){

			$mc = sanitize_text_field( wp_unslash( $_POST['model_choice'] ?? 'gpt-4-turbo' ) );
			$opts['model_choice'] = $mc;

			$opts['custom_prompt'] = sanitize_textarea_field( wp_unslash( $_POST['custom_prompt'] ?? '' ) );

			$opts['auto_slug'] = ( isset($_POST['auto_slug']) && $_POST['auto_slug'] === 'yes' )
				? 'yes' : 'no';

			update_option( AISH_OPT_KEY, $opts );
			$model = $mc;
			$tab   = 'seo-settings';
			echo '<div class="notice notice-success is-dismissible"><p>Settings saved.</p></div>';
		}
	}

	/* Token / Membership normalization */
	$usage   = $limit = $remain = $site_usage = null;
	$allowed = [ 'gpt-4-turbo' ];
	$membership = 'free';

	if ( $token ) {
		try {
			$st = aish_check_token_status( $token, true );
		} catch (Throwable $e) {
			$st = aish_check_token_status( $token );
		}

		if ( empty( $st['error'] ) ) {

			$site_usage = (int) ( $st['site_usage'] ?? 0 );

			$limit = (int) (
				$st['plan_limit_total']
				?? $st['plan_limit']
				?? $st['token_limit']
				?? 0
			);

			$usage_total = null;
			foreach ( ['usage_total','all_usage','total_usage','token_usage','usage'] as $k ){
				if ( isset($st[$k]) ) { $usage_total = (int)$st[$k]; break; }
			}

			$remain_total = null;
			foreach ( ['remaining_total','remaining_all','global_remaining'] as $k ){
				if ( isset($st[$k]) ) { $remain_total = (int)$st[$k]; break; }
			}
			if ( $remain_total === null && isset($st['remaining']) ) {
				$remain_total = (int)$st['remaining'];
			}

			if ( $usage_total === null && $limit > 0 && $remain_total !== null ) {
				$usage_total = max(0, $limit - $remain_total);
			}
			if ( $remain_total === null && $limit > 0 && $usage_total !== null ) {
				$remain_total = max(0, $limit - $usage_total);
			}
			if ( $usage_total === null ) {
				$usage_total = max( 0, (int)$site_usage );
			}

			$usage  = (int) $usage_total;
			$remain = (int) aish_status_remaining( $st );

			if ( ! empty( $st['allowed_models'] ) && is_array( $st['allowed_models'] ) ) {
				$allowed = array_values( array_unique( array_map( 'strval', $st['allowed_models'] ) ) );
			}
		}
	}

	if ( function_exists( 'pmpro_getMembershipLevelForUser' ) ) {
		$lvlObj = pmpro_getMembershipLevelForUser();
		$lvlId  = $lvlObj ? (int) $lvlObj->id : 15;

		if ( $membership === 'free' ) {
			if     ( $lvlId === 18 ) $membership = 'expert';
			elseif ( $lvlId === 17 ) $membership = 'creator';
			elseif ( $lvlId === 16 ) $membership = 'starter';
		}
	}

	switch ( $membership ) {
		case 'starter':
			$allowed = [ 'gpt-4-turbo', 'gpt-4.1' ];
			break;

		case 'creator':
		case 'expert':
			$allowed = [ 'gpt-4-turbo', 'gpt-4.1', 'gpt-4o' ];
			break;

		default:
			$membership = 'free';
			$allowed    = [ 'gpt-4-turbo' ];
	}

	$user_id     = get_current_user_id();
	$plan_tokens = (int) get_user_meta(
	    $user_id,
	    'ai-snippet-seo-helper_membership_tokens',
	    true
	);
	if ( $plan_tokens > 25 && $membership === 'free' ) {
	    $membership = 'starter';
	    $allowed    = [ 'gpt-4-turbo', 'gpt-4.1' ];
	}

	if ( is_int($limit) && $limit <= 25 ) {
	    $membership = 'free';
	    $allowed    = [ 'gpt-4-turbo' ];
	} else {
	    if ( $membership === 'free' ) {
	        $membership = 'starter';
	        $allowed    = [ 'gpt-4-turbo', 'gpt-4.1' ];
	    }
	}

	if ( ! in_array( $model, $allowed, true ) ) {
		$model = 'gpt-4-turbo';
		$opts['model_choice'] = $model;
		update_option( AISH_OPT_KEY, $opts );
	}

	if ( $membership === 'free' ) {
		$token_btn_label = 'GET PREMIUM NOW';
		$token_btn_url   = 'https://rankpilotai.com/ai-snippet-seo-helper-pricing/';
	} else {
		$token_btn_label = 'Buy Tokens';
		$token_btn_url   = 'https://rankpilotai.com/tokens-2/?plugin=ai-snippet-seo-helper';
	}

	/* =======================  HTML OUTPUT  ======================= */
	?>

	<div class="aish-settings-wrap">

		<!-- HEADER -->
		<div class="aish-header">
			<div class="aish-header-inner">
				<div class="aish-header-left">
					<div class="aish-logo-icon">
						<img src="<?php echo esc_url( AISH_URL . 'admin/assets/img/header-logo.png' ); ?>" alt="AI Snippet SEO Helper" width="36" height="36">
					</div>
					<div>
						<h1 class="aish-header-title">AI Snippet SEO Helper</h1>
						<p class="aish-header-subtitle">Rank Math SEO Integration</p>
					</div>
				</div>
				<div class="aish-header-right">
					<span class="aish-version-badge">v<?php echo esc_html( AISH_VERSION ); ?></span>
				</div>
			</div>
		</div>

		<!-- LAYOUT -->
		<div class="aish-layout">

			<!-- SIDEBAR -->
			<aside class="aish-sidebar">
				<nav class="aish-nav">
					<a href="<?php echo esc_url( add_query_arg('tab','site-key',admin_url('admin.php?page=ai-snippet-seo-helper')) ); ?>"
					   class="aish-nav-item <?php echo $tab==='site-key' ? 'active' : ''; ?>">
						<span class="aish-nav-icon">
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
								<path d="M21 2l-2 2m-7.61 7.61a5.5 5.5 0 1 1-7.778 7.778 5.5 5.5 0 0 1 7.777-7.777zm0 0L15.5 7.5m0 0l3 3L22 7l-3-3m-3.5 3.5L19 4"/>
							</svg>
						</span>
						<span>Site Key Management</span>
					</a>
					<a href="<?php echo esc_url( add_query_arg('tab','seo-settings',admin_url('admin.php?page=ai-snippet-seo-helper')) ); ?>"
					   class="aish-nav-item <?php echo $tab==='seo-settings' ? 'active' : ''; ?>">
						<span class="aish-nav-icon">
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
								<circle cx="12" cy="12" r="3"/>
								<path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06A1.65 1.65 0 0 0 4.68 15a1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06A1.65 1.65 0 0 0 9 4.68a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/>
							</svg>
						</span>
						<span>SEO Snippet Settings</span>
					</a>
				</nav>

				<div class="aish-sidebar-info">
					<p>This plugin works as an integration for Rank Math SEO. It adds AI snippet generation into Rank Math's snippet editor.</p>
					<a href="https://rankpilotai.com/ai-snippet-seo-helper/" target="_blank" rel="noopener" class="aish-sidebar-link">
						<svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/><polyline points="15 3 21 3 21 9"/><line x1="10" y1="14" x2="21" y2="3"/></svg>
						Documentation
					</a>
				</div>
			</aside>

			<!-- CONTENT -->
			<main class="aish-content">

			<?php /* ---- TAB 1: SITE KEY ---- */ ?>
			<?php if ( $tab === 'site-key' ) : ?>

				<div class="aish-content-header">
					<h2>Site Key Management</h2>
					<p>Connect your site to RankPilotAI by entering your Site Key below.</p>
				</div>

				<?php if ( ! $token ) : ?>

					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 2l-2 2m-7.61 7.61a5.5 5.5 0 1 1-7.778 7.778 5.5 5.5 0 0 1 7.777-7.777zm0 0L15.5 7.5m0 0l3 3L22 7l-3-3m-3.5 3.5L19 4"/></svg>
							<h3>Enter Your Site Key</h3>
						</div>
						<form method="post" class="aish-form">
							<?php wp_nonce_field('aish_save_site_key'); ?>
							<input type="hidden" name="aish_action" value="aish_save_site_key">
							<div class="aish-field">
								<label for="aish_site_token">Site Key</label>
								<input type="text" id="aish_site_token" name="site_token" placeholder="rp_xxxxxxxxxxxxxxxxx" required>
								<p class="aish-field-hint">Generate a Site Key in your account at
									<a href="https://rankpilotai.com" target="_blank" rel="noopener">RankPilotAI.com</a></p>
							</div>
							<button type="submit" class="aish-btn aish-btn-primary">
								<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>
								Save Site Key
							</button>
						</form>
					</div>

				<?php else : ?>

					<!-- Active Key Card -->
					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>
							<h3>Active Site Key</h3>
							<span class="aish-badge aish-badge-success">Connected</span>
						</div>
						<div class="aish-token-display">
							<code><?php echo esc_html( $token ); ?></code>
						</div>
					</div>

					<?php if ( $usage !== null ) : ?>
					<!-- Usage Card -->
					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 20V10"/><path d="M18 20V4"/><path d="M6 20v-4"/></svg>
							<h3>Usage Overview</h3>
						</div>

						<div class="aish-usage-grid">
							<div class="aish-usage-stat">
								<span class="aish-usage-label">Website</span>
								<span class="aish-usage-value"><?php echo esc_html( parse_url( home_url(), PHP_URL_HOST ) ); ?></span>
							</div>
							<div class="aish-usage-stat">
								<span class="aish-usage-label">Used</span>
								<span class="aish-usage-value aish-usage-number"><?php echo esc_html( number_format_i18n( (int) $usage ) ); ?></span>
							</div>
							<div class="aish-usage-stat">
								<span class="aish-usage-label">Plan Limit</span>
								<span class="aish-usage-value aish-usage-number"><?php echo esc_html( number_format_i18n( (int) $limit ) ); ?></span>
							</div>
							<div class="aish-usage-stat">
								<span class="aish-usage-label">Remaining</span>
								<span class="aish-usage-value aish-usage-number <?php echo (int)$remain === 0 ? 'aish-danger' : 'aish-success'; ?>">
									<?php echo esc_html( number_format_i18n( (int) $remain ) ); ?>
								</span>
							</div>
						</div>

						<?php
						$pct = $limit ? round( ( ( (int) $limit - (int) $remain ) / max( 1, (int) $limit ) ) * 100 ) : 0;
						$pct = max( 0, min( 100, (int) $pct ) );
						$bar_color = ( (int) $remain === 0 ) ? '#ef4444' : '#3b82f6';
						?>
						<div class="aish-progress-wrap">
							<div class="aish-progress-bar">
								<div class="aish-progress-fill" style="width:<?php echo (int) $pct; ?>%;background:<?php echo esc_attr( $bar_color ); ?>;"></div>
							</div>
							<span class="aish-progress-label"><?php echo (int) $pct; ?>% used</span>
						</div>

						<div class="aish-usage-cta">
							<a href="<?php echo esc_url( $token_btn_url ); ?>" target="_blank" rel="noopener" class="aish-btn aish-btn-primary">
								<svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/><polyline points="15 3 21 3 21 9"/><line x1="10" y1="14" x2="21" y2="3"/></svg>
								<?php echo esc_html( $token_btn_label ); ?>
							</a>
						</div>
					</div>
					<?php endif; ?>

					<!-- Update Key Card -->
					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/><path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/></svg>
							<h3>Update Site Key</h3>
						</div>
						<form method="post" class="aish-form">
							<?php wp_nonce_field('aish_save_site_key'); ?>
							<input type="hidden" name="aish_action" value="aish_save_site_key">
							<div class="aish-field-row">
								<input type="text" name="site_token" value="<?php echo esc_attr( $token ); ?>" placeholder="rp_xxxxxxxxxxxxxxxxx">
								<button type="submit" class="aish-btn aish-btn-primary">Save</button>
							</div>
						</form>
					</div>

				<?php endif; ?>

			<?php /* ---- TAB 2: SEO SETTINGS ---- */ ?>
			<?php else :
				$dis = empty( $token ) ? 'disabled' : ''; ?>

				<div class="aish-content-header">
					<h2>SEO Snippet Settings</h2>
					<p>Configure how AI Snippet SEO Helper generates snippets inside the Rank Math SEO snippet editor.</p>
				</div>

				<?php if ( empty( $token ) ) : ?>
					<div class="aish-alert aish-alert-warning">
						<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
						<div>
							<strong>Site Key Required</strong>
							<p>Please enter a Site Key in the <a href="<?php echo esc_url( add_query_arg('tab','site-key',admin_url('admin.php?page=ai-snippet-seo-helper')) ); ?>">Site Key Management</a> tab first.</p>
						</div>
					</div>
				<?php endif; ?>

				<form method="post">
					<?php wp_nonce_field('aish_save_seo_settings'); ?>
					<input type="hidden" name="aish_action" value="aish_save_seo_settings">

					<!-- Model Selection -->
					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="12 2 2 7 12 12 22 7 12 2"/><polyline points="2 17 12 22 22 17"/><polyline points="2 12 12 17 22 12"/></svg>
							<h3>AI Model</h3>
						</div>

						<div class="aish-model-grid">
							<label class="aish-model-card <?php echo ($model === 'gpt-4-turbo') ? 'selected' : ''; ?>">
								<input type="radio" name="model_choice" value="gpt-4-turbo"
									   <?php checked( $model, 'gpt-4-turbo' ); ?> <?php echo $dis; ?>>
								<div class="aish-model-card-inner">
									<span class="aish-model-dot" style="background:#22c55e;"></span>
									<div class="aish-model-info">
										<strong>GPT-4 Turbo</strong>
										<span class="aish-model-tag">Economical</span>
									</div>
									<span class="aish-model-cost">1 token</span>
								</div>
							</label>

							<label class="aish-model-card <?php echo ($model === 'gpt-4.1') ? 'selected' : ''; ?> <?php echo !in_array('gpt-4.1',$allowed,true) ? 'disabled' : ''; ?>">
								<input type="radio" name="model_choice" value="gpt-4.1"
									   <?php checked( $model, 'gpt-4.1' ); ?>
									   <?php echo (!in_array('gpt-4.1',$allowed,true) || $dis) ? 'disabled' : ''; ?>>
								<div class="aish-model-card-inner">
									<span class="aish-model-dot" style="background:#3b82f6;"></span>
									<div class="aish-model-info">
										<strong>GPT-4.1</strong>
										<span class="aish-model-tag">Balanced</span>
									</div>
									<span class="aish-model-cost">3 tokens</span>
								</div>
							</label>

							<label class="aish-model-card <?php echo ($model === 'gpt-4o') ? 'selected' : ''; ?> <?php echo !in_array('gpt-4o',$allowed,true) ? 'disabled' : ''; ?>">
								<input type="radio" name="model_choice" value="gpt-4o"
									   <?php checked( $model, 'gpt-4o' ); ?>
									   <?php echo (!in_array('gpt-4o',$allowed,true) || $dis) ? 'disabled' : ''; ?>>
								<div class="aish-model-card-inner">
									<span class="aish-model-dot" style="background:#a855f7;"></span>
									<div class="aish-model-info">
										<strong>GPT-4o</strong>
										<span class="aish-model-tag">Premium</span>
									</div>
									<span class="aish-model-cost">5 tokens</span>
								</div>
							</label>
						</div>

						<p class="aish-card-hint">Models are provided by RankPilotAI. Some models may be unavailable on your current plan.</p>
					</div>

					<!-- Custom Prompt -->
					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/></svg>
							<h3>Custom Prompt</h3>
						</div>

						<div class="aish-field">
							<textarea id="custom_prompt" name="custom_prompt" rows="4"
									  placeholder="e.g. Write in a friendly, conversational tone..." <?php echo $dis; ?>><?php
								echo esc_textarea( $opts['custom_prompt'] ?? '' ); ?></textarea>
							<p class="aish-field-hint">
								A base prompt already ensures SEO compliance.
								Add tone or extra instructions here to be appended <em>on top of</em> the default prompt.
							</p>
						</div>
					</div>

					<!-- Auto Slug -->
					<div class="aish-card">
						<div class="aish-card-header">
							<svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"/><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"/></svg>
							<h3>URL Slug</h3>
						</div>

						<label class="aish-toggle-row">
							<span class="aish-toggle">
								<input type="checkbox" id="auto_slug" name="auto_slug" value="yes"
									   <?php checked( $opts['auto_slug'] ?? 'no', 'yes' ); ?> <?php echo $dis; ?>>
								<span class="aish-toggle-slider"></span>
							</span>
							<div class="aish-toggle-label">
								<strong>Auto-update URL Slug</strong>
								<p>Replace current slug with AI suggestion. WordPress adds a 301 redirect automatically.</p>
							</div>
						</label>

						<p class="aish-card-hint">Default is OFF. When enabled, the AI-generated slug overwrites the old one. WordPress keeps the previous slug in <code>_wp_old_slug</code> and serves a 301 redirect.</p>
					</div>

					<!-- Save Button -->
					<div class="aish-form-actions">
						<button type="submit" class="aish-btn aish-btn-primary aish-btn-lg" <?php echo $dis; ?>>
							<svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 8 15 8"/></svg>
							<?php echo empty( $token ) ? 'Save (needs Site Key)' : 'Save Changes'; ?>
						</button>
					</div>
				</form>

			<?php endif; ?>

			</main>
		</div>
	</div>

	<!-- =========================================================
	      SETTINGS PAGE CSS
	========================================================= -->
	<style>
	/* ========== RESET & BASE ========== */
	.aish-settings-wrap{
		max-width:1200px;
		margin:0 20px 40px 0;
		font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Ubuntu,Cantarell,"Helvetica Neue",Arial,sans-serif;
		font-size:14px;
		color:#1e293b;
		line-height:1.6;
	}
	.aish-settings-wrap *{box-sizing:border-box;}

	/* ========== HEADER ========== */
	.aish-header{
		background:linear-gradient(135deg,#0f172a 0%,#1e3a5f 50%,#1e40af 100%);
		border-radius:12px 12px 0 0;
		padding:0;
		margin-top:20px;
	}
	.aish-header-inner{
		display:flex;
		align-items:center;
		justify-content:space-between;
		padding:24px 32px;
	}
	.aish-header-left{display:flex;align-items:center;gap:16px;}
	.aish-logo-icon{
		width:48px;height:48px;
		background:rgba(255,255,255,.12);
		border-radius:12px;
		display:flex;align-items:center;justify-content:center;
		color:#fff;
		flex-shrink:0;
	}
	.aish-header-title{
		font-size:22px;font-weight:700;color:#fff;margin:0;line-height:1.2;
	}
	.aish-header-subtitle{
		font-size:13px;color:rgba(255,255,255,.65);margin:2px 0 0;
	}
	.aish-version-badge{
		background:rgba(255,255,255,.15);
		color:rgba(255,255,255,.85);
		padding:4px 12px;
		border-radius:20px;
		font-size:12px;
		font-weight:600;
	}

	/* ========== LAYOUT ========== */
	.aish-layout{
		display:flex;
		background:#f8fafc;
		border:1px solid #e2e8f0;
		border-top:none;
		border-radius:0 0 12px 12px;
		min-height:500px;
	}

	/* ========== SIDEBAR ========== */
	.aish-sidebar{
		width:280px;
		background:#fff;
		border-right:1px solid #e2e8f0;
		border-radius:0 0 0 12px;
		padding:24px 16px;
		display:flex;
		flex-direction:column;
		flex-shrink:0;
	}
	.aish-nav{display:flex;flex-direction:column;gap:4px;}
	.aish-nav-item{
		display:flex;align-items:center;gap:12px;
		padding:12px 16px;
		border-radius:8px;
		color:#475569;
		text-decoration:none;
		font-size:14px;
		font-weight:500;
		transition:all .15s ease;
	}
	.aish-nav-item:hover{background:#f1f5f9;color:#1e293b;}
	.aish-nav-item.active{
		background:linear-gradient(135deg,#eff6ff,#dbeafe);
		color:#1d4ed8;
		font-weight:600;
		box-shadow:0 0 0 1px rgba(59,130,246,.2);
	}
	.aish-nav-icon{display:flex;align-items:center;flex-shrink:0;}

	.aish-sidebar-info{
		margin-top:auto;
		padding:16px;
		background:#f8fafc;
		border-radius:8px;
		border:1px solid #e2e8f0;
	}
	.aish-sidebar-info p{
		font-size:12px;color:#64748b;margin:0 0 12px;line-height:1.5;
	}
	.aish-sidebar-link{
		display:inline-flex;align-items:center;gap:6px;
		font-size:12px;color:#3b82f6;text-decoration:none;font-weight:500;
	}
	.aish-sidebar-link:hover{color:#1d4ed8;text-decoration:underline;}

	/* ========== CONTENT ========== */
	.aish-content{
		flex:1;
		padding:32px;
		min-width:0;
	}
	.aish-content-header{margin-bottom:28px;}
	.aish-content-header h2{
		font-size:22px;font-weight:700;color:#0f172a;margin:0 0 6px;
	}
	.aish-content-header p{
		font-size:14px;color:#64748b;margin:0;
	}

	/* ========== CARDS ========== */
	.aish-card{
		background:#fff;
		border:1px solid #e2e8f0;
		border-radius:10px;
		padding:24px;
		margin-bottom:20px;
		transition:box-shadow .2s ease;
	}
	.aish-card:hover{box-shadow:0 1px 8px rgba(0,0,0,.04);}
	.aish-card-header{
		display:flex;
		align-items:center;
		gap:10px;
		margin-bottom:20px;
		padding-bottom:16px;
		border-bottom:1px solid #f1f5f9;
		color:#334155;
	}
	.aish-card-header h3{
		font-size:16px;font-weight:600;margin:0;color:#0f172a;flex:1;
	}
	.aish-card-hint{
		font-size:12px;color:#94a3b8;margin:16px 0 0;line-height:1.5;
	}
	.aish-card-hint code{
		background:#f1f5f9;padding:1px 6px;border-radius:3px;font-size:11px;
	}

	/* ========== BADGES ========== */
	.aish-badge{
		padding:3px 10px;border-radius:20px;font-size:11px;font-weight:600;letter-spacing:.3px;text-transform:uppercase;
	}
	.aish-badge-success{background:#dcfce7;color:#16a34a;}

	/* ========== FORMS ========== */
	.aish-form{display:flex;flex-direction:column;gap:20px;}
	.aish-field{display:flex;flex-direction:column;gap:6px;}
	.aish-field label{font-size:13px;font-weight:600;color:#334155;}
	.aish-field input[type="text"],
	.aish-field textarea,
	.aish-field select{
		width:100%;
		padding:10px 14px;
		font-size:14px;
		border:1px solid #cbd5e1;
		border-radius:8px;
		background:#fff;
		color:#1e293b;
		transition:border-color .15s ease,box-shadow .15s ease;
		font-family:inherit;
	}
	.aish-field input[type="text"]:focus,
	.aish-field textarea:focus,
	.aish-field select:focus{
		outline:none;
		border-color:#3b82f6;
		box-shadow:0 0 0 3px rgba(59,130,246,.12);
	}
	.aish-field textarea{resize:vertical;min-height:100px;}
	.aish-field-hint{
		font-size:12px;color:#94a3b8;margin:0;line-height:1.5;
	}
	.aish-field-hint a{color:#3b82f6;text-decoration:none;}
	.aish-field-hint a:hover{text-decoration:underline;}

	.aish-field-row{
		display:flex;gap:10px;align-items:center;
	}
	.aish-field-row input[type="text"]{
		flex:1;
		padding:10px 14px;
		font-size:14px;
		border:1px solid #cbd5e1;
		border-radius:8px;
		background:#fff;
		color:#1e293b;
		transition:border-color .15s ease,box-shadow .15s ease;
	}
	.aish-field-row input[type="text"]:focus{
		outline:none;
		border-color:#3b82f6;
		box-shadow:0 0 0 3px rgba(59,130,246,.12);
	}

	/* ========== BUTTONS ========== */
	.aish-btn{
		display:inline-flex;align-items:center;justify-content:center;gap:8px;
		padding:10px 20px;
		font-size:14px;font-weight:600;
		border:none;border-radius:8px;
		cursor:pointer;
		text-decoration:none;
		transition:all .15s ease;
		line-height:1.4;
	}
	.aish-btn-primary{
		background:linear-gradient(135deg,#2563eb,#1d4ed8);
		color:#fff !important;
		box-shadow:0 1px 3px rgba(37,99,235,.3);
	}
	.aish-btn-primary:hover{
		background:linear-gradient(135deg,#3b82f6,#2563eb);
		box-shadow:0 2px 8px rgba(37,99,235,.35);
		transform:translateY(-1px);
		color:#fff !important;
	}
	.aish-btn-primary:active{transform:translateY(0);}
	.aish-btn-primary:disabled,.aish-btn-primary[disabled]{
		opacity:.5;cursor:not-allowed;transform:none;
	}
	.aish-btn-lg{padding:12px 28px;font-size:15px;}

	/* ========== TOKEN DISPLAY ========== */
	.aish-token-display{
		background:#f8fafc;
		border:1px solid #e2e8f0;
		border-radius:8px;
		padding:12px 16px;
	}
	.aish-token-display code{
		font-size:14px;color:#334155;background:none;
		word-break:break-all;
	}

	/* ========== USAGE ========== */
	.aish-usage-grid{
		display:grid;
		grid-template-columns:repeat(4,1fr);
		gap:16px;
		margin-bottom:20px;
	}
	.aish-usage-stat{
		background:#f8fafc;
		border:1px solid #e2e8f0;
		border-radius:8px;
		padding:14px 16px;
		text-align:center;
	}
	.aish-usage-label{
		display:block;font-size:11px;font-weight:600;
		color:#94a3b8;text-transform:uppercase;letter-spacing:.5px;
		margin-bottom:6px;
	}
	.aish-usage-value{
		display:block;font-size:14px;font-weight:700;color:#0f172a;
		word-break:break-all;
	}
	.aish-usage-number{font-size:20px;}
	.aish-usage-value.aish-danger{color:#ef4444;}
	.aish-usage-value.aish-success{color:#22c55e;}

	.aish-progress-wrap{
		display:flex;align-items:center;gap:12px;
		margin-bottom:20px;
	}
	.aish-progress-bar{
		flex:1;height:10px;
		background:#e2e8f0;border-radius:10px;
		overflow:hidden;
	}
	.aish-progress-fill{
		height:100%;border-radius:10px;
		transition:width .6s ease;
	}
	.aish-progress-label{
		font-size:12px;font-weight:600;color:#64748b;
		white-space:nowrap;
	}
	.aish-usage-cta{padding-top:4px;}

	/* ========== MODEL CARDS ========== */
	.aish-model-grid{
		display:grid;
		grid-template-columns:repeat(3,1fr);
		gap:12px;
	}
	.aish-model-card{
		position:relative;
		border:2px solid #e2e8f0;
		border-radius:10px;
		padding:16px;
		cursor:pointer;
		transition:all .15s ease;
		background:#fff;
	}
	.aish-model-card:hover:not(.disabled){
		border-color:#93c5fd;
		background:#f8fafc;
	}
	.aish-model-card.selected{
		border-color:#3b82f6;
		background:linear-gradient(135deg,#eff6ff,#dbeafe);
		box-shadow:0 0 0 1px rgba(59,130,246,.2);
	}
	.aish-model-card.disabled{
		opacity:.45;cursor:not-allowed;pointer-events:none;
	}
	.aish-model-card input[type="radio"]{
		position:absolute;opacity:0;width:0;height:0;pointer-events:none;
	}
	.aish-model-card-inner{
		display:flex;
		align-items:center;
		gap:10px;
	}
	.aish-model-dot{
		width:10px;height:10px;
		border-radius:50%;
		flex-shrink:0;
	}
	.aish-model-info{
		flex:1;min-width:0;
	}
	.aish-model-info strong{
		display:block;font-size:14px;color:#0f172a;
	}
	.aish-model-tag{
		font-size:11px;color:#64748b;
	}
	.aish-model-cost{
		font-size:12px;font-weight:600;
		color:#3b82f6;
		white-space:nowrap;
		background:#eff6ff;
		padding:3px 8px;
		border-radius:6px;
	}

	/* ========== TOGGLE ========== */
	.aish-toggle-row{
		display:flex;align-items:flex-start;gap:14px;
		cursor:pointer;
	}
	.aish-toggle{
		position:relative;
		width:44px;height:24px;
		flex-shrink:0;
		margin-top:2px;
	}
	.aish-toggle input{opacity:0;width:0;height:0;position:absolute;}
	.aish-toggle-slider{
		position:absolute;inset:0;
		background:#cbd5e1;
		border-radius:24px;
		transition:background .2s ease;
		cursor:pointer;
	}
	.aish-toggle-slider::after{
		content:'';
		position:absolute;
		left:3px;top:3px;
		width:18px;height:18px;
		background:#fff;
		border-radius:50%;
		transition:transform .2s ease;
		box-shadow:0 1px 3px rgba(0,0,0,.15);
	}
	.aish-toggle input:checked + .aish-toggle-slider{
		background:#3b82f6;
	}
	.aish-toggle input:checked + .aish-toggle-slider::after{
		transform:translateX(20px);
	}
	.aish-toggle-label strong{
		display:block;font-size:14px;color:#0f172a;margin-bottom:2px;
	}
	.aish-toggle-label p{
		font-size:13px;color:#64748b;margin:0;
	}

	/* ========== ALERT ========== */
	.aish-alert{
		display:flex;align-items:flex-start;gap:12px;
		padding:16px 20px;
		border-radius:10px;
		margin-bottom:24px;
	}
	.aish-alert svg{flex-shrink:0;margin-top:2px;}
	.aish-alert strong{display:block;margin-bottom:4px;}
	.aish-alert p{margin:0;font-size:13px;}
	.aish-alert a{color:inherit;text-decoration:underline;}
	.aish-alert-warning{
		background:#fef3c7;border:1px solid #fde68a;color:#92400e;
	}
	.aish-alert-warning svg{color:#f59e0b;}

	/* ========== FORM ACTIONS ========== */
	.aish-form-actions{
		padding-top:8px;
	}

	/* ========== RESPONSIVE ========== */
	@media (max-width:900px){
		.aish-settings-wrap{margin:0 10px 30px 0;}
		.aish-header-inner{padding:20px 24px;}
		.aish-layout{flex-direction:column;border-radius:0 0 12px 12px;}
		.aish-sidebar{
			width:100%;
			border-right:none;
			border-bottom:1px solid #e2e8f0;
			border-radius:0;
			padding:20px 16px;
		}
		.aish-nav{flex-direction:row;gap:8px;}
		.aish-nav-item{font-size:13px;padding:10px 14px;}
		.aish-sidebar-info{display:none;}
		.aish-content{padding:24px 20px;}

		.aish-usage-grid{grid-template-columns:repeat(2,1fr);}
		.aish-model-grid{grid-template-columns:1fr;}
		.aish-field-row{flex-direction:column;}
		.aish-field-row input[type="text"]{width:100%;}
		.aish-btn{width:100%;justify-content:center;}
	}

	@media (max-width:480px){
		.aish-header-inner{flex-direction:column;align-items:flex-start;gap:12px;}
		.aish-header-right{align-self:flex-end;}
		.aish-usage-grid{grid-template-columns:1fr 1fr;}
		.aish-nav{flex-direction:column;}
	}
	</style>
	<script>
	(function(){
		var cards = document.querySelectorAll('.aish-model-card');
		cards.forEach(function(card){
			var radio = card.querySelector('input[type="radio"]');
			if(!radio) return;
			card.addEventListener('click', function(e){
				if(card.classList.contains('disabled')) return;
				if(radio.disabled) return;
				cards.forEach(function(c){ c.classList.remove('selected'); });
				card.classList.add('selected');
				radio.checked = true;
			});
		});
	})();
	</script>
	<?php
} /* end aish_render_settings_page */
}
