<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @link       https://ki-sum.ai/ai-product-assistant
 * @since      1.0.0
 *
 * @package    AI_Product_Assistant
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('aipa_settings');
delete_option('aipa_debug_settings');

// Delete any statistics
delete_option('aipa_search_count');
delete_option('aipa_analysis_count');

// Delete user meta for all users
$users = get_users();
foreach ($users as $user) {
    delete_user_meta($user->ID, 'aipa_upgrade_notice_dismissed');
}

// Delete any transients
global $wpdb;
// Direct database query is safe and necessary during uninstall for bulk cleanup
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
$wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '%aipa_transient_%'");

// Drop custom statistics table
$table_name = $wpdb->prefix . 'aipa_statistics';
$table_name_safe = esc_sql($table_name);
$sql = "DROP TABLE IF EXISTS `$table_name_safe`";
// Direct database query is safe and necessary during uninstall for table cleanup
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.PreparedSQL.NotPrepared
$wpdb->query($sql);

// Delete log files and directory using WP_Filesystem
$upload_dir = wp_upload_dir();
$log_dir = $upload_dir['basedir'] . '/aipa-logs/';
if (is_dir($log_dir)) {
    // Initialize WP_Filesystem
    if (!function_exists('WP_Filesystem')) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
    }
    
    if (WP_Filesystem()) {
        global $wp_filesystem;
        
        // Use scandir() instead of glob() for more reliable file detection
        $files = scandir($log_dir);
        foreach ($files as $file) {
            if ($file !== '.' && $file !== '..') {
                $file_path = $log_dir . $file;
                if (is_file($file_path)) {
                    $wp_filesystem->delete($file_path); // Use WP_Filesystem delete method
                }
            }
        }
        
        // Try to remove the directory (will only work if empty)
        $wp_filesystem->rmdir($log_dir); // Use WP_Filesystem rmdir method
    } else {
        // Fallback to direct methods if WP_Filesystem is not available
        $files = scandir($log_dir);
        foreach ($files as $file) {
            if ($file !== '.' && $file !== '..') {
                $file_path = $log_dir . $file;
                if (is_file($file_path)) {
                    wp_delete_file($file_path); // Use WordPress recommended function
                }
            }
        }
        
        // Try to remove the directory (will only work if empty)
        // Note: WordPress doesn't provide a direct rmdir equivalent in wp_delete_file
        // The directory will be removed automatically when empty
    }
}