<?php
/**
 * Frontend search results template
 *
 * @package AI_Product_Assistant
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get product IDs
$product_ids = isset($product_ids) ? $product_ids : array();
$explanations = isset($explanations) ? $explanations : array();

// Get settings
$options = get_option('aipa_settings');
$show_explanation = isset($show_explanation) ? $show_explanation : (isset($options['show_explanation']) ? $options['show_explanation'] : true);
$use_native_template = isset($use_native_template) ? $use_native_template : (isset($options['use_native_template']) ? $options['use_native_template'] : true);
$show_add_to_cart = isset($options['show_add_to_cart']) ? $options['show_add_to_cart'] : true;

// Show results count
$count = count($product_ids);
?>

<div class="aipa-search-results-header">
    <h3 class="aipa-results-title">
        <?php 
        if ($count > 0) {
            echo esc_html(sprintf(
                /* translators: %d: number of products found */
                _n('%d Product Found', '%d Products Found', $count, 'ai-product-assistant'), 
                $count
            ));
        } else {
            esc_html_e('No Products Found', 'ai-product-assistant');
        }
        ?>
    </h3>
</div>

<?php if (empty($product_ids)) : ?>
    <div class="aipa-no-results">
        <p><?php esc_html_e('No products match your description. Try being more specific or using different terms.', 'ai-product-assistant'); ?></p>
    </div>
<?php else : ?>
    <?php if ($use_native_template) : ?>
        <div class="aipa-products woocommerce">
            <ul class="products columns-3">
                <?php foreach ($product_ids as $product_id) : ?>
                    <?php 
                    $product = wc_get_product($product_id);
                    
                    if (!$product) {
                        continue;
                    }
                    
                    // Start buffering output
                    ob_start();
                    
                    // Set the global product variable
                    global $post, $product;
                    $post = get_post($product_id);
                    setup_postdata($post);
                    
                    // Get the template part
                    wc_get_template_part('content', 'product');
                    
                    // Get the buffered content
                    $product_html = ob_get_clean();
                    
                    // Add explanation if available and enabled
                    if ($show_explanation && isset($explanations[$product_id])) {
                        $explanation = '<div class="aipa-product-explanation">';
                        $explanation .= '<strong>' . __('Why this matches:', 'ai-product-assistant') . '</strong> ';
                        $explanation .= esc_html($explanations[$product_id]);
                        $explanation .= '</div>';
                        
                        // Insert explanation before closing li tag
                        $product_html = str_replace('</li>', $explanation . '</li>', $product_html);
                    }
                    
                    echo wp_kses_post($product_html);
                    
                    // Reset post data
                    wp_reset_postdata();
                    ?>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php else : ?>
        <div class="aipa-custom-products">
            <?php foreach ($product_ids as $product_id) : ?>
                <?php 
                $product = wc_get_product($product_id);
                
                if (!$product) {
                    continue;
                }
                ?>
                <div class="aipa-product">
                    <div class="aipa-product-image">
                        <a href="<?php echo esc_url(get_permalink($product_id)); ?>">
                            <?php echo wp_kses_post($product->get_image('woocommerce_thumbnail')); ?>
                        </a>
                    </div>
                    
                    <div class="aipa-product-details">
                        <h3 class="aipa-product-title">
                            <a href="<?php echo esc_url(get_permalink($product_id)); ?>"><?php echo esc_html($product->get_name()); ?></a>
                        </h3>
                        
                        <div class="aipa-product-price"><?php echo wp_kses_post($product->get_price_html()); ?></div>
                        
                        <?php if ($product->get_short_description()) : ?>
                            <div class="aipa-product-short-description"><?php echo wp_kses_post($product->get_short_description()); ?></div>
                        <?php endif; ?>
                        
                        <?php if ($show_explanation && isset($explanations[$product_id])) : ?>
                            <div class="aipa-product-explanation">
                                <strong><?php esc_html_e('Why this matches:', 'ai-product-assistant'); ?></strong> 
                                <?php echo esc_html($explanations[$product_id]); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($show_add_to_cart) : ?>
                            <div class="aipa-product-add-to-cart">
                                <?php if ($product->is_in_stock()) : ?>
                                    <a href="<?php echo esc_url($product->add_to_cart_url()); ?>" data-product_id="<?php echo esc_attr($product_id); ?>" class="aipa-add-to-cart-button">
                                        <?php echo esc_html($product->add_to_cart_text()); ?>
                                    </a>
                                <?php else : ?>
                                    <span class="aipa-out-of-stock"><?php esc_html_e('Out of stock', 'ai-product-assistant'); ?></span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
<?php endif; ?>
