<?php
/**
 * Frontend search form template
 *
 * @package AI_Product_Assistant
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get settings
$options = get_option('aipa_settings');
$placeholder = isset($atts['placeholder']) ? $atts['placeholder'] : __('Describe what you\'re looking for...', 'ai-product-assistant');
$button_text = isset($atts['button_text']) ? $atts['button_text'] : __('Search with AI', 'ai-product-assistant');
$voice_search = isset($atts['voice_search']) ? filter_var($atts['voice_search'], FILTER_VALIDATE_BOOLEAN) : true;
$result_container = isset($atts['result_container']) ? filter_var($atts['result_container'], FILTER_VALIDATE_BOOLEAN) : true;

// Generate unique IDs for this instance
$unique_id = 'aipa-' . uniqid();
$form_id = $unique_id . '-form';
$input_id = $unique_id . '-input';
$button_id = $unique_id . '-button';
$voice_button_id = $unique_id . '-voice-button';
$error_id = $unique_id . '-error';
$loading_id = $unique_id . '-loading';
$results_id = $unique_id . '-results';
?>

<div class="aipa-search-form-container">
    <div class="aipa-shortcode-search-form" id="<?php echo esc_attr($form_id); ?>">
        <textarea id="<?php echo esc_attr($input_id); ?>" class="aipa-shortcode-search-input" placeholder="<?php echo esc_attr($placeholder); ?>"></textarea>
        <div class="aipa-shortcode-search-buttons">
            <?php if (false && $voice_search) : // Voice search hidden from UI ?>
            <button id="<?php echo esc_attr($voice_button_id); ?>" class="aipa-shortcode-voice-btn" type="button">
                <span class="aipa-voice-icon">🎤</span> <?php esc_html_e('Voice Search', 'ai-product-assistant'); ?>
            </button>
            <?php endif; ?>
            <button id="<?php echo esc_attr($button_id); ?>" class="aipa-shortcode-search-btn" type="button">
                <span class="aipa-spinner"></span>
                <span class="aipa-btn-text"><?php echo esc_html($button_text); ?></span>
            </button>
        </div>
    </div>
    
    <div id="<?php echo esc_attr($error_id); ?>" class="aipa-shortcode-search-error"></div>
    
    <?php if ($result_container) : ?>
    <div id="<?php echo esc_attr($results_id); ?>" class="aipa-shortcode-search-results">
        <div id="<?php echo esc_attr($loading_id); ?>" class="aipa-shortcode-results-loading" style="display: none;">
            <div class="aipa-loading-spinner"></div>
            <p><?php esc_html_e('AI is analyzing your request...', 'ai-product-assistant'); ?></p>
        </div>
        <div class="aipa-shortcode-results-container"></div>
    </div>
    <?php endif; ?>
</div>

<?php
// Add search form initialization via wp_add_inline_script
wp_add_inline_script('aipa-frontend-js', 
    sprintf(
        'jQuery(document).ready(function($) {
            AIPA_Frontend.initShortcodeSearchForm("%s", "%s", "%s", "%s", "%s", "%s");
        });',
        esc_js($input_id),
        esc_js($button_id),
        esc_js($voice_button_id),
        esc_js($error_id),
        esc_js($loading_id),
        esc_js($results_id)
    )
);
?>
