<?php
/**
 * Frontend cart analysis template
 *
 * @package AI_Product_Assistant
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get settings
$options = get_option('aipa_settings');
$placeholder = isset($atts['placeholder']) ? $atts['placeholder'] : __('e.g., Can I make a basic home theater with these items?', 'ai-product-assistant');
$button_text = isset($atts['button_text']) ? $atts['button_text'] : __('Analyze with AI', 'ai-product-assistant');

// Check if cart analysis is enabled
$enable_cart_analysis = isset($options['enable_cart_analysis']) ? $options['enable_cart_analysis'] : true;

// If cart analysis is disabled, return
if (!$enable_cart_analysis) {
    return;
}

// Check if cart is empty
if (!function_exists('WC') || !isset(WC()->cart) || WC()->cart->is_empty()) {
    ?>
    <div class="aipa-cart-analysis-empty">
        <?php esc_html_e('Your cart is empty. Add some products first.', 'ai-product-assistant'); ?>
    </div>
    <?php
    return;
}

// Generate unique IDs for this instance
$unique_id = 'aipa-cart-' . uniqid();
$form_id = $unique_id . '-form';
$input_id = $unique_id . '-input';
$button_id = $unique_id . '-button';
$error_id = $unique_id . '-error';
$loading_id = $unique_id . '-loading';
$results_id = $unique_id . '-results';
?>

<div class="aipa-shortcode-cart-analysis">
    <h3><?php esc_html_e('AI Cart Analysis', 'ai-product-assistant'); ?></h3>
    <p><?php esc_html_e('Ask AI if your cart items will work for your specific needs.', 'ai-product-assistant'); ?></p>
    
    <div class="aipa-shortcode-cart-analysis-form" id="<?php echo esc_attr($form_id); ?>">
        <textarea id="<?php echo esc_attr($input_id); ?>" class="aipa-shortcode-cart-analysis-input" placeholder="<?php echo esc_attr($placeholder); ?>"></textarea>
        <button id="<?php echo esc_attr($button_id); ?>" class="aipa-shortcode-cart-analysis-btn" type="button">
            <span class="aipa-spinner"></span>
            <span class="aipa-btn-text"><?php echo esc_html($button_text); ?></span>
        </button>
    </div>
    
    <div id="<?php echo esc_attr($error_id); ?>" class="aipa-shortcode-cart-analysis-error"></div>
    
    <div id="<?php echo esc_attr($results_id); ?>" class="aipa-shortcode-cart-analysis-results">
        <div id="<?php echo esc_attr($loading_id); ?>" class="aipa-shortcode-cart-analysis-loading" style="display: none;">
            <div class="aipa-loading-spinner"></div>
            <p><?php esc_html_e('AI is analyzing your cart...', 'ai-product-assistant'); ?></p>
        </div>
        <div class="aipa-shortcode-cart-analysis-container"></div>
    </div>
</div>

<?php
// Add cart analysis initialization via wp_add_inline_script
wp_add_inline_script('aipa-cart-analysis-js', 
    sprintf(
        'jQuery(document).ready(function($) {
            AIPA_CartAnalysis.initShortcodeCartAnalysis("%s", "%s", "%s", "%s", "%s");
        });',
        esc_js($input_id),
        esc_js($button_id),
        esc_js($error_id),
        esc_js($loading_id),
        esc_js($results_id)
    )
);
?>
