<?php
/**
 * Admin statistics page template
 *
 * @package AI_Product_Assistant
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Safely get URL parameters for statistics filtering
$current_time_range = 'today';
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
if (isset($_GET['time_range'])) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $time_range = sanitize_text_field(wp_unslash($_GET['time_range']));
    // Validate against allowed values
    $allowed_ranges = array('today', 'yesterday', '7days', '30days', 'all');
    if (in_array($time_range, $allowed_ranges, true)) {
        $current_time_range = $time_range;
    }
}

$current_page = 1;
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
if (isset($_GET['paged'])) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    $page = intval(wp_unslash($_GET['paged']));
    if ($page > 0) {
        $current_page = $page;
    }
}

$base_url = add_query_arg(
    array(
        'page' => 'ai-product-assistant',
        'tab' => 'statistics',
        'time_range' => $current_time_range
    ),
    admin_url('admin.php')
);
?>

<div class="aipa-statistics-header">
    <div class="aipa-statistics-filter">
        <select id="aipa-stats-filter">
            <option value="today" <?php selected($current_time_range, 'today'); ?>><?php esc_html_e('Today', 'ai-product-assistant'); ?></option>
            <option value="yesterday" <?php selected($current_time_range, 'yesterday'); ?>><?php esc_html_e('Yesterday', 'ai-product-assistant'); ?></option>
            <option value="7days" <?php selected($current_time_range, '7days'); ?>><?php esc_html_e('Last 7 Days', 'ai-product-assistant'); ?></option>
            <option value="30days" <?php selected($current_time_range, '30days'); ?>><?php esc_html_e('Last 30 Days', 'ai-product-assistant'); ?></option>
            <option value="all" <?php selected($current_time_range, 'all'); ?>><?php esc_html_e('All Time', 'ai-product-assistant'); ?></option>
        </select>
        <button id="aipa-export-statistics" class="button button-secondary"><?php esc_html_e('Export CSV', 'ai-product-assistant'); ?></button>
    </div>
</div>

<div class="aipa-statistics-summary">
    <h3><?php esc_html_e('Summary', 'ai-product-assistant'); ?></h3>
    
    <div class="aipa-stats-grid">
        <div class="aipa-stat-box">
            <div class="aipa-stat-value"><?php echo esc_html($summary->total_requests); ?></div>
            <div class="aipa-stat-label"><?php esc_html_e('Total Requests', 'ai-product-assistant'); ?></div>
        </div>
        
        <div class="aipa-stat-box">
            <div class="aipa-stat-value"><?php echo esc_html($summary->total_request_tokens); ?></div>
            <div class="aipa-stat-label"><?php esc_html_e('Request Tokens', 'ai-product-assistant'); ?></div>
        </div>
        
        <div class="aipa-stat-box">
            <div class="aipa-stat-value"><?php echo esc_html($summary->total_response_tokens); ?></div>
            <div class="aipa-stat-label"><?php esc_html_e('Response Tokens', 'ai-product-assistant'); ?></div>
        </div>
        
        <div class="aipa-stat-box">
            <div class="aipa-stat-value"><?php echo esc_html($summary->total_tokens); ?></div>
            <div class="aipa-stat-label"><?php esc_html_e('Total Tokens', 'ai-product-assistant'); ?></div>
        </div>
        
        <div class="aipa-stat-box">
            <div class="aipa-stat-value"><?php echo esc_html(round($summary->avg_execution_time, 2)); ?>s</div>
            <div class="aipa-stat-label"><?php esc_html_e('Avg. Execution Time', 'ai-product-assistant'); ?></div>
        </div>
        
        <div class="aipa-stat-box">
            <div class="aipa-stat-value"><?php echo esc_html($summary->unique_users); ?></div>
            <div class="aipa-stat-label"><?php esc_html_e('Unique Users', 'ai-product-assistant'); ?></div>
        </div>
    </div>
</div>

<div class="aipa-statistics-details">
    <h3><?php esc_html_e('Detailed Records', 'ai-product-assistant'); ?></h3>
    
    <?php if (empty($stats)) : ?>
        <p><?php esc_html_e('No data available for the selected time period.', 'ai-product-assistant'); ?></p>
    <?php else : ?>
        <div class="tablenav top">
            <?php if ($total_pages > 1) : ?>
            <div class="tablenav-pages">
                <span class="displaying-num">
                    <?php 
                    echo wp_kses_post(sprintf(
                        /* translators: %s: number of items */
                        _n('%s item', '%s items', $total_items, 'ai-product-assistant'),
                        '<span class="total-items">' . esc_html(number_format_i18n($total_items)) . '</span>'
                    )); 
                    ?>
                </span>
                
                <span class="pagination-links">
                    <?php
                    if ($current_page > 1) : ?>
                        <a class="first-page button" href="<?php echo esc_url(add_query_arg('paged', 1, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('First page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">«</span>
                        </a>
                        <a class="prev-page button" href="<?php echo esc_url(add_query_arg('paged', $current_page - 1, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('Previous page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">‹</span>
                        </a>
                    <?php else : ?>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                    <?php endif; ?>
                    
                    <span class="paging-input">
                        <span class="tablenav-paging-text">
                            <?php 
                            echo wp_kses_post(sprintf(
                                /* translators: 1: current page number, 2: total number of pages */
                                esc_html(_x('%1$s of %2$s', 'paging', 'ai-product-assistant')),
                                '<span class="current-page">' . esc_html(number_format_i18n($current_page)) . '</span>',
                                '<span class="total-pages">' . esc_html(number_format_i18n($total_pages)) . '</span>'
                            )); 
                            ?>
                        </span>
                    </span>
                    
                    <?php
                    if ($current_page < $total_pages) : ?>
                        <a class="next-page button" href="<?php echo esc_url(add_query_arg('paged', $current_page + 1, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('Next page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">›</span>
                        </a>
                        <a class="last-page button" href="<?php echo esc_url(add_query_arg('paged', $total_pages, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('Last page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">»</span>
                        </a>
                    <?php else : ?>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                    <?php endif; ?>
                </span>
            </div>
            <?php endif; ?>
        </div>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php esc_html_e('Date/Time', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('User Role', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('API Provider', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Model', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Type', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Request Prompt', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Request Tokens', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Response Tokens', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Total Tokens', 'ai-product-assistant'); ?></th>
                    <th><?php esc_html_e('Time (s)', 'ai-product-assistant'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($stats as $stat) : ?>
                    <tr data-id="<?php echo esc_attr($stat->id); ?>" class="aipa-stat-row" style="cursor: pointer;">
                        <td><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($stat->timestamp))); ?></td>
                        <td><?php echo esc_html($stat->user_role); ?></td>
                        <td><?php echo esc_html($stat->api_provider); ?></td>
                        <td><?php echo esc_html($stat->api_model); ?></td>
                        <td><?php echo esc_html($stat->request_type); ?></td>
                        <td title="<?php echo esc_attr($stat->request_prompt); ?>"><?php 
                            $prompt = $stat->request_prompt;
                            $max_length = 30; // Maximum characters to display
                            if (mb_strlen($prompt) > $max_length) {
                                echo esc_html(mb_substr($prompt, 0, $max_length)) . '...';
                            } else {
                                echo esc_html($prompt);
                            }
                        ?></td>
                        <td><?php echo esc_html($stat->request_tokens); ?></td>
                        <td><?php echo esc_html($stat->response_tokens); ?></td>
                        <td><?php echo esc_html($stat->request_tokens + $stat->response_tokens); ?></td>
                        <td><?php echo esc_html(round($stat->execution_time, 2)); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <?php if ($total_pages > 1) : ?>
        <div class="tablenav bottom">
            <div class="tablenav-pages">
                <span class="displaying-num">
                    <?php echo wp_kses_post(sprintf(
                        /* translators: %s: number of items */
                        _n('%s item', '%s items', $total_items, 'ai-product-assistant'),
                        '<span class="total-items">' . esc_html(number_format_i18n($total_items)) . '</span>'
                    )); ?>
                </span>
                
                <span class="pagination-links">
                    <?php
                    if ($current_page > 1) : ?>
                        <a class="first-page button" href="<?php echo esc_url(add_query_arg('paged', 1, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('First page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">«</span>
                        </a>
                        <a class="prev-page button" href="<?php echo esc_url(add_query_arg('paged', $current_page - 1, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('Previous page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">‹</span>
                        </a>
                    <?php else : ?>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">«</span>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">‹</span>
                    <?php endif; ?>
                    
                    <span class="paging-input">
                        <span class="tablenav-paging-text">
                            <?php echo wp_kses_post(sprintf(
                                /* translators: 1: current page number, 2: total number of pages */
                                esc_html(_x('%1$s of %2$s', 'paging', 'ai-product-assistant')),
                                '<span class="current-page">' . esc_html(number_format_i18n($current_page)) . '</span>',
                                '<span class="total-pages">' . esc_html(number_format_i18n($total_pages)) . '</span>'
                            )); ?>
                        </span>
                    </span>
                    
                    <?php
                    if ($current_page < $total_pages) : ?>
                        <a class="next-page button" href="<?php echo esc_url(add_query_arg('paged', $current_page + 1, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('Next page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">›</span>
                        </a>
                        <a class="last-page button" href="<?php echo esc_url(add_query_arg('paged', $total_pages, $base_url)); ?>">
                            <span class="screen-reader-text"><?php esc_html_e('Last page', 'ai-product-assistant'); ?></span>
                            <span aria-hidden="true">»</span>
                        </a>
                    <?php else : ?>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">›</span>
                        <span class="tablenav-pages-navspan button disabled" aria-hidden="true">»</span>
                    <?php endif; ?>
                </span>
            </div>
        </div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<div class="aipa-statistics-prompt-details">
    <h3><?php esc_html_e('Prompt Details', 'ai-product-assistant'); ?></h3>
    
    <p><?php esc_html_e('Click on any record in the table above to view the full prompt and response.', 'ai-product-assistant'); ?></p>
    
    <div id="aipa-prompt-details-container" style="display: none;">
        <div class="aipa-prompt-box">
            <h4><?php esc_html_e('Request Prompt', 'ai-product-assistant'); ?></h4>
            <div id="aipa-prompt-content" class="aipa-content-box"></div>
        </div>
        
        <div class="aipa-response-box">
            <h4><?php esc_html_e('Response', 'ai-product-assistant'); ?></h4>
            <div id="aipa-response-content" class="aipa-content-box"></div>
        </div>
    </div>
</div>

<?php
// Add statistics page functionality via wp_add_inline_script
wp_add_inline_script('aipa-admin-script', '
    jQuery(document).ready(function($) {
        $("#aipa-stats-filter").on("change", function() {
            var timeRange = $(this).val();
            window.location.href = "' . esc_url(admin_url('admin.php')) . '?page=ai-product-assistant&tab=statistics&time_range=" + timeRange;
        });
        
        $("#aipa-export-statistics").on("click", function(e) {
            e.preventDefault();
            var timeRange = $("#aipa-stats-filter").val() || "all";
            window.location.href = "' . esc_url(admin_url('admin.php')) . '?page=ai-product-assistant&action=export_statistics&time_range=" + timeRange + "&nonce=' . esc_js(wp_create_nonce('aipa_admin_nonce')) . '";
        });
        
        $(".aipa-statistics-details table tbody tr").on("click", function() {
            var rowId = $(this).data("id");
            
            $.ajax({
                url: ajaxurl,
                type: "POST",
                data: {
                    action: "aipa_get_prompt_details",
                    id: rowId,
                    nonce: aipa_admin_data.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $("#aipa-prompt-content").text(response.data.prompt);
                        $("#aipa-response-content").text(response.data.response);
                        $("#aipa-prompt-details-container").show();
                        
                        $("html, body").animate({
                            scrollTop: $("#aipa-prompt-details-container").offset().top - 100
                        }, 500);
                    }
                }
            });
        });
    });
');
?>