<?php
/**
 * Admin settings page template
 *
 * @package AI_Product_Assistant
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get current options
$options = get_option('aipa_settings');
?>

<div class="wrap">
    <div class="aipa-admin-header">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <p><?php esc_html_e('Configure your AI product assistant settings below.', 'ai-product-assistant'); ?></p>
    </div>
    
    <?php 
    // Check for settings update status (this is a WordPress core parameter, safe to check)
    $settings_updated = false;
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
    if (isset($_GET['settings-updated'])) {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $settings_updated = sanitize_text_field(wp_unslash($_GET['settings-updated']));
    }
    if ($settings_updated) : ?>
        <div class="aipa-admin-notice aipa-notice-success">
            <p><?php esc_html_e('Settings saved successfully.', 'ai-product-assistant'); ?></p>
        </div>
    <?php endif; ?>

    <div class="aipa-tabs">
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'ai-provider' ? 'active' : '')); ?>" data-tab="aipa-ai-provider"><?php esc_html_e('AI Provider', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'fields' ? 'active' : '')); ?>" data-tab="aipa-product-fields"><?php esc_html_e('Product Fields Matching', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'search' ? 'active' : '')); ?>" data-tab="aipa-search-settings"><?php esc_html_e('Search Settings', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'cart' ? 'active' : '')); ?>" data-tab="aipa-cart-settings"><?php esc_html_e('Cart Analysis', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'product-assistant' ? 'active' : '')); ?>" data-tab="aipa-product-assistant"><?php esc_html_e('Product Assistant', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'statistics' ? 'active' : '')); ?>" data-tab="aipa-statistics"><?php esc_html_e('Statistics', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'debug' ? 'active' : '')); ?>" data-tab="aipa-debug"><?php esc_html_e('Debug', 'ai-product-assistant'); ?></div>
        <div class="<?php echo esc_attr('aipa-tab ' . ($active_tab == 'shortcodes' ? 'active' : '')); ?>" data-tab="aipa-shortcodes"><?php esc_html_e('Shortcodes', 'ai-product-assistant'); ?></div>
        <?php
        // Allow Pro version to add tabs
        do_action('aipa_admin_tabs_after_shortcodes', $active_tab);
        ?>
   </div>

   <form method="post" action="options.php" id="aipa-settings-form" class="aipa-admin-form">
       <?php settings_fields('aipa_settings_group'); ?>

        <!-- AI Provider Tab -->
        <div id="aipa-ai-provider" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'ai-provider' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('API Settings', 'ai-product-assistant'); ?></h2>
            <div class="aipa-section">
                <div class="aipa-settings-group">
                    <h3><?php esc_html_e('AI Provider', 'ai-product-assistant'); ?></h3>
                    <div class="aipa-api-provider">
                        <?php do_settings_fields('ai-product-assistant', 'aipa_api_section'); ?>
                    </div>
                </div>
               
               <div class="aipa-api-instructions aipa-api-openai-instructions">
                   <div class="aipa-help-box">
                       <h4><?php esc_html_e('How to get an OpenAI API key', 'ai-product-assistant'); ?></h4>
                       <ol>
                           <li><?php echo wp_kses(__('Visit <a href="https://platform.openai.com/signup" target="_blank">OpenAI</a> and sign up for an account.', 'ai-product-assistant'), array('a' => array('href' => array(), 'target' => array()))); ?></li>
                           <li><?php esc_html_e('Go to the API section and create a new API key.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Copy the API key and paste it above.', 'ai-product-assistant'); ?></li>
                       </ol>
                       <p><?php esc_html_e('Note: OpenAI charges for API usage. The costs depend on the number of tokens used in queries and responses.', 'ai-product-assistant'); ?></p>
                   </div>
               </div>
               
               <div class="aipa-api-instructions aipa-api-claude-instructions" style="display: none;">
                   <div class="aipa-help-box">
                       <h4><?php esc_html_e('How to get a Claude API key', 'ai-product-assistant'); ?></h4>
                       <ol>
                           <li><?php echo wp_kses(__('Visit <a href="https://www.anthropic.com/claude" target="_blank">Anthropic</a> and sign up for an account.', 'ai-product-assistant'), array('a' => array('href' => array(), 'target' => array()))); ?></li>
                           <li><?php esc_html_e('Request API access and follow their instructions to get an API key.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Copy the API key and paste it above.', 'ai-product-assistant'); ?></li>
                       </ol>
                       <p><?php esc_html_e('Note: Anthropic charges for API usage. Check their pricing for details.', 'ai-product-assistant'); ?></p>
                   </div>
               </div>
               
               <div class="aipa-api-instructions aipa-api-gemini-instructions" style="display: none;">
                   <div class="aipa-help-box">
                       <h4><?php esc_html_e('How to get a Gemini API key', 'ai-product-assistant'); ?></h4>
                       <ol>
                           <li><?php echo wp_kses(__('Visit <a href="https://ai.google.dev/" target="_blank">Google AI Studio</a> and sign up.', 'ai-product-assistant'), array('a' => array('href' => array(), 'target' => array()))); ?></li>
                           <li><?php esc_html_e('Create a new project and generate an API key.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Copy the API key and paste it above.', 'ai-product-assistant'); ?></li>
                       </ol>
                       <p><?php esc_html_e('Note: Google has various pricing tiers for Gemini API usage. Check their pricing details.', 'ai-product-assistant'); ?></p>
                   </div>
               </div>
               
               <div class="aipa-api-instructions aipa-api-deepseek-instructions" style="display: none;">
                   <div class="aipa-help-box">
                       <h4><?php esc_html_e('How to get a DeepSeek API key', 'ai-product-assistant'); ?></h4>
                       <ol>
                           <li><?php echo wp_kses(__('Visit <a href="https://platform.deepseek.com/" target="_blank">DeepSeek Platform</a> and create an account.', 'ai-product-assistant'), array('a' => array('href' => array(), 'target' => array()))); ?></li>
                           <li><?php esc_html_e('Navigate to your account settings to generate an API key.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Copy the API key and paste it above.', 'ai-product-assistant'); ?></li>
                       </ol>
                       <p><?php esc_html_e('Note: DeepSeek offers API access with various pricing tiers. Check their documentation for details.', 'ai-product-assistant'); ?></p>
                   </div>
               </div>
               
               <div class="aipa-api-instructions aipa-api-custom-instructions" style="display: none;">
                   <div class="aipa-help-box">
                       <h4><?php esc_html_e('Setting Up a Custom API Provider', 'ai-product-assistant'); ?></h4>
                       <p><?php esc_html_e('To configure a custom AI provider:', 'ai-product-assistant'); ?></p>
                       <ol>
                           <li><?php esc_html_e('Enter the complete API endpoint URL for your provider.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Select a model from the dropdown or enter a custom model name.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Select which response format template is most similar to your provider.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Enter your API key or authentication token.', 'ai-product-assistant'); ?></li>
                           <li><?php esc_html_e('Click "Test Connection" to verify your settings.', 'ai-product-assistant'); ?></li>
                       </ol>
                       <p><?php esc_html_e('Note: The format template determines how the plugin communicates with and interprets responses from your custom API provider.', 'ai-product-assistant'); ?></p>
                   </div>
               </div>
           </div>
       </div>
       
       <!-- Product Fields Tab -->
       <div id="aipa-product-fields" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'fields' ? 'active' : '')); ?>">
           <h2><?php esc_html_e('Product Fields Matching', 'ai-product-assistant'); ?></h2>
           <div class="aipa-section">
               <?php do_settings_sections('ai-product-assistant-fields'); ?>
           </div>
       </div>
       
       <!-- Search Settings Tab -->
        <div id="aipa-search-settings" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'search' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('Search Configuration', 'ai-product-assistant'); ?></h2>
            
            <div class="aipa-subtabs">
                <div class="aipa-subtab active" data-subtab="search-results">Search Results</div>
                <div class="aipa-subtab" data-subtab="search-form">Search Form</div>
                <div class="aipa-subtab" data-subtab="search-buttons">Search Buttons</div>
                <div class="aipa-subtab" data-subtab="search-performance">Search Performance</div>
            </div>
            
            <div class="aipa-section">
                <div id="search-results-subtab" class="aipa-subtab-content active">
                    <h3>Search Results Settings</h3>
                    <?php 
                    $this->do_settings_sections_for_group('ai-product-assistant-search', array(
                        'show_explanation',
                        'explanation_icon',
                        'show_add_to_cart',
                        'use_native_template',
                        'show_out_of_stock'
                    )); 
                    ?>
                </div>
                
                <div id="search-form-subtab" class="aipa-subtab-content">
                    <h3>Search Form Settings</h3>
                    <?php 
                    $this->do_settings_sections_for_group('ai-product-assistant-search', array(
                        'search_modal_title',
                        'search_modal_description',
                        'search_placeholder',
                        'voice_button_text',
                        'search_button_text'
                    )); 
                    ?>
                </div>
                
                <div id="search-buttons-subtab" class="aipa-subtab-content">
                    <h3>Search Buttons Settings</h3>
                    <?php 
                    $this->do_settings_sections_for_group('ai-product-assistant-search', array(
                        'show_floating_button',
                        'search_button_icon',
                        'search_button_css',
                        'button_icon',
                        'button_css'
                    )); 
                    ?>
                </div>
                
                <div id="search-performance-subtab" class="aipa-subtab-content">
                    <h3>Search Performance Settings</h3>
                    <?php 
                    $this->do_settings_sections_for_group('ai-product-assistant-search', array(
                        'description_length_limit',
                        'short_description_length_limit',
                        'search_batch_size',
                        'max_batches',
                        'enable_brute_force_search',
                        'ai_temperature',
                        'ai_max_tokens'
                    ));
                    ?>
                </div>
            </div>
        </div>

        <!-- Product Assistant Tab -->
        <div id="aipa-product-assistant" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'product-assistant' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('Product Assistant Configuration', 'ai-product-assistant'); ?></h2>
            <div class="aipa-section">
                <?php do_settings_sections('ai-product-assistant-product-assistant'); ?>
            </div>
        </div>
       
       <!-- Cart Analysis Tab -->
       <div id="aipa-cart-settings" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'cart' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('Cart Analysis Configuration', 'ai-product-assistant'); ?></h2>
            <div class="aipa-section">
                <?php do_settings_sections('ai-product-assistant-cart'); ?>
            </div>
       </div>
       
       <!-- Statistics Tab -->
       <div id="aipa-statistics" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'statistics' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('Usage Statistics', 'ai-product-assistant'); ?></h2>
            <div style="margin: 10px 0; padding: 10px; background-color: #fff3cd; border: 1px solid #ffeeba; border-radius: 4px; color: #856404;">
                ⚠️ <strong>Note:</strong> The token counts displayed above are approximate and intended for reference only. Actual token usage depends on the underlying tokenization mechanisms of each API provider.
            </div>
            <div class="aipa-section">
                <?php if ($active_tab == 'statistics') : ?>
                    <?php $this->display_statistics_page(); ?>
                <?php else : ?>
                    <p><?php esc_html_e('View detailed API usage statistics, including token consumption and execution times.', 'ai-product-assistant'); ?></p>
                    <a href="?page=ai-product-assistant&tab=statistics" class="button button-primary"><?php esc_html_e('View Statistics', 'ai-product-assistant'); ?></a>
                <?php endif; ?>
            </div>
       </div>
       
       <!-- Debug Tab -->
       <div id="aipa-debug" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'debug' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('Debug Settings', 'ai-product-assistant'); ?></h2>
            <div class="aipa-section">
                <?php do_settings_sections('ai-product-assistant-debug'); ?>
            </div>
       </div>
       
       <!-- Shortcodes Tab -->
        <div id="aipa-shortcodes" class="<?php echo esc_attr('aipa-tab-content ' . ($active_tab == 'shortcodes' ? 'active' : '')); ?>">
            <h2><?php esc_html_e('Available Shortcodes', 'ai-product-assistant'); ?></h2>
            <div class="aipa-section">
                <div class="aipa-settings-group">
                    <h3><?php esc_html_e('AI Search Form', 'ai-product-assistant'); ?></h3>
                    <div class="aipa-shortcode-info">
                        <code>[aipa_search_form]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode="[aipa_search_form]"><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                        <p class="description"><?php esc_html_e('Displays the AI search form that allows users to search products using natural language.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <h4><?php esc_html_e('Optional Parameters', 'ai-product-assistant'); ?></h4>
                    <ul>
                        <li><code>title</code> - <?php esc_html_e('Custom title for the search form (default: AI Product Search)', 'ai-product-assistant'); ?></li>
                        <li><code>description</code> - <?php esc_html_e('Custom description for the search form', 'ai-product-assistant'); ?></li>
                        <li><code>placeholder</code> - <?php esc_html_e('Custom placeholder text for the search input', 'ai-product-assistant'); ?></li>
                        <li><code>button_text</code> - <?php esc_html_e('Custom text for the search button', 'ai-product-assistant'); ?></li>
                    </ul>
                    
                    <div class="aipa-shortcode-example">
                        <h4><?php esc_html_e('Example with parameters:', 'ai-product-assistant'); ?></h4>
                        <code>[aipa_search_form title="Find Products" description="Tell us what you need" placeholder="What are you looking for today?" button_text="Find Products"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode='[aipa_search_form title="Find Products" description="Tell us what you need" placeholder="What are you looking for today?" button_text="Find Products"]'><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                    </div>
                </div>
                
                <div class="aipa-settings-group">
                    <h3><?php esc_html_e('AI Search Button', 'ai-product-assistant'); ?></h3>
                    <div class="aipa-shortcode-info">
                        <code>[aipa_search_button]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode="[aipa_search_button]"><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                        <p class="description"><?php esc_html_e('Adds an inline AI search button that opens the search modal when clicked. The button appearance can be customized in the Search Settings.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <div class="aipa-help-box">
                        <h4><?php esc_html_e('Using the AI Search Button', 'ai-product-assistant'); ?></h4>
                        <p><?php esc_html_e('The search button can be placed anywhere on your site using the shortcode. Here are some common use cases:', 'ai-product-assistant'); ?></p>
                        <ul style="list-style-type: disc; margin-left: 20px;">
                            <li><?php esc_html_e('Add to product category pages to help customers find specific items', 'ai-product-assistant'); ?></li>
                            <li><?php esc_html_e('Place in sidebars or widgets for easy access from any page', 'ai-product-assistant'); ?></li>
                            <li><?php esc_html_e('Include in page headers or menus as an alternative search option', 'ai-product-assistant'); ?></li>
                        </ul>
                        <p><?php esc_html_e('To customize the button appearance, go to the Search Settings tab and look for the "Inline Search Button" section.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <div class="aipa-shortcode-example">
                        <h4><?php esc_html_e('Example usage:', 'ai-product-assistant'); ?></h4>
                        <pre style="background: #f5f5f5; padding: 10px; border-radius: 4px;">
            &lt;div class="my-search-section"&gt;
                &lt;h3&gt;Need help finding something?&lt;/h3&gt;
                &lt;p&gt;Try our AI-powered product search&lt;/p&gt;
                [aipa_search_button]
            &lt;/div&gt;
                            </pre>
                            <button class="aipa-copy-shortcode button button-secondary" data-shortcode='<div class="my-search-section">
                <h3>Need help finding something?</h3>
                <p>Try our AI-powered product search</p>
                [aipa_search_button]
            </div>'><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                    </div>

                    <div class="aipa-shortcode-example">
                        <h4><?php esc_html_e('Example with parameters:', 'ai-product-assistant'); ?></h4>
                        <code>[aipa_search_button button_text="Ask AI"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode='[aipa_search_button button_text="Ask AI"]'><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                    </div>
                </div>

                <div class="aipa-settings-group">
                    <h3><?php esc_html_e('AI Cart Analysis', 'ai-product-assistant'); ?></h3>
                    <div class="aipa-shortcode-info">
                        <code>[aipa_cart_analysis]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode="[aipa_cart_analysis]"><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                        <p class="description"><?php esc_html_e('Displays the cart analysis form that allows users to check if their cart contents meet their requirements.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <h4><?php esc_html_e('Optional Parameters', 'ai-product-assistant'); ?></h4>
                    <ul>
                        <li><code>title</code> - <?php esc_html_e('Custom title for the cart analysis section', 'ai-product-assistant'); ?></li>
                        <li><code>description</code> - <?php esc_html_e('Custom description for the cart analysis section', 'ai-product-assistant'); ?></li>
                        <li><code>placeholder</code> - <?php esc_html_e('Custom placeholder text for the analysis input', 'ai-product-assistant'); ?></li>
                        <li><code>button_text</code> - <?php esc_html_e('Custom text for the analysis button', 'ai-product-assistant'); ?></li>
                    </ul>
                    
                    <div class="aipa-help-box">
                        <h4><?php esc_html_e('Use Cases for Cart Analysis', 'ai-product-assistant'); ?></h4>
                        <p><?php esc_html_e('The cart analysis feature helps customers in various scenarios:', 'ai-product-assistant'); ?></p>
                        <ul style="list-style-type: disc; margin-left: 20px;">
                            <li><?php echo wp_kses(__('<strong>Compatibility check</strong>: "Will these computer parts work together?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                            <li><?php echo wp_kses(__('<strong>Project completion</strong>: "Are these ingredients enough to make pad thai for 4 people?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                            <li><?php echo wp_kses(__('<strong>Suitability verification</strong>: "Are these products suitable for sensitive skin?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                            <li><?php echo wp_kses(__('<strong>Requirement fulfillment</strong>: "Will these camping supplies be sufficient for a 3-day trip?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                        </ul>
                        <p><?php esc_html_e('Consider adding this shortcode to your cart page, checkout page, or creating a dedicated "Cart Check" page.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <div class="aipa-shortcode-example">
                        <h4><?php esc_html_e('Example with parameters:', 'ai-product-assistant'); ?></h4>
                        <code>[aipa_cart_analysis title="Check Your Cart" description="Let AI verify your purchase" placeholder="What are you trying to do with these items?" button_text="Verify Cart"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode='[aipa_cart_analysis title="Check Your Cart" description="Let AI verify your purchase" placeholder="What are you trying to do with these items?" button_text="Verify Cart"]'><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                    </div>
                </div>

                <div class="aipa-settings-group">
                    <h3><?php esc_html_e('Product Assistant Button', 'ai-product-assistant'); ?></h3>
                    <div class="aipa-shortcode-info">
                        <code>[aipa_product_assistant_button product_id="123"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode="[aipa_product_assistant_button product_id=\"123\"]"><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                        <p class="description"><?php esc_html_e('Adds a button that opens the product assistant modal for a specific product.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <h4><?php esc_html_e('Required Parameters', 'ai-product-assistant'); ?></h4>
                    <ul>
                        <li><code>product_id</code> - <?php esc_html_e('ID of the product to analyze (required)', 'ai-product-assistant'); ?></li>
                    </ul>
                    
                    <h4><?php esc_html_e('Optional Parameters', 'ai-product-assistant'); ?></h4>
                    <ul>
                        <li><code>button_text</code> - <?php esc_html_e('Custom text for the button', 'ai-product-assistant'); ?></li>
                    </ul>
                    
                    <div class="aipa-shortcode-example">
                        <h4><?php esc_html_e('Example with parameters:', 'ai-product-assistant'); ?></h4>
                        <code>[aipa_product_assistant_button product_id="123" button_text="Ask About This Product"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode='[aipa_product_assistant_button product_id="123" button_text="Ask About This Product"]'><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                    </div>
                </div>

                <div class="aipa-settings-group">
                    <h3><?php esc_html_e('Product Assistant Form', 'ai-product-assistant'); ?></h3>
                    <div class="aipa-shortcode-info">
                        <code>[aipa_product_assistant_form product_id="123"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode="[aipa_product_assistant_form product_id=\"123\"]"><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                        <p class="description"><?php esc_html_e('Displays an embedded product assistant form for a specific product.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <h4><?php esc_html_e('Required Parameters', 'ai-product-assistant'); ?></h4>
                    <ul>
                        <li><code>product_id</code> - <?php esc_html_e('ID of the product to analyze (required)', 'ai-product-assistant'); ?></li>
                    </ul>
                    
                    <h4><?php esc_html_e('Optional Parameters', 'ai-product-assistant'); ?></h4>
                    <ul>
                        <li><code>title</code> - <?php esc_html_e('Custom title for the assistant form', 'ai-product-assistant'); ?></li>
                        <li><code>description</code> - <?php esc_html_e('Custom description for the assistant form', 'ai-product-assistant'); ?></li>
                        <li><code>placeholder</code> - <?php esc_html_e('Custom placeholder text for the input field', 'ai-product-assistant'); ?></li>
                        <li><code>button_text</code> - <?php esc_html_e('Custom text for the analysis button', 'ai-product-assistant'); ?></li>
                    </ul>
                    
                    <div class="aipa-help-box">
                        <h4><?php esc_html_e('Use Cases for Product Assistant', 'ai-product-assistant'); ?></h4>
                        <p><?php esc_html_e('The product assistant feature helps customers in various scenarios:', 'ai-product-assistant'); ?></p>
                        <ul style="list-style-type: disc; margin-left: 20px;">
                            <li><?php echo wp_kses(__('<strong>Product questions</strong>: "Is this camera suitable for wildlife photography?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                            <li><?php echo wp_kses(__('<strong>Feature inquiries</strong>: "What makes this laptop good for gaming?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                            <li><?php echo wp_kses(__('<strong>Compatibility checks</strong>: "Will this memory card work with my Canon camera?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                            <li><?php echo wp_kses(__('<strong>Use case validation</strong>: "Can I use this mixer for making bread dough?"', 'ai-product-assistant'), array('strong' => array())); ?></li>
                        </ul>
                        <p><?php esc_html_e('Consider adding this shortcode to product comparison pages, category archives, or custom landing pages.', 'ai-product-assistant'); ?></p>
                    </div>
                    
                    <div class="aipa-shortcode-example">
                        <h4><?php esc_html_e('Example with parameters:', 'ai-product-assistant'); ?></h4>
                        <code>[aipa_product_assistant_form product_id="123" title="Product Assistant" description="Ask anything about this product" placeholder="What would you like to know?" button_text="Get Answer"]</code>
                        <button class="aipa-copy-shortcode button button-secondary" data-shortcode='[aipa_product_assistant_form product_id="123" title="Product Assistant" description="Ask anything about this product" placeholder="What would you like to know?" button_text="Get Answer"]'><?php esc_html_e('Copy', 'ai-product-assistant'); ?></button>
                    </div>
                </div>
            </div>
        </div>
       
       <?php
       // Allow Pro version to add tab content before submit button
       do_action('aipa_admin_tab_content_before_submit', $active_tab);
       ?>
       
       <div class="submit">
           <?php submit_button(); ?>
       </div>
   </form>
</div>