<?php
/**
 * Admin dashboard widget template
 *
 * @package AI_Product_Assistant
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Get plugin settings and statistics
$options = get_option('aipa_settings');
$api_provider = isset($options['api_provider']) ? $options['api_provider'] : 'openai';
$api_key = isset($options['api_key']) ? $options['api_key'] : '';
$api_connected = !empty($api_key);

// Get usage statistics (placeholder - you'd need to implement actual tracking)
$search_count = get_option('aipa_search_count', 0);
$analysis_count = get_option('aipa_analysis_count', 0);
$total_requests = $search_count + $analysis_count;
?>

<div class="aipa-dashboard-widget">
    <div class="aipa-dashboard-widget-content">
        <div class="aipa-stats-grid">
            <div class="aipa-stat-box">
                <div class="aipa-stat-value"><?php echo esc_html($search_count); ?></div>
                <div class="aipa-stat-label"><?php esc_html_e('AI Searches', 'ai-product-assistant'); ?></div>
            </div>
            
            <div class="aipa-stat-box">
                <div class="aipa-stat-value"><?php echo esc_html($analysis_count); ?></div>
                <div class="aipa-stat-label"><?php esc_html_e('Cart Analyses', 'ai-product-assistant'); ?></div>
            </div>
            
            <div class="aipa-stat-box">
                <div class="aipa-stat-value"><?php echo esc_html($total_requests); ?></div>
                <div class="aipa-stat-label"><?php esc_html_e('Total AI Requests', 'ai-product-assistant'); ?></div>
            </div>
        </div>
        
        <div class="<?php echo esc_attr('aipa-api-status ' . ($api_connected ? 'connected' : 'not-connected')); ?>">
            <div class="aipa-api-status-dot"></div>
            <?php if ($api_connected) : ?>
                <?php 
                /* translators: %s: API provider name (e.g., OpenAI, Claude) */
                printf(esc_html(__('Connected to %s API', 'ai-product-assistant')), esc_html(ucfirst($api_provider))); 
                ?>
            <?php else : ?>
                <?php esc_html_e('API Not Connected', 'ai-product-assistant'); ?>
            <?php endif; ?>
        </div>
        
        <?php if (!$api_connected) : ?>
            <p>
                <?php esc_html_e('Please configure your API settings to start using the AI features.', 'ai-product-assistant'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=ai-product-assistant')); ?>" class="button button-small"><?php esc_html_e('Configure Settings', 'ai-product-assistant'); ?></a>
            </p>
        <?php endif; ?>
        
        <div class="aipa-quick-links">
            <h4><?php esc_html_e('Quick Links', 'ai-product-assistant'); ?></h4>
            <ul>
                <li><a href="<?php echo esc_url(admin_url('admin.php?page=ai-product-assistant&tab=ai-provider')); ?>"><?php esc_html_e('AI Provider Settings', 'ai-product-assistant'); ?></a></li>
                <li><a href="<?php echo esc_url(admin_url('admin.php?page=ai-product-assistant&tab=search')); ?>"><?php esc_html_e('Search Settings', 'ai-product-assistant'); ?></a></li>
                <li><a href="<?php echo esc_url(admin_url('admin.php?page=ai-product-assistant&tab=cart')); ?>"><?php esc_html_e('Cart Analysis Settings', 'ai-product-assistant'); ?></a></li>
                <li><a href="<?php echo esc_url(admin_url('admin.php?page=ai-product-assistant&tab=shortcodes')); ?>"><?php esc_html_e('Shortcodes', 'ai-product-assistant'); ?></a></li>
            </ul>
        </div>
    </div>
</div>
