jQuery(document).ready(function($) {
    // Ensure global tooltip container exists
    if ($("#aipa-global-tooltip").length === 0) {
        $("body").append("<div id='aipa-global-tooltip'></div>");
    }
    
    // Add hover events for all explanation icons
    $(".aipa-explanation-icon").on("mouseenter", function(e) {
        // Get explanation text
        var tooltipText = $(this).data("explanation");
        if (!tooltipText) return;
        
        // Get icon position
        var iconPos = $(this).offset();
        var iconWidth = $(this).width();
        var iconHeight = $(this).height();
        
        // Set tooltip text
        var $tooltip = $("#aipa-global-tooltip");
        $tooltip.text(tooltipText);
        
        // Set initial position
        $tooltip.css({
            "left": (iconPos.left + iconWidth/2) + "px",
            "top": (iconPos.top - 10) + "px",
        }).show();
        
        // Adjust position to fit window boundaries
        var tooltipWidth = $tooltip.outerWidth();
        var tooltipHeight = $tooltip.outerHeight();
        var windowWidth = $(window).width();
        var scrollTop = $(window).scrollTop();
        
        // Horizontal adjustment
        var leftPosition = iconPos.left + iconWidth/2 - tooltipWidth/2;
        if (leftPosition < 10) {
            leftPosition = 10;
        } else if (leftPosition + tooltipWidth > windowWidth - 10) {
            leftPosition = windowWidth - tooltipWidth - 10;
        }
        $tooltip.css("left", leftPosition + "px");
        
        // Vertical adjustment
        var topPosition = iconPos.top - tooltipHeight - 15;
        if (topPosition < scrollTop) {
            // If would extend beyond top boundary, show below icon
            topPosition = iconPos.top + iconHeight + 15;
            // Flip triangle direction
            $tooltip.addClass("reverse-arrow");
        } else {
            $tooltip.removeClass("reverse-arrow");
        }
        $tooltip.css("top", topPosition + "px");
    }).on("mouseleave", function() {
        // Hide tooltip when mouse leaves
        $("#aipa-global-tooltip").hide();
    });
});