/**
 * AI Product Assistant - Product Assistant JavaScript
 */

var AIPA_ProductAssistant = (function($) {
    'use strict';
    
    var isAnalyzing = false;
    
    function init() {
        $(document).on('click', '.aipa-product-assistant-btn', function(e) {
            e.preventDefault();
            
            var productId = $(this).data('product-id');
            
            $('#aipa-product-id').val(productId);
            
            $('#aipa-product-assistant-modal').css('display', 'flex').hide().fadeIn(300);
            $('#aipa-product-assistant-input').focus();
        });
        
        $(document).on('click', '.aipa-close', function() {
            $(this).closest('.aipa-product-assistant-modal').fadeOut(300);
            resetForm();
        });
        
        $(window).on('click', function(event) {
            if ($(event.target).hasClass('aipa-product-assistant-modal')) {
                $('.aipa-product-assistant-modal').fadeOut(300);
                resetForm();
            }
        });
        
        $(document).on('click', '#aipa-product-assistant-btn', function(e) {
            e.preventDefault();
            performAnalysis();
        });
        
        $('#aipa-product-assistant-input').on('keypress', function(e) {
            if (e.which === 13 && !e.shiftKey) {
                e.preventDefault();
                performAnalysis();
            }
        });
    }
    
    function performAnalysis() {
        var query = $('#aipa-product-assistant-input').val().trim();
        var productId = $('#aipa-product-id').val();
        
        if (query === '') {
            displayError(aipa_product_assistant_data.empty_query_message);
            return;
        }
        
        if (isAnalyzing) {
            return;
        }
        
        $('#aipa-product-assistant-error').hide().empty();
        
        isAnalyzing = true;
        $('#aipa-product-assistant-btn').addClass('analyzing');
        $('#aipa-product-assistant-btn .aipa-btn-text').text(aipa_product_assistant_data.analyzing_text);
        $('#aipa-product-assistant-container').empty();
        $('#aipa-product-assistant-loading').show();
        
        $.ajax({
            url: aipa_product_assistant_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_product_assistant',
                query: query,
                product_id: productId,
                nonce: aipa_product_assistant_data.nonce
            },
            dataType: 'json',
            success: function(response) {
                $('#aipa-product-assistant-btn').removeClass('analyzing');
                $('#aipa-product-assistant-btn .aipa-btn-text').text(aipa_product_assistant_data.assistant_button);
                $('#aipa-product-assistant-loading').hide();
                isAnalyzing = false;
                
                if (response.success) {
                    $('#aipa-product-assistant-container').html(response.data.html);
                    
                    var $resultsContainer = $('#aipa-product-assistant-container');
                    var $modal = $('#aipa-product-assistant-modal .aipa-product-assistant-modal-content');
                    $modal.animate({
                        scrollTop: $resultsContainer.offset().top - $modal.offset().top + $modal.scrollTop()
                    }, 500);
                } else {
                    // Display unified AI service error message
                    if (response.data.code === 'aipa_service_error') {
                        displayError(aipa_product_assistant_data.aipa_service_error_message);
                    } else {
                        displayError(response.data.message || aipa_product_assistant_data.error_message, response.data.code);
                    }
                }
            },
            error: function() {
                $('#aipa-product-assistant-btn').removeClass('analyzing');
                $('#aipa-product-assistant-btn .aipa-btn-text').text(aipa_product_assistant_data.assistant_button);
                $('#aipa-product-assistant-loading').hide();
                isAnalyzing = false;
                
                displayError(aipa_product_assistant_data.error_message);
            }
        });
    }
    
    function displayError(message, errorCode) {
        var errorHtml = '';
        
        // Check if this is an authentication error
        if (errorCode === 'aipa_auth_required' || message.indexOf('log in') !== -1) {
            errorHtml = '<p>' + message + ' <a href="' + (aipa_product_assistant_data.login_url || '/wp-login.php') + '">' + (aipa_product_assistant_data.login_text || 'Log in here') + '</a></p>';
        } else {
            errorHtml = '<p>' + message + '</p>';
        }
        
        $('#aipa-product-assistant-error').html(errorHtml).show();
    }
    
    function resetForm() {
        $('#aipa-product-assistant-input').val('');
        $('#aipa-product-assistant-error').hide().empty();
        $('#aipa-product-assistant-container').empty();
        $('#aipa-product-assistant-loading').hide();
        $('#aipa-product-assistant-btn').removeClass('analyzing');
        $('#aipa-product-assistant-btn .aipa-btn-text').text(aipa_product_assistant_data.assistant_button);
        isAnalyzing = false;
    }
    
    function displayShortcodeError($error, message, errorCode) {
        var errorHtml = '';
        
        // Check if this is an authentication error
        if (errorCode === 'aipa_auth_required' || message.indexOf('log in') !== -1) {
            errorHtml = '<p>' + message + ' <a href="' + (aipa_product_assistant_data.login_url || '/wp-login.php') + '">' + (aipa_product_assistant_data.login_text || 'Log in here') + '</a></p>';
        } else {
            errorHtml = '<p>' + message + '</p>';
        }
        
        $error.html(errorHtml).show();
    }
    
    function initEmbeddedForm(formId, inputId, buttonId, errorId, loadingId, resultsId) {
        var $form = $('#' + formId);
        var $input = $('#' + inputId);
        var $button = $('#' + buttonId);
        var $error = $('#' + errorId);
        var $loading = $('#' + loadingId);
        var $results = $('#' + resultsId);
        var $resultsContainer = $results.find('.aipa-product-assistant-container');
        
        $button.on('click', function(e) {
            e.preventDefault();
            
            var query = $input.val().trim();
            var productId = $form.find('.aipa-product-id').val();
            
            if (query === '') {
                $error.html('<p>' + aipa_product_assistant_data.empty_query_message + '</p>').show();
                return;
            }
            
            if ($button.hasClass('analyzing')) {
                return;
            }
            
            $error.hide().empty();
            
            $button.addClass('analyzing');
            $button.find('.aipa-btn-text').text(aipa_product_assistant_data.analyzing_text);
            $resultsContainer.empty();
            $loading.show();
            
            $.ajax({
                url: aipa_product_assistant_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'aipa_product_assistant',
                    query: query,
                    product_id: productId,
                    nonce: aipa_product_assistant_data.nonce
                },
                dataType: 'json',
                success: function(response) {
                    $button.removeClass('analyzing');
                    $button.find('.aipa-btn-text').text(aipa_product_assistant_data.assistant_button);
                    $loading.hide();
                    
                    if (response.success) {
                        $resultsContainer.html(response.data.html);
                        
                        $('html, body').animate({
                            scrollTop: $results.offset().top - 100
                        }, 500);
                    } else {
                        // Check for unified AI service error first
                        if (response.data.code === 'aipa_service_error') {
                            displayShortcodeError($error, aipa_product_assistant_data.aipa_service_error_message);
                            return;
                        }
                        
                        var errorMessage = response.data.message || aipa_product_assistant_data.error_message;
                        var errorCode = response.data.code;
                        var errorHtml = '';
                        
                        // Check if this is an authentication error
                        if (errorCode === 'aipa_auth_required' || errorMessage.indexOf('log in') !== -1) {
                            errorHtml = '<p>' + errorMessage + ' <a href="' + (aipa_product_assistant_data.login_url || '/wp-login.php') + '">' + (aipa_product_assistant_data.login_text || 'Log in here') + '</a></p>';
                        } else {
                            errorHtml = '<p>' + errorMessage + '</p>';
                        }
                        
                        $error.html(errorHtml).show();
                    }
                },
                error: function() {
                    $button.removeClass('analyzing');
                    $button.find('.aipa-btn-text').text(aipa_product_assistant_data.assistant_button);
                    $loading.hide();
                    
                    $error.html('<p>' + aipa_product_assistant_data.error_message + '</p>').show();
                }
            });
        });
        
        $input.on('keypress', function(e) {
            if (e.which === 13 && !e.shiftKey) {
                e.preventDefault();
                $button.click();
            }
        });
    }
    
    return {
        init: init,
        initEmbeddedForm: initEmbeddedForm
    };
    
})(jQuery);

jQuery(document).ready(function() {
    AIPA_ProductAssistant.init();
});