/**
 * AI Product Assistant Admin JavaScript
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // Initialize variables
    var apiProvider = $('#api_provider').val();
    var apiKey = $('#api_key').val();
    var apiUrl = $('#api_url').val();
    var apiModelSelected = false;

    // Inline search button image upload - need to define these variables first
    var buttonMediaUploader;
    var mediaUploader;

    // Listen for use_native_template toggle, control show_out_of_stock visibility
    $('#use_native_template').on('change', function() {
        if ($(this).is(':checked')) {
            // If native template is enabled, completely hide show_out_of_stock option
            $('#show_out_of_stock_container').slideUp(300);
        } else {
            // If native template is disabled, show show_out_of_stock option
            $('#show_out_of_stock_container').slideDown(300);
        }
    }).trigger('change'); // Trigger once when page loads

    // Listen for floating button enable/disable toggle
    $('#show_floating_button').on('change', function() {
        if ($(this).is(':checked')) {
            $('#floating_button_preview_container').fadeIn(300);
        } else {
            $('#floating_button_preview_container').fadeOut(300);
        }
    });

    // Listen for changes to CSS input box and icon settings
    $('#search_button_css, #search_button_icon').on('input', updateFloatingButtonPreview);
    $('input[name="aipa_settings[search_button_icon_type]"]').on('change', updateFloatingButtonPreview);

    // Function to update floating button preview
    function updateFloatingButtonPreview() {
        var iconType = $('input[name="aipa_settings[search_button_icon_type]"]:checked').val();
        var iconText = $('#search_button_icon').val();
        var iconImage = $('#search_button_icon_image').val();
        var buttonCss = $('#search_button_css').val();
        
        // Extract normal state CSS from the full CSS text
        var normalStateMatch = buttonCss.match(/body\s+\.aipa-floating-search-btn\s*{([^}]+)}/);
        var hoverStateMatch = buttonCss.match(/body\s+\.aipa-floating-search-btn:hover\s*{([^}]+)}/);
        
        var normalCss = normalStateMatch ? normalStateMatch[1] : buttonCss;
        var hoverCss = hoverStateMatch ? hoverStateMatch[1] : '';
        
        // Clean CSS for preview
        var cleanCss = normalCss.replace(/!important/g, '');
        
        var iconHtml = '';
        if (iconType === 'image' && iconImage) {
            iconHtml = '<img src="' + iconImage + '" alt="Search" style="max-width: 24px; max-height: 24px;">';
        } else {
            iconHtml = iconText || 'AI';
        }
        
        // Update preview button
        var $previewButton = $('#preview_floating_button');
        $previewButton.attr('style', cleanCss + '; position: absolute; bottom: 20px; right: 20px;');
        $previewButton.html(iconHtml);
        
        // Parse hover styles if available
        if (hoverCss) {
            var hoverStyles = {};
            hoverCss.split(';').forEach(function(style) {
                if (style.trim()) {
                    var parts = style.split(':');
                    if (parts.length === 2) {
                        var prop = parts[0].trim();
                        var value = parts[1].replace(/!important/g, '').trim();
                        hoverStyles[prop] = value;
                    }
                }
            });
            
            // Add hover effect
            $previewButton.off('mouseenter mouseleave');
            $previewButton.on('mouseenter', function() {
                var $this = $(this);
                $this.data('original-styles', {});
                
                // Apply hover styles
                $.each(hoverStyles, function(prop, value) {
                    $this.data('original-styles')[prop] = $this.css(prop);
                    $this.css(prop, value);
                });
            }).on('mouseleave', function() {
                var $this = $(this);
                var originalStyles = $this.data('original-styles');
                
                // Restore original styles
                $.each(originalStyles || {}, function(prop, value) {
                    $this.css(prop, value);
                });
            });
        }
    }

    // Extract background color from CSS string
    function extractBackgroundColor(cssString) {
        var match = cssString.match(/background-color:\s*([^;!]+)/i);
        return match ? match[1].trim() : null;
    }

    // Lighten or darken color (positive amount = lighter, negative amount = darker)
    function lightenDarkenColor(color, amount) {
        var usePound = false;
        
        if (color[0] == "#") {
            color = color.slice(1);
            usePound = true;
        }

        // Handle rgb format
        if (color.indexOf('rgb') === 0) {
            var rgbMatch = color.match(/rgba?\((\d+),\s*(\d+),\s*(\d+)/i);
            if (rgbMatch) {
                color = componentToHex(parseInt(rgbMatch[1])) + 
                    componentToHex(parseInt(rgbMatch[2])) + 
                    componentToHex(parseInt(rgbMatch[3]));
            } else {
                return '#45a049'; // Default color
            }
        }

        var num = parseInt(color, 16);

        var r = (num >> 16) + amount;
        var g = ((num >> 8) & 0x00FF) + amount;
        var b = (num & 0x0000FF) + amount;

        r = Math.min(Math.max(0, r), 255);
        g = Math.min(Math.max(0, g), 255);
        b = Math.min(Math.max(0, b), 255);

        return (usePound ? "#" : "") + (g | (b << 8) | (r << 16)).toString(16).padStart(6, '0');
    }

    // Convert number to hexadecimal
    function componentToHex(c) {
        var hex = c.toString(16);
        return hex.length == 1 ? "0" + hex : hex;
    }

    $('#upload_button_icon_image').on('click', function(e) {
        e.preventDefault();
        
        // If uploader already exists, open it
        if (buttonMediaUploader) {
            buttonMediaUploader.open();
            return;
        }
        
        // Create media uploader
        buttonMediaUploader = wp.media({
            title: aipa_admin_data.select_icon_image_text,
            button: {
                text: aipa_admin_data.use_this_image_text
            },
            multiple: false
        });
        
        // When image is selected
        buttonMediaUploader.on('select', function() {
            var attachment = buttonMediaUploader.state().get('selection').first().toJSON();
            $('#button_icon_image').val(attachment.url);
            $('#button_icon_image_preview img').attr('src', attachment.url);
            $('#button_icon_image_preview').show();
            $('#remove_button_icon_image').show();
            
            // Automatically select "Use custom image" option
            $('input[name="aipa_settings[button_icon_type]"][value="image"]').prop('checked', true);
            
            updateButtonPreview();
        });
        
        // Open media uploader
        buttonMediaUploader.open();
    });

    // Remove image
    $('#remove_button_icon_image').on('click', function(e) {
        e.preventDefault();
        $('#button_icon_image').val('');
        $('#button_icon_image_preview').hide();
        $(this).hide();
        updateButtonPreview();
    });

    // Button CSS reset
    $('#button_css_reset').on('click', function(e) {
        e.preventDefault();
        $('#button_css').val(aipa_admin_data.default_css.button_css);
        updateButtonPreview();
    });

    // Update button preview
    function updateButtonPreview() {
        var iconType = $('input[name="aipa_settings[button_icon_type]"]:checked').val();
        var iconText = $('#button_icon').val();
        var iconImage = $('#button_icon_image').val();
        var buttonCss = $('#button_css').val();
        
        var iconHtml = '';
        if (iconType === 'image' && iconImage) {
            iconHtml = '<img src="' + iconImage + '" alt="Search" style="max-width: 24px; max-height: 24px;">';
        } else {
            iconHtml = iconText || 'AI';
        }
        
        var previewHtml = '<div style="margin: 10px 0;">';
        previewHtml += '<button id="preview_button" style="' + buttonCss.replace(/!important/g, '') + '">' + iconHtml + '</button>';
        previewHtml += '</div>';
        
        $('#button_preview').html(previewHtml);
    }

    // Listen for input changes to update preview
    $('#button_icon, #button_css').on('input', updateButtonPreview);
    $('input[name="aipa_settings[button_icon_type]"]').on('change', updateButtonPreview);
    
    // Custom field management functionality
    var customFields = [];
    var customFieldsInitialized = false;
    
    
    
    // Note: renderCustomFieldsTable function is no longer needed as we now use checkbox list instead of table

    // Run preview update once on initialization
    $(document).ready(function() {
        // Set default CSS if text box is empty
        if ($("#search_button_css").val() === '') {
            $("#search_button_css").val(aipa_admin_data.default_css.search_button);
        }
        if ($("#cart_analysis_css").val() === '') {
            $("#cart_analysis_css").val(aipa_admin_data.default_css.cart_analysis);
        }
        if ($("#button_css").val() === '') {
            $("#button_css").val(aipa_admin_data.default_css.button_css);
        }
        
        updateButtonPreview();
        updateFloatingButtonPreview();
        
    });

    // Icon image upload
    $('#upload_icon_image').on('click', function(e) {
        e.preventDefault();
        
        // If uploader already exists, open it
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }
        
        // Create media uploader
        mediaUploader = wp.media({
            title: aipa_admin_data.select_icon_image_text,
            button: {
                text: aipa_admin_data.use_this_image_text
            },
            multiple: false
        });
        
        // When image is selected
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#search_button_icon_image').val(attachment.url);
            $('#icon_image_preview img').attr('src', attachment.url);
            $('#icon_image_preview').show();
            $('#remove_icon_image').show();
            
            // Automatically select "Use custom image" option
            $('input[name="aipa_settings[search_button_icon_type]"][value="image"]').prop('checked', true);

            // Update preview
            updateFloatingButtonPreview();        
        });
        
        // Open media uploader
        mediaUploader.open();
    });

    // Remove image
    $('#remove_icon_image').on('click', function(e) {
        e.preventDefault();
        $('#search_button_icon_image').val('');
        $('#icon_image_preview').hide();
        $(this).hide();
        
        // Update preview
        updateFloatingButtonPreview();
    });

    // API Key field toggle
    $('#api_key_show').on('click', function() {
        var $field = $('#api_key');
        
        if ($field.attr('type') === 'password') {
            $field.attr('type', 'text');
            $(this).text('Hide');
        } else {
            $field.attr('type', 'password');
            $(this).text('Show');
        }
    });

    // API Provider select handler
    $('#api_provider').on('change', function() {
        var provider = $(this).val();
        
        // Set default URL and disable/enable input box
        if (provider !== 'custom') {
            var defaultUrl = aipa_admin_data.default_urls[provider] || '';
            $('#api_url').val(defaultUrl).prop('disabled', true);
        } else {
            $('#api_url').prop('disabled', false);
        }
        
        $('#api_model_custom').val('').hide();
        
        updateModelDropdownWithDefaults(provider);
        
        $('.aipa-api-instructions').hide();
        $('.aipa-api-' + provider + '-instructions').show();
        
        apiModelSelected = false;

        // Show/hide custom provider hints
        if (provider === 'custom') {
            $('#api_url_custom_hint').show();
            $('#api_key_custom_note').show();
        } else {
            $('#api_url_custom_hint').hide();
            $('#api_key_custom_note').hide();
        }
    });

    $(document).ready(function() {
        if ($('#api_provider').val() !== 'custom') {
            $('#api_url').prop('disabled', true);
        }
    });

    // Reset URL to default button
    $('#api_url_reset').on('click', function() {
        var provider = $('#api_provider').val();
        var defaultUrl = aipa_admin_data.default_urls[provider] || '';
        $('#api_url').val(defaultUrl);
    });
    
    // Connect API button - fetch available models
    $('#api_connect').on('click', function() {
        var provider = $('#api_provider').val();
        var apiKey = $('#api_key').val();
        var apiUrl = $('#api_url').val();

        if (!apiKey && provider !== 'custom') {
            alert('Please enter an API key first.');
            $('#api_key').focus();
            return;
        }
        
        // Change button state
        var $button = $(this);
        var originalText = $button.text();
        $button.prop('disabled', true).text(aipa_admin_data.connecting_text);
        
        var $messageContainer = $('#api-connect-message');
        if ($messageContainer.length === 0) {
            $messageContainer = $('<div id="api-connect-message" style="display:inline-block; margin-left:10px; padding:5px;"></div>');
            $button.after($messageContainer);
        }
        $messageContainer.removeClass('success error').empty();
        
        // Get models via AJAX
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_get_api_models',
                provider: provider,
                api_key: apiKey,
                api_url: apiUrl,
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success) {
                    updateModelDropdown(provider, response.data.models);
                    apiModelSelected = true;
                    
                    // Show success message next to button instead of popup confirmation
                    $messageContainer.addClass('success').html('<span style="color:#4CAF50;">' + response.data.message + '</span>');
                    
                    // Fade out message after 3 seconds
                    setTimeout(function() {
                        $messageContainer.fadeOut('slow', function() {
                            $(this).empty().show().removeClass('success');
                        });
                    }, 3000);
                } else {
                    // Show error message next to button
                    $messageContainer.addClass('error').html('<span style="color:#f44336;">' + response.data.message + '</span>');
                }
            },
            error: function() {
                $messageContainer.addClass('error').html('<span style="color:#f44336;">Connection error occurred while fetching models. Please try again.</span>');
            },
            complete: function() {
                $button.prop('disabled', false).text(originalText);
            }
        });
    });
    
    // Function to update model dropdown with default options
    function updateModelDropdownWithDefaults(provider) {
        var $modelSelect = $('#api_model_select');
        $modelSelect.empty();
        
        // Get the provider's default models
        var models = aipa_admin_data.models[provider] || [];
        
        // Get current API model from settings
        var currentModel = '';
        if (aipa_admin_data.settings && aipa_admin_data.settings.api_model) {
            currentModel = aipa_admin_data.settings.api_model;
        }
        
        var foundMatch = false;
        
        // Populate the dropdown
        $.each(models, function(i, model) {
            var option = $('<option></option>')
                .attr('value', model.value)
                .text(model.text);
                
            if (currentModel === model.value) {
                option.attr('selected', 'selected');
                foundMatch = true;
            }
            
            $modelSelect.append(option);
        });
        
        // If custom model is needed
        if (!foundMatch && currentModel && models.some(function(m) { return m.value === 'custom'; })) {
            $modelSelect.val('custom');
            $('#api_model_custom').val(currentModel).show();
        } else if (!foundMatch && currentModel) {
            // Add the current model as an option
            var option = $('<option></option>')
                .attr('value', currentModel)
                .attr('selected', 'selected')
                .text(currentModel);
            
            $modelSelect.append(option);
        } else {
            $('#api_model_custom').hide();
        }
        
        // Trigger change to ensure correct display state of custom model input
        $modelSelect.trigger('change');
    }
    
    // Function to update model dropdown with fetched models
    function updateModelDropdown(provider, models) {
        var $modelSelect = $('#api_model_select');
        $modelSelect.empty();
        
        // Get current API model from settings
        var currentModel = '';
        if (aipa_admin_data.settings && aipa_admin_data.settings.api_model) {
            currentModel = aipa_admin_data.settings.api_model;
        }
        
        var foundMatch = false;
        
        // Populate the dropdown
        $.each(models, function(i, model) {
            var option = $('<option></option>')
                .attr('value', model.value)
                .text(model.text);
                
            if (currentModel === model.value) {
                option.attr('selected', 'selected');
                foundMatch = true;
            }
            
            $modelSelect.append(option);
        });
        
        // If no match found, select the first option
        if (!foundMatch && models.length > 0) {
            $modelSelect.val(models[0].value);
        }
        
        // If custom model is needed
        if ($modelSelect.val() === 'custom') {
            $('#api_model_custom').show().focus();
        } else {
            $('#api_model_custom').hide();
        }
    }
    
    // Handle model selection change
    $('#api_model_select').on('change', function() {
        if ($(this).val() === 'custom') {
            $('#api_model_custom').show().focus();
        } else {
            $('#api_model_custom').hide();
        }
    });
    
    // Test API connection button
    $('#aipa-test-api-connection').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $result = $('#aipa-api-test-result');
        
        // Get the API settings
        var provider = $('#api_provider').val();
        var apiKey = $('#api_key').val();
        var apiUrl = $('#api_url').val();
        var apiModel = $('#api_model_select').val() === 'custom' ? $('#api_model_custom').val() : $('#api_model_select').val();
        var formatTemplate = $('#format_template').val();
        
        if (!apiKey && provider !== 'custom') {
            $result.html('<div class="notice notice-error inline"><p>Please enter an API key first.</p></div>');
            return;
        }

        // Change button state
        $button.prop('disabled', true).text(aipa_admin_data.testing_text);
        $result.html('<div class="notice notice-info inline"><p>Testing connection...</p></div>');
        
        // Send AJAX request to test the connection
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_test_api_connection',
                provider: provider,
                api_key: apiKey,
                api_url: apiUrl,
                api_model: apiModel,
                format_template: formatTemplate,
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="notice notice-success inline"><p>' + response.data.message + '</p></div>');
                } else {
                    $result.html('<div class="notice notice-error inline"><p>Error: ' + response.data.message + '</p></div>');
                }
            },
            error: function() {
                $result.html('<div class="notice notice-error inline"><p>Connection error. Please try again.</p></div>');
            },
            complete: function() {
                $button.prop('disabled', false).text(aipa_admin_data.test_button_text);
            }
        });
    });
    
    // Test model connection button
    $('#aipa-test-model-connection').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $result = $('#aipa-model-test-result');
        
        // Get the API settings
        var provider = $('#api_provider').val();
        var apiKey = $('#api_key').val();
        var apiUrl = $('#api_url').val();
        var apiModel = $('#api_model_select').val() === 'custom' ? $('#api_model_custom').val() : $('#api_model_select').val();
        var formatTemplate = $('#format_template').val();
        
        if (!apiKey && provider !== 'custom') {
            $result.html('<div class="notice notice-error inline"><p>Please enter an API key first.</p></div>');
            return;
        }

        if (!apiModel) {
            $result.html('<div class="notice notice-error inline"><p>Please select a model first.</p></div>');
            return;
        }
        
        // Change button state
        $button.prop('disabled', true).text(aipa_admin_data.testing_text);
        $result.html('<div class="notice notice-info inline"><p>Testing model connection...</p></div>');
        
        // Send AJAX request to test the model connection
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_test_model_connection',
                provider: provider,
                api_key: apiKey,
                api_url: apiUrl,
                api_model: apiModel,
                format_template: formatTemplate,
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<div class="notice notice-success inline"><p>' + response.data.message + '</p></div>');
                } else {
                    $result.html('<div class="notice notice-error inline"><p>Error: ' + response.data.message + '</p></div>');
                }
            },
            error: function() {
                $result.html('<div class="notice notice-error inline"><p>Connection error. Please try again.</p></div>');
            },
            complete: function() {
                $button.prop('disabled', false).text(aipa_admin_data.test_model_button_text);
            }
        });
    });
    
    // Add notices dismiss functionality
    $('.aipa-notice-dismiss').on('click', function() {
        $(this).closest('.aipa-admin-notice').fadeOut(300, function() {
            $(this).remove();
        });
    });
    
    // Toggle settings sections based on feature enablement
    $('#enable_cart_analysis').on('change', function() {
        if ($(this).is(':checked')) {
            $('.aipa-cart-analysis-settings').fadeIn(300);
        } else {
            $('.aipa-cart-analysis-settings').fadeOut(300);
        }
    }).trigger('change');
    
    // Toggle native template settings
    $('#use_native_template').on('change', function() {
        if ($(this).is(':checked')) {
            $('.aipa-custom-template-settings').fadeOut(300);
        } else {
            $('.aipa-custom-template-settings').fadeIn(300);
        }
    }).trigger('change');
    
    // Reset CSS buttons
    $('#search_button_css_reset').on('click', function(e) {
        e.preventDefault();
        $('#search_button_css').val(aipa_admin_data.default_css.search_button);
        // Update preview
        updateFloatingButtonPreview();
    });
    
    $('#cart_analysis_css_reset').on('click', function(e) {
        e.preventDefault();
        $('#cart_analysis_css').val(aipa_admin_data.default_css.cart_analysis);
    });
    
    // Tabs functionality
    $('.aipa-tab').on('click', function() {
        var tabId = $(this).data('tab');
        var tabName = tabId.replace('aipa-', '');
        
        $('.aipa-tab').removeClass('active');
        $(this).addClass('active');
        
        $('.aipa-tab-content').removeClass('active').hide();
        $('#' + tabId).addClass('active').show();
        
        var newUrl = window.location.href.split('?')[0] + '?page=ai-product-assistant&tab=' + tabName;
        history.pushState({}, '', newUrl);
        
        if (typeof(Storage) !== "undefined") {
            localStorage.setItem('aipa_active_tab', tabId);
        }
        
        if (tabName === 'product-fields' && typeof initCustomFieldsManagement === 'function') {
            initCustomFieldsManagement();
        }
    });

    $(document).on('click', '.aipa-subtab', function() {
        var subtabId = $(this).data('subtab');
        
        $('.aipa-subtab').removeClass('active');
        $(this).addClass('active');
        
        $('.aipa-subtab-content').removeClass('active').hide();
        $('#' + subtabId + '-subtab').addClass('active').show();
        
        const urlParams = new URLSearchParams(window.location.search);
        urlParams.set('subtab', subtabId);
        const newUrl = window.location.pathname + '?' + urlParams.toString();
        history.pushState({}, '', newUrl);
    });

    $(document).ready(function() {
        const urlParams = new URLSearchParams(window.location.search);
        const subtab = urlParams.get('subtab');
        if (subtab) {
            $('.aipa-subtab[data-subtab="' + subtab + '"]').click();
        }
    });

    // Restore active tab from local storage or URL parameter
    var urlParams = new URLSearchParams(window.location.search);
    var tabParam = urlParams.get('tab');
    
    if (tabParam) {
        $('.aipa-tab[data-tab="aipa-' + tabParam + '"]').trigger('click');
    } else if (typeof(Storage) !== "undefined") {
        var activeTab = localStorage.getItem('aipa_active_tab');
        
        if (activeTab) {
            $('.aipa-tab[data-tab="' + activeTab + '"]').trigger('click');
        } else {
            // Default to first tab
            $('.aipa-tab:first').trigger('click');
        }
    } else {
        // Fallback if local storage is not available
        $('.aipa-tab:first').trigger('click');
    }
    
    // Shortcode copy functionality
    $('.aipa-copy-shortcode').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var shortcode = $button.data('shortcode');
        
        // Create a temporary textarea to copy the shortcode
        var $temp = $('<textarea>');
        $('body').append($temp);
        $temp.val(shortcode).select();
        document.execCommand('copy');
        $temp.remove();
        
        // Show copied message
        var originalText = $button.text();
        $button.text('Copied!');
        
        setTimeout(function() {
            $button.text(originalText);
        }, 2000);
    });
    
    // Statistics date range filter
    $('#aipa-stats-filter').on('change', function() {
        var timeRange = $(this).val();
        window.location.href = 'admin.php?page=ai-product-assistant&tab=statistics&time_range=' + timeRange;
    });
    
    // Export statistics button
    $('#aipa-export-statistics').on('click', function(e) {
        e.preventDefault();
        
        var timeRange = $('#aipa-stats-filter').val() || 'all';
        window.location.href = 'admin.php?page=ai-product-assistant&action=export_statistics&time_range=' + timeRange + '&nonce=' + aipa_admin_data.nonce;
    });
    
    // Settings form validation
    $('#aipa-settings-form').on('submit', function(e) {
        
        // Check which tab is active to determine what validation is needed
        var activeTab = $('.aipa-tab.active').data('tab');
        
        // Only validate API key on the API settings tab
        if (activeTab === 'aipa-advanced' || activeTab === 'aipa-general') {
            var provider = $('#api_provider').val();
            var apiKey = $('#api_key').val();
            var savedApiKey = aipa_admin_data.settings && aipa_admin_data.settings.api_key ? aipa_admin_data.settings.api_key : '';

            if (!apiKey && !savedApiKey && provider !== 'custom') {
                e.preventDefault();
                alert('Please enter an API key before saving settings.');
                $('#api_key').focus();
                return false;
            }
        }
        
        // Validate model if selected
        if (apiModelSelected) {
            var apiModel = $('#api_model_select').val();
            if (apiModel === 'custom') {
                var customModel = $('#api_model_custom').val();
                if (!customModel) {
                    e.preventDefault();
                    alert('Please enter a custom model name.');
                    $('#api_model_custom').focus();
                    return false;
                }
            } else if (!apiModel) {
                e.preventDefault();
                alert('Please select a model before saving settings.');
                $('#api_model_select').focus();
                return false;
            }
        }
        
        return true;
    });
    
    // Initialize provider change to set up initial state
    $('#api_provider').trigger('change');


    // Long description analysis button
    $('#analyze_description_length').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $resultContainer = $('#description_length_analysis_result');
        var $spinner = $resultContainer.find('.aipa-loading-spinner');
        var $results = $resultContainer.find('.aipa-analysis-results');
        var limit = $('#description_length_limit').val();
        
        // Show loading effect
        $button.prop('disabled', true);
        $resultContainer.show();
        $spinner.show();
        $results.empty();
        
        // Send AJAX request
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_analyze_description_length',
                limit: limit,
                field_type: 'description',
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success) {
                    displayDescriptionAnalysisResults($results, response.data);
                } else {
                    $results.html('<div class="notice notice-error"><p>' + response.data.message + '</p></div>');
                }
            },
            error: function() {
                $results.html('<div class="notice notice-error"><p>' + aipa_admin_data.analysis_error_message + '</p></div>');
            },
            complete: function() {
                $button.prop('disabled', false);
                $spinner.hide();
            }
        });
    });

    // Short description analysis button
    $('#analyze_short_description_length').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $resultContainer = $('#short_description_length_analysis_result');
        var $spinner = $resultContainer.find('.aipa-loading-spinner');
        var $results = $resultContainer.find('.aipa-analysis-results');
        var limit = $('#short_description_length_limit').val();
        
        // Show loading effect
        $button.prop('disabled', true);
        $resultContainer.show();
        $spinner.show();
        $results.empty();
        
        // Send AJAX request
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_analyze_short_description_length',
                limit: limit,
                field_type: 'short_description',
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success) {
                    displayDescriptionAnalysisResults($results, response.data);
                } else {
                    $results.html('<div class="notice notice-error"><p>' + response.data.message + '</p></div>');
                }
            },
            error: function() {
                $results.html('<div class="notice notice-error"><p>' + aipa_admin_data.analysis_error_message + '</p></div>');
            },
            complete: function() {
                $button.prop('disabled', false);
                $spinner.hide();
            }
        });
    });

    // Display analysis results
    function displayDescriptionAnalysisResults($container, data) {
        var fieldName = data.field_type === 'description' ? aipa_admin_data.long_description_text : aipa_admin_data.short_description_text;
        
        var html = '<div class="aipa-analysis-report">';
        
        // Summary information
        html += '<div class="aipa-analysis-summary" style="margin-bottom: 20px; padding: 15px; background-color: #f8f8f8; border-radius: 5px;">';
        html += '<h4>' + aipa_admin_data.analysis_summary_text.replace('%s', fieldName) + '</h4>';
        html += '<table class="widefat" style="border: none; background: transparent;">';
        html += '<tr><td><strong>' + aipa_admin_data.total_products_text + ':</strong></td><td>' + data.total_count + '</td></tr>';
        html += '<tr><td><strong>' + aipa_admin_data.empty_fields_text + ':</strong></td><td>' + data.empty_count + ' (' + data.empty_percent + '%)</td></tr>';
        html += '<tr><td><strong>' + aipa_admin_data.under_limit_text.replace('%s', data.current_limit) + ':</strong></td><td>' + data.under_limit_count + ' (' + data.under_limit_percent + '%)</td></tr>';
        html += '<tr><td><strong>' + aipa_admin_data.over_limit_text.replace('%s', data.current_limit) + ':</strong></td><td>' + data.over_limit_count + ' (' + data.over_limit_percent + '%)</td></tr>';
        html += '<tr><td><strong>' + aipa_admin_data.average_length_text + ':</strong></td><td>' + data.avg_length + ' ' + aipa_admin_data.characters_text + '</td></tr>';
        html += '<tr><td><strong>' + aipa_admin_data.max_length_text + ':</strong></td><td>' + data.max_length + ' ' + aipa_admin_data.characters_text + '</td></tr>';
        html += '<tr><td><strong>' + aipa_admin_data.min_length_text + ':</strong></td><td>' + data.min_length + ' ' + aipa_admin_data.characters_text + '</td></tr>';
        html += '</table>';
        html += '</div>';
        
        // Length distribution
        html += '<div class="aipa-length-distribution">';
        html += '<h4>' + aipa_admin_data.length_distribution_text + '</h4>';
        html += '<table class="widefat">';
        html += '<thead><tr><th>' + aipa_admin_data.character_range_text + '</th><th>' + aipa_admin_data.product_count_text + '</th><th>' + aipa_admin_data.percentage_text + '</th></tr></thead>';
        html += '<tbody>';
        
        // Add row for each range
        for (var range in data.length_distribution) {
            var count = data.length_distribution[range];
            var percent = (count / data.total_count * 100).toFixed(1);
            
            html += '<tr>';
            html += '<td>' + range + '</td>';
            html += '<td>' + count + '</td>';
            html += '<td>' + percent + '%</td>';
            html += '</tr>';
        }
        
        html += '</tbody></table>';
        html += '</div>';
        
        // Recommendations
        html += '<div class="aipa-recommendation" style="margin-top: 20px; padding: 15px; background-color: #e8f5e9; border-left: 4px solid #4CAF50; border-radius: 3px;">';
        html += '<h4>' + aipa_admin_data.recommendation_text + '</h4>';
        
        // Provide recommendations based on analysis
        if (data.under_limit_percent >= 90) {
            html += '<p>' + aipa_admin_data.recommendation_most_under.replace('%s', data.current_limit) + '</p>';
        } else if (data.under_limit_percent >= 70) {
            html += '<p>' + aipa_admin_data.recommendation_many_under.replace('%s', data.current_limit) + '</p>';
        } else if (data.under_limit_percent <= 30) {
            html += '<p>' + aipa_admin_data.recommendation_most_over.replace('%1$s', data.current_limit).replace('%2$s', data.avg_length) + '</p>';
        } else {
            html += '<p>' + aipa_admin_data.recommendation_balanced.replace('%1$s', data.current_limit).replace('%2$s', data.avg_length) + '</p>';
        }
        
        html += '</div>';
        
        html += '</div>';
        
        $container.html(html);
    }

    // Debug functionality
    $('#aipa_debug_level').on('change', function() {
        var level = $(this).val();
        $('#debug_level_description').text(getDebugLevelDescription(level));
    });

    function getDebugLevelDescription(level) {
        switch(level) {
            case '1':
                return 'Only critical errors will be logged. Use this in production for minimal logging.';
            case '2':
                return 'Errors and warnings will be logged. Recommended for production environments.';
            case '3':
                return 'Errors, warnings, and general information will be logged. Good for staging environments.';
            case '4':
                return 'All debug information will be logged including detailed API calls. Use only for development/troubleshooting.';
            default:
                return '';
        }
    }

    // View log file functionality
    $(document).on('click', '.view-log-btn', function(e) {
        e.preventDefault();
        var filename = $(this).data('filename');
        
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_view_log_file',
                filename: filename,
                nonce: aipa_admin_data.nonce
            },
            beforeSend: function() {
                $('#log-viewer-content').html('<div class="aipa-spinner">Loading...</div>');
                $('#log-viewer').show();
            },
            success: function(response) {
                if (response.success) {
                    var html = '<div class="log-header">';
                    html += '<h3>' + filename + '</h3>';
                    html += '<div class="log-meta">';
                    html += '<span>Size: ' + response.data.size + '</span>';
                    html += '<span>Lines: ' + response.data.lines + '</span>';
                    html += '</div>';
                    html += '</div>';
                    html += '<div class="log-content">';
                    html += '<pre>' + response.data.content + '</pre>';
                    html += '</div>';
                    $('#log-viewer-content').html(html);
                } else {
                    $('#log-viewer-content').html('<div class="error">' + response.data + '</div>');
                }
            },
            error: function() {
                $('#log-viewer-content').html('<div class="error">Failed to load log file.</div>');
            }
        });
    });

    // Close log viewer
    $(document).on('click', '#close-log-viewer', function() {
        $('#log-viewer').hide();
    });

    // Delete log file functionality
    $(document).on('click', '.delete-log-btn', function(e) {
        e.preventDefault();
        var filename = $(this).data('filename');
        var $row = $(this).closest('tr');
        
        if (confirm('Are you sure you want to delete ' + filename + '?')) {
            $.ajax({
                url: aipa_admin_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'aipa_delete_log_file',
                    filename: filename,
                    nonce: aipa_admin_data.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $row.fadeOut(300, function() {
                            $(this).remove();
                            if ($('#debug-log-files tbody tr').length === 0) {
                                $('#debug-log-files tbody').html('<tr><td colspan="4">No log files found.</td></tr>');
                            }
                        });
                    } else {
                        alert('Failed to delete log file: ' + response.data);
                    }
                },
                error: function() {
                    alert('Failed to delete log file.');
                }
            });
        }
    });

    // Clear all logs functionality
    $(document).on('click', '#aipa-clear-all-logs', function() {
        if (confirm('Are you sure you want to delete all log files? This action cannot be undone.')) {
            var $button = $(this);
            $button.prop('disabled', true).text('Clearing...');
            
            $.ajax({
                url: aipa_admin_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'aipa_clear_all_logs',
                    nonce: aipa_admin_data.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $('#debug-log-files tbody').html('<tr><td colspan="4">' + (aipa_admin_data.no_log_files_text || 'No log files found.') + '</td></tr>');
                        alert(response.data);
                    } else {
                        alert('Failed to clear logs: ' + response.data);
                    }
                },
                error: function() {
                    alert('Failed to clear logs.');
                },
                complete: function() {
                    $button.prop('disabled', false).text('Clear All Logs');
                }
            });
        }
    });

    // Refresh recent logs functionality
    $(document).on('click', '#aipa-refresh-recent-logs', function() {
        var $button = $(this);
        var $container = $(this).closest('.aipa-recent-logs');
        var $textarea = $container.find('textarea');
        
        $button.prop('disabled', true).text('Refreshing...');
        
        // Get the most recent log content via AJAX
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_get_recent_logs',
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success && response.data.content) {
                    $textarea.val(response.data.content);
                    // Update the filename in the h4 if it changed
                    var $h4 = $container.find('h4');
                    if (response.data.filename) {
                        $h4.text('Last 50 lines from ' + response.data.filename);
                    }
                } else {
                    alert('No recent logs available.');
                }
            },
            error: function() {
                alert('Failed to refresh logs.');
            },
            complete: function() {
                $button.prop('disabled', false).text('Refresh');
            }
        });
    });

    // Test debug logging functionality
    $('#aipa-test-debug').on('click', function() {
        var $button = $(this);
        var $result = $('#aipa-test-debug-result');
        
        $button.prop('disabled', true).text('Testing...');
        $result.html('');
        
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_test_debug_logging',
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<span style="color: green;">✓ Debug system is working correctly!</span>');
                } else {
                    $result.html('<span style="color: red;">✗ Test failed: ' + response.data + '</span>');
                }
            },
            error: function() {
                $result.html('<span style="color: red;">✗ Request failed</span>');
            },
            complete: function() {
                $button.prop('disabled', false).text('Test Debug Logging');
            }
        });
    });
    
    // Custom Fields Management - Simple version that works
    var customFields = [];
    
    // Initialize custom fields
    function initCustomFields() {
        var $hiddenInput = $('#aipa_custom_fields');
        if ($hiddenInput.length > 0 && $hiddenInput.val()) {
            try {
                customFields = JSON.parse($hiddenInput.val());
            } catch (e) {
                customFields = [];
            }
        }
    }
    
    // Load available meta keys
    function loadAvailableMetaKeys() {
        $.ajax({
            url: aipa_admin_data.ajax_url,
            type: 'POST',
            data: {
                action: 'aipa_get_available_meta_keys',
                nonce: aipa_admin_data.nonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.meta_keys) {
                    var $select = $('#aipa-custom-field-select');
                    $select.empty();
                    $select.append('<option value="">Select a meta key</option>');
                    
                    $.each(response.data.meta_keys, function(i, metaKey) {
                        $select.append('<option value="' + metaKey + '">' + metaKey + '</option>');
                    });
                }
            }
        });
    }
    
    // Add custom field to the Product Fields list immediately
    function addCustomFieldToList(metaKey, description) {
        var fieldKey = 'custom_' + metaKey;
        var labelText = metaKey;
        if (description) {
            labelText += ' - ' + description;
        }
        
        // Create the wrapper div (matching PHP structure)
        var $wrapper = $('<div>', {
            'class': 'aipa-custom-field-wrapper'
        });
        
        // Create the label (matching PHP structure)
        var $label = $('<label>', {
            'for': 'search_fields_' + fieldKey
        });
        
        // Create the checkbox
        var $checkbox = $('<input>', {
            'type': 'checkbox',
            'id': 'search_fields_' + fieldKey,
            'name': 'aipa_settings[search_fields][' + fieldKey + ']',
            'value': '1'
        });
        
        // Create the remove button
        var $removeButton = $('<button>', {
            'type': 'button',
            'class': 'remove-custom-field-btn button-link-delete',
            'data-meta-key': metaKey,
            'text': 'Remove'
        });
        
        // Assemble the elements
        $label.append($checkbox);
        $label.append(' ' + labelText);
        $wrapper.append($label);
        $wrapper.append($removeButton);
        
        // Find the correct location - insert after the last standard field but before the description
        var $fieldset = $('#aipa-product-fields fieldset');
        var $description = $fieldset.find('p.description');
        
        // Insert the new field before the description paragraph
        if ($description.length > 0) {
            $description.before($wrapper);
        } else {
            // Fallback: append to fieldset
            $fieldset.append($wrapper);
        }
    }
    
    // Add custom field button click
    $(document).on('click', '#aipa-add-custom-field-btn', function() {
        var metaKey = $('#aipa-custom-field-select').val();
        var description = $('#aipa-custom-field-description').val();
        
        if (!metaKey) {
            alert('Please select a meta key.');
            return;
        }
        
        // Check if already exists
        var exists = customFields.some(function(field) {
            return field.meta_key === metaKey;
        });
        
        if (exists) {
            alert('This meta key has already been added.');
            return;
        }
        
        // Add to array
        customFields.push({
            meta_key: metaKey,
            description: description || ''
        });
        
        // Update hidden input
        $('#aipa_custom_fields').val(JSON.stringify(customFields));
        
        // Add the field immediately to the Product Fields list
        addCustomFieldToList(metaKey, description || '');
        
        // Clear inputs
        $('#aipa-custom-field-select').val('');
        $('#aipa-custom-field-description').val('');
    });
    
    // Handle remove button for existing custom fields
    $(document).on('click', '.remove-custom-field-btn', function(e) {
        e.preventDefault();
        var metaKey = $(this).data('meta-key');
        
        if (confirm('Are you sure you want to remove this custom field?')) {
            // Remove from array
            customFields = customFields.filter(function(field) {
                return field.meta_key !== metaKey;
            });
            
            // Update hidden input
            $('#aipa_custom_fields').val(JSON.stringify(customFields));
            
            // Remove the wrapper element from DOM
            $(this).closest('.aipa-custom-field-wrapper').remove();
        }
    });
    
    // Initialize when Product Fields tab is active
    if ($('#aipa-product-fields').length > 0) {
        initCustomFields();
        loadAvailableMetaKeys();
    }
    
    // Initialize on Product Fields tab activation
    $(document).on('click', '.aipa-tab[data-tab="aipa-product-fields"]', function() {
        setTimeout(function() {
            initCustomFields();
            loadAvailableMetaKeys();
        }, 100);
    });

    // Show/hide Maximum Batches row based on Brute Force Search checkbox
    // Free users have the checkbox disabled (always brute force), so keep it visible
    if ($('#enable_brute_force_search').length) {
        function toggleMaxBatchesRow() {
            var $checkbox = $('#enable_brute_force_search');
            var $row = $('#max_batches').closest('tr');
            if ($checkbox.is(':checked') || $checkbox.is(':disabled')) {
                $row.show();
            } else {
                $row.hide();
            }
        }
        $('#enable_brute_force_search').on('change', toggleMaxBatchesRow);
        toggleMaxBatchesRow();
    }
});