<?php
/**
 * Plugin Name:  AI Post Visualizer
 * Description:  Add featured images generated by Open AI's DALL·E API into your posts all in one place.
 * Version:      1.2.0
 * Author:       CodeAdapted
 * Author URI:   https://codeadapted.com
 * License:      GPL2 or later
 * License URI:  https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:  ai-post-visualizer
 *
 * @package     AIPostVisualizer
 * @author      CodeAdapted
 * @copyright   Copyright (c) 2026, CodeAdapted LLC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! defined( 'AIPV_PLUGIN_FILE' ) ) {
    define( 'AIPV_PLUGIN_FILE', __FILE__ );
}

require_once __DIR__ . '/classes/aipv-ai-processor.php';
require_once __DIR__ . '/classes/aipv-plugin.php';
require_once __DIR__ . '/classes/aipv-posts.php';

if ( ! class_exists( 'AIPostVisualizer' ) ) {

	class AIPostVisualizer {

		/** @var string The plugin version number. */
		var $version = '1.2.0';

		/** @var string Shortcuts. */
		var $plugin;
		var $posts;

		/**
		 * __construct
		 *
		 * A dummy constructor to ensure AIPostVisualizer is only setup once.
		 *
		 * @param   void
		 * @return  void
		 */
		function __construct() {
			// Do nothing.
		}

		/**
		 * initialize
		 *
		 * Sets up the AIPostVisualizer plugin.
		 *
		 * @param   void
		 * @return  void
		 */
		function initialize() {

			// Define constants.
			$this->define( 'AIPV', true );
			$this->define( 'AIPV_FILE', __FILE__ );
			$this->define( 'AIPV_DIRNAME', dirname( __FILE__ ) );
			$this->define( 'AIPV_PLUGIN_DIR', plugin_dir_url( __FILE__ ) );
			$this->define( 'AIPV_BASENAME', basename( dirname( __FILE__ ) ) );

			// Do all the plugin stuff.
			$this->plugin    = new AIPV_Plugin();

			// Generate posts with appropriate metadata
			$this->posts     = new AIPV_Posts();

			// Ai Image processing
			$this->ai_processor = new AIPV_AI_Processor();

		}

		/**
		 * __call
		 *
		 * Sugar function to access class properties
		 *
		 * @param   string $name The property name.
		 * @return  void
		 */
		public function __call( $name, $arguments ) {
			return $this->{$name};
		}

		/**
		 * define
		 *
		 * Defines a constant if doesnt already exist.
		 *
		 * @param   string $name The constant name.
		 * @param   mixed  $value The constant value.
		 * @return  void
		 */
		function define( $name, $value = true ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}

	}

	/*
	* aipv
	*
	* The main function responsible for returning the one true AIPostVisualizer Instance to functions everywhere.
	* Use this function like you would a global variable, except without needing to declare the global.
	*
	* @param   void
	* @return  AIPostVisualizer
	*/
	function aipv() {
		global $aipv;
		// Instantiate only once.
		if ( ! isset( $aipv ) ) {
			$aipv = new AIPostVisualizer
			();
			$aipv->initialize();
		}
		return $aipv;
	}

	// Instantiate.
	aipv();

} // class_exists check
