<?php
/**
 * Plugin Name: AI Humanizer & AI Detector – Uncertify AI
 * Plugin URI: https://uncertifyai.com/ai-humanizer-ai-detector-wordpress-plugin
 * Description: AI Humanizer & AI Detector Plugin for wordpress. Detect AI-generated content and humanize text with UncertifyAI's powerful API. Get content insights, check for AI probability, and improve your content quality.
 * Version: 1.0.0
 * Author: UncertifyAI
 * Author URI: https://uncertifyai.com
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: ai-humanizer-ai-detector-uncertify-ai
 * Requires at least: 5.6
 * Requires PHP: 7.4
 *
 * @package UncertifyAI
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants
define( 'UNCERTIFYAI_VERSION', '1.0.0' );
define( 'UNCERTIFYAI_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'UNCERTIFYAI_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'UNCERTIFYAI_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

// Include required files
require_once UNCERTIFYAI_PLUGIN_PATH . 'includes/class-uncertifyai-api.php';
require_once UNCERTIFYAI_PLUGIN_PATH . 'includes/class-uncertifyai-db.php';
require_once UNCERTIFYAI_PLUGIN_PATH . 'includes/class-uncertifyai-admin.php';
require_once UNCERTIFYAI_PLUGIN_PATH . 'includes/class-uncertifyai-frontend.php';

/**
 * Main plugin class
 */
class UncertifyAI_Content_Tools {

    /**
     * Plugin instance
     *
     * @var UncertifyAI_Content_Tools
     */
    private static $instance;

    /**
     * API handler instance
     *
     * @var UncertifyAI_API
     */
    public $api;

    /**
     * Database handler instance
     *
     * @var UncertifyAI_DB
     */
    public $db;

    /**
     * Admin handler instance
     *
     * @var UncertifyAI_Admin
     */
    public $admin;

    /**
     * Frontend handler instance
     *
     * @var UncertifyAI_Frontend
     */
    public $frontend;

    /**
     * Get plugin instance
     *
     * @return UncertifyAI_Content_Tools
     */
    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    private function __construct() {
        $this->includes();
        $this->init_hooks();
    }

    /**
     * Include required files
     */
    private function includes() {
        $this->db = new UncertifyAI_DB();
        $this->api = new UncertifyAI_API();
        $this->admin = new UncertifyAI_Admin( $this->api, $this->db );
        $this->frontend = new UncertifyAI_Frontend( $this->api, $this->db );
    }

    /**
     * Initialize WordPress hooks
     */
    private function init_hooks() {
        register_activation_hook( __FILE__, array( $this->db, 'create_tables' ) );
        // add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
    }

    // /**
    //  * Load plugin textdomain
    //  */
    // public function load_textdomain() {
    //     load_plugin_textdomain( 'uncertifyai', false, dirname( UNCERTIFYAI_PLUGIN_BASENAME ) . '/languages' );
    // }
}

// Initialize the plugin
UncertifyAI_Content_Tools::get_instance();