jQuery(document).ready(function($) {
    // Handle metabox buttons
    $('#uncertifyai-detect').on('click', function() {
        var post_id = $('#post_ID').val();
        var content = '';

        // Classic editor (textarea with #content)
        if ($('#content').length) {
            content = $('#content').val();
        } 
        // Gutenberg editor (block editor)
        else if (wp && wp.data) {
            content = wp.data.select('core/editor').getEditedPostContent();
        }
        
        if (!content) {
            alert("Error While Fetch Content from post.Look's like it's not default wordpress editor");
            return;
        }
        
        $('#uncertifyai-metabox').addClass('uncertifyai-loading');
        
        $.ajax({
            url: uncertifyai_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'uncertifyai_process',
                action_type: 'detect',
                content: content,
                post_id: post_id,
                nonce: uncertifyai_ajax.nonce
            },
            success: function(response) {
                $('#uncertifyai-metabox').removeClass('uncertifyai-loading');
                
                if (response.success) {
                    var d = response.data;
                    $('#uncertifyai-results').show().html(
                        '<h4>' + uncertifyai_ajax.results_text + '</h4>' +
                        '<p style="color:' + (d.score > 0.7 ? "red" : d.score > 0.4 ? "orange" : "green") + '">' +
                            '<strong>Score:</strong> ' + (d.score !== null ? (d.score * 100).toFixed(2) + '%' : '-') +
                        '</p>' +
                        '<p style="color:' + (d.score > 0.7 ? "red" : d.score > 0.4 ? "orange" : "green") + '">' +
                            '<strong>Confidence:</strong> ' + (d.confidence || '-') +
                        '</p>' +
                        '<p>' + uncertifyai_ajax.checked_on_text + ' ' + new Date(d.timestamp * 1000).toLocaleString() + '</p>'
                    );
                } else {
                    alert('Error: ' + response.data);
                }
            },
            error: function() {
                $('#uncertifyai-metabox').removeClass('uncertifyai-loading');
                alert(uncertifyai_ajax.error_text);
            }
        });
    });
    
    // Handle check history selection
    $('#uncertifyai-check-history').on('change', function() {
        var selected = $(this).find('option:selected');
        var ai = selected.data('ai');
        var human = selected.data('human');
        var model = selected.data('model');
        var date = selected.data('date');
        
        if (ai && human && model && date) {
            $('#uncertifyai-history-results').show().html(
                '<h4>' + uncertifyai_ajax.results_text + '</h4>' +
                '<p>' + uncertifyai_ajax.ai_probability_text + ' ' + ai + '%</p>' +
                '<p>' + uncertifyai_ajax.human_probability_text + ' ' + human + '%</p>' +
                '<p>' + uncertifyai_ajax.model_text + ' ' + model + '</p>' +
                '<p>' + uncertifyai_ajax.checked_on_text + ' ' + date + '</p>'
            );
        } else {
            $('#uncertifyai-history-results').hide();
        }
    });
    
    // Manual check on settings page
    $('#uncertifyai-detect-btn').on('click', function() {
        var content = $('#uncertifyai-manual-check').val();
        
        if (!content) {
            alert(uncertifyai_ajax.enter_content_text);
            return;
        }
        
        $(this).prop('disabled', true).text(uncertifyai_ajax.checking_text);
        
        $.ajax({
            url: uncertifyai_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'uncertifyai_process',
                action_type: 'detect',
                content: content,
                nonce: uncertifyai_ajax.nonce
            },
            success: function(response) {
                $('#uncertifyai-detect-btn').prop('disabled', false).text(uncertifyai_ajax.detect_text);
                console.log("response",response)
                if (response.success) {
                    var d = response.data;
                    $('#uncertifyai-manual-results').show().html(
                        '<h3>' + uncertifyai_ajax.results_text + '</h3>' +
                        '<p style="color:' + (d.score > 0.7 ? "red" : d.score > 0.4 ? "orange" : "green") + '">' +
                            '<strong>Score:</strong> ' + (d.score !== null ? (d.score * 100).toFixed(2) + '%' : '-') +
                        '</p>' +
                        '<p style="color:' + (d.score > 0.7 ? "red" : d.score > 0.4 ? "orange" : "green") + '">' +
                            '<strong>Confidence:</strong> ' + (d.confidence || '-') +
                        '</p>' +
                        '<p>' + uncertifyai_ajax.checked_on_text + ' ' + new Date(d.timestamp * 1000).toLocaleString() + '</p>'
                    );
                } else {
                    $('#uncertifyai-manual-results').show().html(
                        '<p class="error">' + uncertifyai_ajax.error_text + ': ' + response.data + '</p>'
                    );
                }
            },
            error: function() {
                $('#uncertifyai-detect-btn').prop('disabled', false).text(uncertifyai_ajax.detect_text);
                $('#uncertifyai-manual-results').show().html(
                    '<p class="error">' + uncertifyai_ajax.error_text + '</p>'
                );
            }
        });
    });
    
    $('#uncertifyai-humanize-btn').on('click', function() {
        var content = $('#uncertifyai-manual-check').val();
        
        if (!content) {
            alert(uncertifyai_ajax.enter_content_text);
            return;
        }
        
        $(this).prop('disabled', true).text(uncertifyai_ajax.processing_text);
        
        $.ajax({
            url: uncertifyai_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'uncertifyai_process',
                action_type: 'humanize',
                content: content,
                nonce: uncertifyai_ajax.nonce
            },
            success: function(response) {
                $('#uncertifyai-humanize-btn').prop('disabled', false).text(uncertifyai_ajax.humanize_text);
                
                if (response.success) {
                    var d = response.data;
                    $('#uncertifyai-manual-results').show().html(
                        '<h3>' + uncertifyai_ajax.humanized_content_text + '</h3>' +
                        '<div style="border: 1px solid #ddd; padding: 15px; background: #fff; margin-top: 10px;">' + 
                        d.humanized_text + 
                        '</div>' +
                        '<p>Original Length: ' + d.original_length + '</p>' +
                        '<p>Humanized Length: ' + d.humanized_length + '</p>' +
                        '<p>Changes Made: ' + d.changes_made + '</p>' +
                        '<p>' + uncertifyai_ajax.processed_on_text + ' ' + new Date(d.timestamp * 1000).toLocaleString() + '</p>'
                    );
                } else {
                    $('#uncertifyai-manual-results').show().html(
                        '<p class="error">' + uncertifyai_ajax.error_text + ': ' + response.data + '</p>'
                    );
                }
            },
            error: function() {
                $('#uncertifyai-humanize-btn').prop('disabled', false).text(uncertifyai_ajax.humanize_text);
                $('#uncertifyai-manual-results').show().html(
                    '<p class="error">' + uncertifyai_ajax.error_text + '</p>'
                );
            }
        });
    });
    
    // Refresh usage data
    $('#uncertifyai-refresh-usage').on('click', function() {
        $(this).prop('disabled', true).text(uncertifyai_ajax.refreshing_text);
        
        $.ajax({
            url: uncertifyai_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'uncertifyai_get_usage',
                nonce: uncertifyai_ajax.nonce
            },
            success: function(response) {
                $('#uncertifyai-refresh-usage').prop('disabled', false).text(uncertifyai_ajax.refresh_text);
                
                if (response.success) {
                    // Reload the page to show updated usage
                    location.reload();
                } else {
                    alert(uncertifyai_ajax.error_text + ': ' + response.data);
                }
            },
            error: function() {
                $('#uncertifyai-refresh-usage').prop('disabled', false).text(uncertifyai_ajax.refresh_text);
                alert(uncertifyai_ajax.error_text);
            }
        });
    });
});