<?php
// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Check if the user opted to delete data on uninstall
$aiflt_delete_data = get_option('aiflt_delete_data_on_uninstall', '0');

if ($aiflt_delete_data === '1') {
    global $wpdb;

    // 1. Delete Custom Tables
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}aiflt_funnel_data");
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}aiflt_behavior_data");

    // 2. Delete Plugin Options
    delete_option('aiflt_db_version');
    delete_option('aiflt_activation_time');
    delete_option('aiflt_ai_api_key');
    delete_option('aiflt_ai_model');
    delete_option('aiflt_data_retention');
    delete_option('aiflt_delete_data_on_uninstall');
    delete_option('aiflt_anonymize_ip');
    delete_option('aiflt_enable_tracking');
    delete_option('aiflt_excluded_roles');
    delete_option('aiflt_excluded_ips');
    delete_option('aiftcr_settings'); // Addon settings if any
    
    // 3. Clear Transients
    delete_transient('aiflt_welcome_redirect');
    delete_transient('aiftaa_latest_full_report');
    delete_transient('aiftap_latest_prediction');
    delete_transient('aiflt_ai_report'); // The weekly report cache
}
