<?php
if (!defined('ABSPATH')) die('Restricted Access');
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ai-flash-tune'));
}
$aiflt_page_title = __('Settings', 'ai-flash-tune');

/**
 * Gets all registered settings tabs.
 * Addons can add their own tabs via the 'aiflt_settings_tabs' filter.
 *
 * @return array
 */
function aiflt_get_settings_tabs() {
    $tabs = [
        'general' => [
            'title' => __('General Settings', 'ai-flash-tune'),
            'callback' => 'aiflt_render_general_settings_tab'
        ]
    ];
    // Allow addons to register their own settings tabs
    $tabs = apply_filters('aiflt_settings_tabs', $tabs);

    // ADD THIS NEW TAB AT THE END
    $tabs['system_info'] = [
        'title' => __('System Info', 'ai-flash-tune'),
        'callback' => 'aiflt_render_system_info_tab'
    ];
    return $tabs;
}

/**
 * Renders the content for the 'General Settings' tab.
 * This function now contains ALL general plugin settings.
 */
function aiflt_render_general_settings_tab() {
    $settings = AIFLT_Settings_Logic::get_settings();
    ?>
    <!-- API Settings Card -->
    <div class="ai-flash-tune-card ai-flash-tune-settings-card ai-flash-tune-mb-8">
        <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-6 ai-flash-tune-card-title">
            <i class="fas fa-robot ai-flash-tune-text-indigo-600 ai-flash-tune-mr-2"></i><?php echo esc_html(__('OpenAI API Settings', 'ai-flash-tune')); ?>
        </span>
        <div class="ai-flash-tune-flex ai-flash-tune-flex-col ai-flash-tune-gap-6">
            <div class="ai-flash-tune-form-field">
                <label for="aiflt_ai_api_key" class="ai-flash-tune-form-label"><?php echo esc_html(__('OpenAI API Key', 'ai-flash-tune')); ?></label>
                <input type="text" id="aiflt_ai_api_key" name="aiflt_ai_api_key" value="<?php echo esc_attr($settings['ai_api_key']); ?>" class="ai-flash-tune-input" placeholder="<?php echo esc_attr(__('Enter your OpenAI API key (e.g., sk-...)', 'ai-flash-tune')); ?>" />
                <p class="ai-flash-tune-input-description">
                    <?php 
                    echo esc_html__('You can find or create your API key on the ', 'ai-flash-tune');
                    echo wp_kses_post('<a href="https://platform.openai.com/api-keys" target="_blank" rel="noopener noreferrer" class="ai-flash-tune-text-indigo-600">' . esc_html__('OpenAI API Keys', 'ai-flash-tune') . '</a>');
                    echo esc_html__(' page in your OpenAI account.', 'ai-flash-tune');
                    ?>
                </p>
            </div>
            <div class="ai-flash-tune-form-field">
                <label for="aiflt_ai_model" class="ai-flash-tune-form-label"><?php echo esc_html(__('AI Model', 'ai-flash-tune')); ?></label>
                 <select id="aiflt_ai_model" name="aiflt_ai_model" class="ai-flash-tune-input">
                    <option value="gpt-4o-mini" <?php selected($settings['ai_model'], 'gpt-4o-mini'); ?>><?php echo esc_html(__('GPT-4o Mini (Recommended)', 'ai-flash-tune')); ?></option>
                    <option value="gpt-4o" <?php selected($settings['ai_model'], 'gpt-4o'); ?>><?php echo esc_html(__('GPT-4o (Most Powerful)', 'ai-flash-tune')); ?></option>
                </select>
                <p class="ai-flash-tune-input-description"><?php echo esc_html(__('Choose the model for generating AI insights. We recommend GPT-4o Mini for the best balance of cost and performance.', 'ai-flash-tune')); ?></p>
            </div>
        </div>
    </div>
    
    <!-- License Activation Card -->
    <!-- Tracking & Data Management Card -->
    <div class="ai-flash-tune-card ai-flash-tune-settings-card ai-flash-tune-mb-8">
        <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-6 ai-flash-tune-card-title">
            <i class="fas fa-sliders-h ai-flash-tune-text-gray-600 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Tracking & Data Management', 'ai-flash-tune')); ?>
        </span>
        <div class="ai-flash-tune-flex ai-flash-tune-flex-col ai-flash-tune-gap-6">
            <div class="ai-flash-tune-form-field">
                <label class="ai-flash-tune-form-label"><?php echo esc_html(__('Tracking Status', 'ai-flash-tune')); ?></label>
                <div class="ai-flash-tune-input-area">
                    <label class="ai-flash-tune-checkbox-control">
                        <input type="checkbox" name="aiflt_enable_tracking" value="1" <?php checked($settings['enable_tracking'], '1'); ?> />
                        <span><?php echo esc_html(__('Enable Frontend Tracking Script', 'ai-flash-tune')); ?></span>
                    </label>
                </div>
                 <p class="ai-flash-tune-input-description"><?php echo esc_html(__('Uncheck this to completely disable all frontend data collection scripts.', 'ai-flash-tune')); ?></p>
            </div>
            <div class="ai-flash-tune-form-field">
                <label class="ai-flash-tune-form-label"><?php echo esc_html(__('Exclude User Roles from Tracking', 'ai-flash-tune')); ?></label>
                <div class="ai-flash-tune-input-area ai-flash-tune-checkbox-group">
                    <?php
                    $all_roles = get_editable_roles();
                    $excluded_roles = (array) $settings['excluded_roles'];
                    foreach ($all_roles as $role_key => $role_details) {
                        echo '<label class="ai-flash-tune-checkbox-label"><input type="checkbox" name="aiflt_excluded_roles[]" value="' . esc_attr($role_key) . '" ' . checked(in_array($role_key, $excluded_roles, true), true, false) . '> ' . esc_html($role_details['name']) . '</label>';
                    }
                    ?>
                </div>
                <p class="ai-flash-tune-input-description"><?php echo esc_html(__('It is highly recommended to exclude Administrator and Shop Manager roles to ensure data accuracy.', 'ai-flash-tune')); ?></p>
            </div>
            <div class="ai-flash-tune-form-field">
                <label for="aiflt_excluded_ips" class="ai-flash-tune-form-label"><?php echo esc_html(__('Exclude IP Addresses from Tracking', 'ai-flash-tune')); ?></label>
                <textarea id="aiflt_excluded_ips" name="aiflt_excluded_ips" rows="4" class="ai-flash-tune-input"><?php echo esc_textarea($settings['excluded_ips']); ?></textarea>
                <p class="ai-flash-tune-input-description"><?php echo esc_html(__('Enter one IP address per line. Useful for excluding office or developer IPs.', 'ai-flash-tune')); ?></p>
            </div>
            <div class="ai-flash-tune-form-field">
                <label class="ai-flash-tune-form-label"><?php echo esc_html(__('User Privacy', 'ai-flash-tune')); ?></label>
                <div class="ai-flash-tune-input-area">
                    <label class="ai-flash-tune-checkbox-control">
                        <input type="checkbox" name="aiflt_anonymize_ip" value="1" <?php checked($settings['anonymize_ip'], '1'); ?> />
                        <span><?php echo esc_html(__('Anonymize IP Addresses', 'ai-flash-tune')); ?></span>
                    </label>
                </div>
                <p class="ai-flash-tune-input-description"><?php echo esc_html(__('For GDPR compliance, enable this to remove the last part of user IP addresses before storage.', 'ai-flash-tune')); ?></p>
            </div>
            <div class="ai-flash-tune-form-field">
                <label for="data_retention" class="ai-flash-tune-form-label"><?php echo esc_html(__('Data Retention Period', 'ai-flash-tune')); ?></label>
                <select id="data_retention" name="aiflt_data_retention" class="ai-flash-tune-input">
                    <option value="30" <?php selected($settings['data_retention'], '30'); ?>><?php echo esc_html(__('30 Days', 'ai-flash-tune')); ?></option>
                    <option value="90" <?php selected($settings['data_retention'], '90'); ?>><?php echo esc_html(__('90 Days', 'ai-flash-tune')); ?></option>
                    <option value="365" <?php selected($settings['data_retention'], '365'); ?>><?php echo esc_html(__('1 Year', 'ai-flash-tune')); ?></option>
                    <option value="0" <?php selected($settings['data_retention'], '0'); ?>><?php echo esc_html(__('Forever', 'ai-flash-tune')); ?></option>
                </select>
                <p class="ai-flash-tune-input-description"><?php echo esc_html(__('How long to keep tracking data. Shorter periods can help keep your database small.', 'ai-flash-tune')); ?></p>
            </div>
            <div class="ai-flash-tune-form-field">
                <label class="ai-flash-tune-form-label"><?php echo esc_html(__('Plugin Data', 'ai-flash-tune')); ?></label>
                <div class="ai-flash-tune-input-area">
                    <label class="ai-flash-tune-checkbox-control">
                        <input type="checkbox" name="aiflt_delete_data_on_uninstall" value="1" <?php checked($settings['delete_data_on_uninstall'], '1'); ?> />
                        <span><?php echo esc_html(__('Delete All Data on Uninstall', 'ai-flash-tune')); ?></span>
                    </label>
                </div>
                 <p class="ai-flash-tune-input-description"><strong class="ai-flash-tune-text-red-600"><?php echo esc_html(__('Warning:', 'ai-flash-tune')); ?></strong> <?php echo esc_html(__('If checked, all collected data will be permanently deleted when you uninstall this plugin.', 'ai-flash-tune')); ?></p>
            </div>
        </div>
    </div>
    <?php
}

/**
 * Renders the content for the 'System Info' tab.
 */
function aiflt_render_system_info_tab() {
    global $wpdb;
    ?>
    <div class="ai-flash-tune-card ai-flash-tune-settings-card">
        <p class="ai-flash-tune-text-gray-600 ai-flash-tune-mb-6"><?php echo esc_html__('This information is helpful for debugging and support purposes.', 'ai-flash-tune'); ?></p>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row"><?php echo esc_html__('Plugin Version', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html(AIFLT_VERSION); ?></td>
                </tr>
                <tr>
                    <th scope="row"><?php echo esc_html__('WordPress Version', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html(get_bloginfo('version')); ?></td>
                </tr>
                <tr>
                    <th scope="row"><?php echo esc_html__('WooCommerce Version', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html(defined('WC_VERSION') ? WC_VERSION : 'Not Active'); ?></td>
                </tr>
                 <tr>
                    <th scope="row"><?php echo esc_html__('PHP Version', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html(phpversion()); ?></td>
                </tr>
                <tr>
                    <th scope="row"><?php echo esc_html__('Database Version', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html($wpdb->db_version()); ?></td>
                </tr>
                <tr>
                    <th scope="row"><?php echo esc_html__('Daily Cleanup Cron', 'ai-flash-tune'); ?></th>
                    <td>
                        <?php
                        $timestamp = wp_next_scheduled('aiflt_daily_cleanup_event');
                        if ($timestamp) {
                            echo esc_html(wp_date(get_option('date_format') . ' ' . get_option('time_format'), $timestamp));
                        } else {
                            echo '<span class="ai-flash-tune-text-red-500">' . esc_html__('Not Scheduled!', 'ai-flash-tune') . '</span>';
                        }
                        ?>
                    </td>
                </tr>
                 <tr>
                    <th scope="row"><?php echo esc_html__('Hourly Alert Cron', 'ai-flash-tune'); ?></th>
                    <td>
                        <?php
                        $timestamp = wp_next_scheduled('aiflt_hourly_opportunity_check');
                        if ($timestamp) {
                            echo esc_html(wp_date(get_option('date_format') . ' ' . get_option('time_format'), $timestamp));
                        } else {
                            echo '<span class="ai-flash-tune-text-red-500">' . esc_html__('Not Scheduled!', 'ai-flash-tune') . '</span>';
                        }
                        ?>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php echo esc_html__('Funnel Data Table Rows', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html(number_format_i18n((int) $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}aiflt_funnel_data"))); ?></td>
                </tr>
                <tr>
                    <th scope="row"><?php echo esc_html__('Behavior Data Table Rows', 'ai-flash-tune'); ?></th>
                    <td><?php echo esc_html(number_format_i18n((int) $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->prefix}aiflt_behavior_data"))); ?></td>
                </tr>
            </tbody>
        </table>
        <div class="ai-flash-tune-mt-6">
             <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=aiflt_settings&tab=system_info&trigger_cron=cleanup'), 'aiflt_trigger_cron')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-gray">
                <?php echo esc_html__('Manually Run Cleanup Cron', 'ai-flash-tune'); ?>
            </a>
        </div>
    </div>
    <?php
}


$tabs = aiflt_get_settings_tabs();
$aiflt_current_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'general';
?>
<div class="ai-flash-tune-admin-wrapper">
    <?php include_once('ai-flash-tune-admin-sidebar.php'); ?>
    <div class="ai-flash-tune-main-content">
        <div class="ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-flex-center ai-flash-tune-mb-6">
            <span class="ai-flash-tune-main-title"><?php echo esc_html($aiflt_page_title); ?></span>
        </div>

        <div class="ai-flash-tune-card ai-flash-tune-mb-8">
            <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-6 ai-flash-tune-card-title">
                <i class="fas fa-info-circle ai-flash-tune-text-blue-500 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Data & Privacy Notice', 'ai-flash-tune')); ?>
            </span>
            <p class="ai-flash-tune-text-gray-600 ai-flash-tune-mb-4"><?php echo esc_html(__('For transparency, here is a summary of the tracking data this plugin collects and stores in your website\'s database.', 'ai-flash-tune')); ?></p>
            <div class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 md:ai-flash-tune-grid-cols-2">
                <div>
                    <h4 class="ai-flash-tune-font-semibold ai-flash-tune-text-gray-700"><?php echo esc_html__('For All Visitors:', 'ai-flash-tune'); ?></h4>
                    <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-mt-2 ai-flash-tune-space-y-1">
                        <li><?php echo esc_html__('Anonymous Visit ID & IP Address', 'ai-flash-tune'); ?></li>
                        <li><?php echo esc_html__('Device Type (Desktop/Mobile)', 'ai-flash-tune'); ?></li>
                        <li><?php echo esc_html__('Pages Visited & Behavioral Events', 'ai-flash-tune'); ?></li>
                        <li><?php echo esc_html__('Cart Contents and Total Value', 'ai-flash-tune'); ?></li>
                    </ul>
                </div>
                <div>
                    <h4 class="ai-flash-tune-font-semibold ai-flash-tune-text-gray-700"><?php echo esc_html__('For Logged-In Users:', 'ai-flash-tune'); ?></h4>
                     <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-mt-2">
                        <li><?php echo esc_html__('WordPress User ID', 'ai-flash-tune'); ?></li>
                    </ul>
                    <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-mt-4">
                        <?php 
                        echo esc_html__('You can manage this data via the ', 'ai-flash-tune');
                        echo wp_kses_post('<a href="' . esc_url(admin_url('admin.php?page=privacy-tools')) . '" class="ai-flash-tune-text-indigo-600">' . esc_html__('Privacy Tools', 'ai-flash-tune') . '</a>');
                        echo esc_html__(' page.', 'ai-flash-tune');
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Tab Navigation -->
        <h2 class="screen-reader-text"><?php esc_html_e( 'Settings Tabs', 'ai-flash-tune' ); ?></h2>
        <nav class="ai-flash-tune-nav-tab-wrapper ai-flash-tune-mb-0">
            <?php foreach ($tabs as $aiflt_slug => $tab) : ?>
                <a href="?page=aiflt_settings&tab=<?php echo esc_attr($aiflt_slug); ?>" class="ai-flash-tune-nav-tab <?php echo ($aiflt_current_tab === $aiflt_slug) ? 'ai-flash-tune-nav-tab-active' : ''; ?>">
                    <?php echo esc_html($tab['title']); ?>
                </a>
            <?php endforeach; ?>
        </nav>

        <?php 
        // Check for WooCommerce dependency at the top of the view file.
        if (!aiflt_is_woocommerce_active()) {
            $aiflt_install_url = admin_url('plugin-install.php?s=woocommerce&tab=search&type=term');
            $aiflt_wc_status = aiflt_get_woocommerce_status(); // Call the helper function
            ?>
            <div class="ai-flash-tune-wc-required-notice">
                <i class="fas fa-plug ai-flash-tune-notice-icon"></i>
                <p class="ai-flash-tune-notice-title"><?php echo esc_html__('WooCommerce is Required', 'ai-flash-tune'); ?></p>
                <p class="ai-flash-tune-notice-text"><?php echo esc_html__('Most AI Flash Tune settings rely on WooCommerce being installed and active.', 'ai-flash-tune'); ?></p>
                <a href="<?php echo esc_url($aiflt_wc_status['action_url']); ?>" class="ai-flash-tune-notice-button">
                    <?php echo esc_html($aiflt_wc_status['button_text']); ?>
                </a>
            </div>
            <?php
        } else { ?>
            <!-- Form and Tab Content -->
            <?php if ($aiflt_current_tab !== 'system_info') : // Only show form on actual settings tabs ?>
            <form id="ai-flash-tune-settings-form" method="post" action="options.php">
            <?php endif; ?>
                <div class="ai-flash-tune-card" style="border-top-left-radius: 0;">
                    <?php
                    if ($aiflt_current_tab === 'general') {
                        settings_fields('aiflt_settings_group');
                    } else {
                        settings_fields('aiflt_settings_group_' . $aiflt_current_tab);
                    }

                    if (isset($tabs[$aiflt_current_tab]) && function_exists($tabs[$aiflt_current_tab]['callback'])) {
                        call_user_func($tabs[$aiflt_current_tab]['callback']);
                    }
                    ?>
                    <?php if ($aiflt_current_tab !== 'system_info') : ?>
                        <div class="ai-flash-tune-flex ai-flash-tune-items-center ai-flash-tune-mt-6">
                            <button type="submit" id="ai-flash-tune-save-settings-button" class="ai-flash-tune-btn ai-flash-tune-btn-blue">
                                <?php echo esc_html(__('Save Settings', 'ai-flash-tune')); ?>
                            </button>
                            <span id="ai-flash-tune-save-status" class="ai-flash-tune-ml-4" style="display: none;"></span>
                        </div>
                    <?php endif; ?>
                </div>
            <?php if ($aiflt_current_tab !== 'system_info') : ?>
            </form>
            <?php else: // If it IS the system info tab, call the function directly without a form
                if (isset($tabs[$aiflt_current_tab]) && function_exists($tabs[$aiflt_current_tab]['callback'])) {
                    // call_user_func($tabs[$aiflt_current_tab]['callback']);
                }
            endif; ?>
            <?php
            // END: End of the 'else' block
        }
        ?>
    </div>
</div>


