<?php
if (!defined('ABSPATH')) die('Restricted Access');

// Check if the current user has the 'manage_options' capability. This is a critical security check.
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ai-flash-tune'));
}

$aiflt_page_title   = __('Product Detail Analysis', 'ai-flash-tune');
$aiflt_product_name = __('Product Detail', 'ai-flash-tune');

// Check for WooCommerce dependency and retrieve product data.
if (aiflt_is_woocommerce_active()) {
    $aiflt_product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;
    if ($aiflt_product_id === 0) {
        // Redirect to the main products page if no ID is provided
        wp_safe_redirect(admin_url('admin.php?page=products'));
        exit;
    }

    // --- NEW LOGIC START: Determine the effective default start date ---
    $aiflt_plugin_install_time = get_option('aiflt_activation_time', time());
    $aiflt_default_start_timestamp = strtotime('-30 days');
    $aiflt_min_valid_start_timestamp = $aiflt_plugin_install_time;

    // Determine the earliest valid default date by taking the LATER of the two timestamps.
    $aiflt_effective_start_timestamp = max($aiflt_default_start_timestamp, $aiflt_min_valid_start_timestamp);
    $aiflt_effective_default_start_date = gmdate('Y-m-d', $aiflt_effective_start_timestamp);
    // --- NEW LOGIC END ---

    // --- REVISED: Add check for the Copy Enhancer addon ---
    $aiflt_is_product_doctor_active = is_plugin_active('ai-flash-tune-product-doctor/ai-flash-tune-product-doctor.php');
    $aiflt_is_copy_enhancer_active = is_plugin_active('ai-flash-tune-copy-enhancer/ai-flash-tune-copy-enhancer.php');

    // CRITICAL FIX: Use the calculated effective default start date.
    $aiflt_start_date = isset($_GET['start_date']) ? sanitize_text_field(wp_unslash($_GET['start_date'])) : $aiflt_effective_default_start_date;
    
    $aiflt_end_date = isset($_GET['end_date']) ? sanitize_text_field($_GET['end_date']) : gmdate('Y-m-d');
    $aiflt_device_type = isset($_GET['device_type']) ? sanitize_text_field($_GET['device_type']) : 'all';

    $aiflt_product_details = AIFLT_Products_Logic::get_product_details($aiflt_product_id, $aiflt_start_date, $aiflt_end_date, $aiflt_device_type);
    $aiflt_product_name = $aiflt_product_details['name'];
    $aiflt_ai_suggestion = AIFLT_Products_Logic::get_ai_copy_suggestion($aiflt_product_id);
    // ---> NEW: Call the visual noise analysis function
    $aiflt_visual_noise_data = AIFLT_Products_Logic::get_visual_noise_analysis($aiflt_product_id);
    $aiflt_device_breakdown = AIFLT_Products_Logic::get_device_breakdown($aiflt_start_date, $aiflt_end_date);
    
} else {
    // Default empty values if WC is not active.
    $aiflt_product_details = [];
    $aiflt_is_product_doctor_active = false;
    $aiflt_is_copy_enhancer_active = false;
}
?>
<div class="ai-flash-tune-admin-wrapper">
    <?php include_once('ai-flash-tune-admin-sidebar.php'); ?>
    <div class="ai-flash-tune-main-content ai-flash-tune-product-detail-page">
        <div class="ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-flex-center ai-flash-tune-mb-8 ai-flash-tune-page-header">
            <span class="ai-flash-tune-main-title"><?php echo esc_html($aiflt_product_name); ?> <?php echo esc_html(__('Analysis', 'ai-flash-tune')); ?></span>
            <?php
            // Check for WooCommerce dependency at the top of the view file.
            if (aiflt_is_woocommerce_active()) { ?>
                <div class="ai-flash-tune-header-actions-wrapper">
                    <div class="ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-space-x-4 ai-flash-tune-header-actions">
                        <span class="ai-flash-tune-text-gray-600 ai-flash-tune-text-sm ai-flash-tune-last-updated">
                            <?php echo esc_html(gmdate('M d, Y', strtotime($aiflt_start_date))) . ' - ' . esc_html(gmdate('M d, Y', strtotime($aiflt_end_date))); ?>
                        </span>
                        <a class="ai-flash-tune-bg-blue-500 hover:ai-flash-tune-bg-blue-600 ai-flash-tune-text-white ai-flash-tune-font-semibold ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-rounded-lg ai-flash-tune-shadow-md ai-flash-tune-date-range-toggle" href="#">
                            <i class="fas fa-filter ai-flash-tune-mr-2"></i> <?php echo esc_html(__('Filters', 'ai-flash-tune')); ?>
                        </a>
                    </div>

                    <div id="ai-flash-tune-date-range-form-wrapper-detail" class="ai-flash-tune-card ai-flash-tune-date-range-form hidden">
                        <form method="GET" class="ai-flash-tune-flex">
                            <input type="hidden" name="page" value="product-detail" />
                            <input type="hidden" name="product_id" value="<?php echo esc_attr($aiflt_product_id); ?>" />
                            <div class="ai-flash-tune-date-range-field">
                                <label for="aiflt-detail-start-date"><?php echo esc_html__('Start Date', 'ai-flash-tune'); ?></label>
                                <input type="text" id="aiflt-detail-start-date" name="start_date" value="<?php echo esc_attr($aiflt_start_date); ?>" />
                            </div>
                            <div class="ai-flash-tune-date-range-field">
                                <label for="aiflt-detail-end-date"><?php echo esc_html__('End Date', 'ai-flash-tune'); ?></label>
                                <input type="text" id="aiflt-detail-end-date" name="end_date" value="<?php echo esc_attr($aiflt_end_date); ?>" />
                            </div>
                            <div class="ai-flash-tune-date-range-field">
                                <label for="device_type"><?php echo esc_html(__('Device Type', 'ai-flash-tune')); ?></label>
                                <select name="device_type" id="device_type">
                                    <option value="all" <?php selected($aiflt_device_type, 'all'); ?>><?php echo esc_html(__('All Devices', 'ai-flash-tune')); ?></option>
                                    <option value="desktop" <?php selected($aiflt_device_type, 'desktop'); ?>><?php echo esc_html(__('Desktop', 'ai-flash-tune')); ?></option>
                                    <option value="mobile" <?php selected($aiflt_device_type, 'mobile'); ?>><?php echo esc_html(__('Mobile', 'ai-flash-tune')); ?></option>
                                </select>
                            </div>
                            <input type="submit" value="<?php echo esc_attr(__('Filter', 'ai-flash-tune')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue" />
                        </form>
                    </div>
                </div>
                <?php
            } ?>
        </div>
        <?php
        // Check for WooCommerce dependency at the top of the view file.
        if (!aiflt_is_woocommerce_active()) {
            $aiflt_install_url = admin_url('plugin-install.php?s=woocommerce&tab=search&type=term');
            $aiflt_wc_status = aiflt_get_woocommerce_status(); // Call the helper function
            ?>
            <div class="ai-flash-tune-wc-required-notice">
                <i class="fas fa-plug ai-flash-tune-notice-icon"></i>
                <p class="ai-flash-tune-notice-title"><?php echo esc_html__('WooCommerce is Required', 'ai-flash-tune'); ?></p>
                <p class="ai-flash-tune-notice-text"><?php echo esc_html__('This page requires WooCommerce to be installed and active to display detailed product analysis. Please install or activate WooCommerce to continue.', 'ai-flash-tune'); ?></p>
                <a href="<?php echo esc_url($aiflt_wc_status['action_url']); ?>" class="ai-flash-tune-notice-button">
                    <?php echo esc_html($aiflt_wc_status['button_text']); ?>
                </a>
            </div>
            <?php
            return; // Stop rendering the rest of the page.
        } ?>
        <!-- Product Overview Metrics -->
        <div class="ai-flash-tune-mb-8">
            <div class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-md-2 ai-flash-tune-grid-cols-lg-4 ai-flash-tune-key-insights-grid">
                <div class="ai-flash-tune-card ai-flash-tune-metric-card ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-items-center">
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-metric-label"><?php echo esc_html(__('Product Views', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-metric-value"><?php echo esc_html($aiflt_product_details['views']); ?></p>
                    </div>
                    <i class="fas fa-eye ai-flash-tune-text-indigo-500 ai-flash-tune-text-4xl"></i>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-metric-card ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-items-center">
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-metric-label"><?php echo esc_html(__('Sales', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-metric-value"><?php echo esc_html($aiflt_product_details['sales']); ?></p>
                    </div>
                    <i class="fas fa-dollar-sign ai-flash-tune-text-green-500 ai-flash-tune-text-4xl"></i>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-metric-card ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-items-center">
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-metric-label"><?php echo esc_html(__('Conversion Rate', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-metric-value"><?php echo esc_html($aiflt_product_details['conversion_rate']); ?></p>
                    </div>
                    <i class="fas fa-percent ai-flash-tune-text-blue-500 ai-flash-tune-text-4xl"></i>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-metric-card ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-items-center">
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-metric-label"><?php echo esc_html(__('Average Page Speed', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-metric-value"><?php echo esc_html($aiflt_product_details['avg_page_speed']); ?></p>
                    </div>
                    <i class="fas fa-tachometer-alt ai-flash-tune-text-yellow-500 ai-flash-tune-text-4xl"></i>
                </div>
            </div>
        </div>

        <!-- New Section for Performance Comparison -->
        <div class="ai-flash-tune-card ai-flash-tune-mb-8 ai-flash-tune-performance-comparison-section">
            <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title"><?php echo esc_html(__('Performance Comparison', 'ai-flash-tune')); ?></span>
            <div class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-md-2">
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-metric-card ai-flash-tune-items-center ai-flash-tune-items-center ai-flash-tune-space-x-4 ai-flash-tune-comparison-card">
                    <i class="fas fa-chart-line ai-flash-tune-text-blue-500 ai-flash-tune-text-4xl"></i>
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-comparison-label"><?php echo esc_html(__('This product\'s Conversion Rate', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-lg ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-comparison-value"><?php echo esc_html($aiflt_product_details['conversion_rate']); ?></p>
                    </div>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-metric-card ai-flash-tune-items-center ai-flash-tune-space-x-4 ai-flash-tune-comparison-card">
                    <i class="fas fa-store ai-flash-tune-text-gray-500 ai-flash-tune-text-4xl"></i>
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-comparison-label"><?php echo esc_html(__('Store Average Conversion Rate', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-lg ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-comparison-value"><?php echo esc_html($aiflt_product_details['store_conversion_rate']); ?>%</p>
                    </div>
                </div>
            </div>
        </div>
        <?php if ($aiflt_is_product_doctor_active): ?>
            <div class="ai-flash-tune-card ai-flash-tune-mb-8">
                <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                    <i class="fas fa-stethoscope ai-flash-tune-text-blue-500 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Run AI Diagnosis', 'ai-flash-tune')); ?>
                </span>
                <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4"><?php echo esc_html(__('Get a deep-dive AI analysis of this product\'s performance and user behavior to uncover specific reasons for its conversion rate.', 'ai-flash-tune')); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=products&diagnose=' . $aiflt_product_id . '#product-' . $aiflt_product_id)); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue">
                    <?php echo esc_html__('Get AI Diagnosis on Products Page', 'ai-flash-tune'); ?>
                </a>
            </div>
        <?php endif; ?>

        <!-- --- NEW: AI Copy Enhancer Card --- -->
        <?php if ($aiflt_is_copy_enhancer_active): ?>
            <div class="ai-flash-tune-card ai-flash-tune-mb-8">
                <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                    <i class="fas fa-pencil-alt ai-flash-tune-text-green-500 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Enhance Product Copy', 'ai-flash-tune')); ?>
                </span>
                <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4"><?php echo esc_html(__('Use the AI Copy Enhancer to get suggestions for rewriting this product\'s title and description to be more persuasive and conversion-focused.', 'ai-flash-tune')); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=products&enhance=' . $aiflt_product_id . '#product-' . $aiflt_product_id)); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-green">
                    <?php echo esc_html__('Enhance Copy on Products Page', 'ai-flash-tune'); ?>
                </a>
            </div>
        <?php endif; ?>
        
        <div class="ai-flash-tune-card ai-flash-tune-mb-8">
            <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                <i class="fas fa-tasks ai-flash-tune-text-orange-500 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Visual Noise Checker (Lite)', 'ai-flash-tune')); ?>
            </span>
            <?php // --- START: MODIFIED CODE --- ?>
            <?php if (is_array($aiflt_visual_noise_data) && isset($aiflt_visual_noise_data['status'])): ?>
                <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-section-description"><?php echo esc_html($aiflt_visual_noise_data['description']); ?></p>
                <div class="ai-flash-tune-flex <?php echo esc_attr($aiflt_visual_noise_data['css_class']); ?> ai-flash-tune-font-semibold ai-flash-tune-text-lg ai-flash-tune-detector-status">
                    <i class="<?php echo esc_attr($aiflt_visual_noise_data['icon_class']); ?> ai-flash-tune-mr-2"></i>
                    <span class="ai-flash-tune-detector-text"><?php echo esc_html($aiflt_visual_noise_data['message']); ?></span>
                </div>
                <?php if (!empty($aiflt_visual_noise_data['issues'])): ?>
                    <div class="ai-flash-tune-mt-4 ai-flash-tune-bg-gray-100 ai-flash-tune-p-4 ai-flash-tune-rounded-lg">
                        <p class="ai-flash-tune-font-semibold ai-flash-tune-text-gray-800" style="margin-top: 0;"><?php echo esc_html(__('Analysis Details:', 'ai-flash-tune')); ?></p>
                        <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-text-sm ai-flash-tune-text-gray-700">
                            <?php foreach ($aiflt_visual_noise_data['issues'] as $aiflt_issue): ?>
                                <li><?php echo esc_html($aiflt_issue); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            <?php else: // Fallback if data is not a valid array ?>
                <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mt-4"><?php echo esc_html__('Could not retrieve visual noise analysis data for this product.', 'ai-flash-tune'); ?></p>
            <?php endif; ?>
            <?php // --- END: MODIFIED CODE --- ?>
        </div>

        <!-- Product-Specific Funnel & Behavioral Insights -->
        <div class="ai-flash-tune-flex ai-flash-tune-gap-6 ai-flash-tune-mb-8">
            <div class="ai-flash-tune-card ai-flash-tune-funnel-flow-card">
                <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title"><?php echo esc_html(__('Product Funnel Flow', 'ai-flash-tune')); ?></span>
                <div class="ai-flash-tune-funnel-flow-detail ai-flash-tune-flex ai-flash-tune-flex-wrap ai-flash-tune-flex-center">
                    <!-- Funnel Flow will be dynamically rendered here -->
                    <div class="ai-flash-tune-funnel-step-detail ai-flash-tune-funnel-step-item">
                        <i class="fas fa-box-open ai-flash-tune-text-indigo-600 ai-flash-tune-text-4xl ai-flash-tune-mb-2"></i>
                        <p class="ai-flash-tune-font-bold ai-flash-tune-text-lg ai-flash-tune-step-label"><?php echo esc_html(__('Product Page', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value"><?php echo esc_html($aiflt_product_details['funnel']['views']); ?> <?php echo esc_html(__('Views', 'ai-flash-tune')); ?></p>
                    </div>
                    <div class="ai-flash-tune-funnel-arrow-detail ai-flash-tune-funnel-arrow-vertical"></div>
                    <div class="ai-flash-tune-funnel-step-detail ai-flash-tune-funnel-step-item">
                        <i class="fas fa-shopping-cart ai-flash-tune-text-indigo-600 ai-flash-tune-text-4xl ai-flash-tune-mb-2"></i>
                        <p class="ai-flash-tune-font-bold ai-flash-tune-text-lg ai-flash-tune-step-label"><?php echo esc_html(__('Add to Cart', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value"><?php echo esc_html($aiflt_product_details['funnel']['cart_adds']); ?> <?php echo esc_html(__('Adds', 'ai-flash-tune')); ?></p>
                    </div>
                    <div class="ai-flash-tune-funnel-arrow-detail ai-flash-tune-funnel-arrow-vertical"></div>
                    <div class="ai-flash-tune-funnel-step-detail ai-flash-tune-funnel-step-item">
                        <i class="fas fa-check-circle ai-flash-tune-text-green-600 ai-flash-tune-text-4xl ai-flash-tune-mb-2"></i>
                        <p class="ai-flash-tune-font-bold ai-flash-tune-text-lg ai-flash-tune-step-label"><?php echo esc_html(__('Purchase', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value"><?php echo esc_html($aiflt_product_details['funnel']['sales']); ?> <?php esc_html(__('Sales', 'ai-flash-tune')); ?></p>
                    </div>
                </div>
            </div>

            <div class="ai-flash-tune-card">
                <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title"><?php echo esc_html(__('Top Behavioral Insights', 'ai-flash-tune')); ?></span>
                <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-space-y-2 ai-flash-tune-insights-list">
                    <?php foreach ($aiflt_product_details['behavioral_insights'] as $aiflt_insight => $aiflt_value) { ?>
                        <li class="ai-flash-tune-text-sm ai-flash-tune-text-gray-700">
                            <span class="ai-flash-tune-font-semibold"><?php echo esc_html__($aiflt_insight, 'ai-flash-tune'); ?>:</span> <?php echo esc_html($aiflt_value); ?>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</div>
