<?php
if (!defined('ABSPATH')) die('Restricted Access');
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ai-flash-tune'));
}
$aiflt_page_title = __('Dashboard Overview', 'ai-flash-tune');
$aiflt_is_wc_active = aiflt_is_woocommerce_active();

// Check if PRO addons are active
$aiflt_is_ai_analysis_addon_active = is_plugin_active('ai-flash-tune-ai-analysis/ai-flash-tune-ai-analysis.php');
$aiflt_is_smart_suggestions_addon_active = is_plugin_active('ai-flash-tune-smart-suggestions/ai-flash-tune-smart-suggestions.php');
// Add the check for the Checkout Optimizer addon
$aiflt_is_checkout_optimizer_addon_active = is_plugin_active('ai-flash-tune-checkout-optimizer/ai-flash-tune-checkout-optimizer.php');
// Conditionally load data and set defaults if WooCommerce is inactive.
if ($aiflt_is_wc_active) {
    // Load all necessary data from logic classes
    $aiflt_dashboard_metrics = AIFLT_Funnel_Analyzer_Logic::get_dashboard_metrics();
    $aiflt_top_drop_off_metrics = AIFLT_Funnel_Analyzer_Logic::get_top_drop_off_metrics();
    
    // --- REVISED: Load the correct report based on addon status ---
    if ($aiflt_is_ai_analysis_addon_active) {
        $aiflt_ai_report = get_transient('aiftaa_latest_full_report');
    } else {
        $aiflt_ai_report = AIFLT_Funnel_Analyzer_Logic::get_ai_weekly_report();
    }

    $aiflt_low_performing_products = AIFLT_Products_Logic::get_low_performing_products_for_dashboard();
    $aiflt_has_products = AIFLT_Products_Logic::has_any_products(); // --->  Check if products exist.
    $aiflt_checkout_detector_data = AIFLT_Funnel_Analyzer_Logic::get_checkout_field_data();
    $aiflt_funnel_data = AIFLT_Funnel_Analyzer_Logic::get_funnel_data(); // Fetch initial funnel data
    $aiflt_page_speed_data = AIFLT_Funnel_Analyzer_Logic::get_page_speed_alerts();
} else {
    // If WooCommerce is inactive, provide safe, default values to prevent warnings.
    $aiflt_dashboard_metrics = [
        'total_sessions' => 'N/A',
        'conversion_rate' => 'N/A',
        'abandoned_carts' => 'N/A',
        'page_speed' => 'N/A',
        'last_updated' => __('WooCommerce is inactive', 'ai-flash-tune'),
    ];
    $aiflt_top_drop_off_metrics = [
        'page_name' => 'N/A',
        'drop_off_rate' => '0',
        'ai_insights' => __('Activate WooCommerce to get AI insights.', 'ai-flash-tune'),
        'rage_clicks' => '0',
        'scroll_stops' => '0',
        'quick_bounces' => '0',
        'basic_suggestion' => __('Suggestions require live data from WooCommerce. Please activate the plugin to get started.', 'ai-flash-tune'), // ---> This line was already added, ensure it's present.
    ];
    $aiflt_ai_report = [
        'report' => __('AI report requires live data from WooCommerce.', 'ai-flash-tune'),
        'next_available' => '0',
    ];
    $aiflt_low_performing_products = [];
    $aiflt_has_products = false; // ---> NEW: Set default for has_products.
    $aiflt_checkout_detector_data = [
        'css_class' => 'ai-flash-tune-text-gray-500',
        'icon_class' => 'fas fa-question-circle',
        'message' => __('Requires WooCommerce', 'ai-flash-tune'),
        'status' => 'N/A',
    ];
    $aiflt_funnel_data = ['is_empty' => true];
    $aiflt_page_speed_data = ['status' => 'no_data', 'alerts' => []]; // 'no_data' status prevents the warning box from showing.
}
$aiflt_core_pro_features = [
    [
        'name' => __('Abandoned Cart Recovery Bot', 'ai-flash-tune'),
        'description' => __('Automated email reminders with customizable flows to recover lost sales.', 'ai-flash-tune'),
        'icon' => 'fas fa-robot',
        'is_installed' => true,
        'is_active' => true, 
    ],
    [
        'name' => __('Full AI Drop-Off Analysis', 'ai-flash-tune'),
        'description' => __('Get deep AI insights explaining why users drop off, analyzing speed, UX, trust, and more.', 'ai-flash-tune'),
        'icon' => 'fas fa-brain',
        'is_installed' => true,
        'is_active' => false, 
    ],
    [
        'name' => __('Smart Fix Suggestions Engine', 'ai-flash-tune'),
        'description' => __('Receive personalized AI suggestions to fix product copy, CTAs and layout.', 'ai-flash-tune'),
        'icon' => 'fas fa-magic',
        'is_installed' => false,
        'is_active' => false, 
    ],
    [
        'name' => __('AI Checkout Optimizer', 'ai-flash-tune'),
        'description' => __('The AI suggests and can apply a simplified checkout UX with fewer fields and trust boosters.', 'ai-flash-tune'),
        'icon' => 'fas fa-cash-register',
        'is_installed' => false,
        'is_active' => false,
    ],
    [
        'name' => __('Cart Abandon Reason Predictor', 'ai-flash-tune'),
        'description' => __('Uses AI to detect likely causes for abandonment like shipping costs or form issues.', 'ai-flash-tune'),
        'icon' => 'fas fa-search-dollar',
        'is_installed' => false,
        'is_active' => false,
    ],
    [
        'name' => __('Product Performance Doctor', 'ai-flash-tune'),
        'description' => __('Suggests fixes for poor-performing products based on user behavior, not just traffic.', 'ai-flash-tune'),
        'icon' => 'fas fa-stethoscope',
        'is_installed' => true,
        'is_active' => true,
    ],
    [
        'name' => __('AI Product Copy Enhancer', 'ai-flash-tune'),
        'description' => __('Rewrites product titles and descriptions based on sales psychology to boost conversions.', 'ai-flash-tune'),
        'icon' => 'fas fa-pencil-alt',
        'is_installed' => false,
        'is_active' => false,
    ],
    [
        'name' => __('Funnel Segmentation Dashboard', 'ai-flash-tune'),
        'description' => __('Filter funnel data by user type, and more for deeper insights.', 'ai-flash-tune'),
        'icon' => 'fas fa-filter',
        'is_installed' => true,
        'is_active' => false,
    ],
    [
        'name' => __('1-Click Fix Apply', 'ai-flash-tune'),
        'description' => __('Apply AI-recommended fixes to your store with one click (e.g., CTA rewrite, layout tweak).', 'ai-flash-tune'),
        'icon' => 'fas fa-mouse-pointer',
        'is_installed' => false,
        'is_active' => false,
    ],
];

// ---> NEW: Filter for uninstalled features and prepare the display logic
$aiflt_uninstalled_features = [];
foreach ($aiflt_core_pro_features as $aiflt_feature) {
    if (!$aiflt_feature['is_installed']) {
        $aiflt_uninstalled_features[] = $aiflt_feature;
    }
}
$aiflt_show_view_all_link = count($aiflt_uninstalled_features) > 3;
$aiflt_features_to_show = array_slice($aiflt_uninstalled_features, 0, 3);

?>
<div class="ai-flash-tune-admin-wrapper">
    <?php include_once('ai-flash-tune-admin-sidebar.php'); ?>
    <div class="ai-flash-tune-main-content">
        <?php if (!$aiflt_is_wc_active): ?>
            <?php
            $aiflt_install_url = admin_url('plugin-install.php?s=woocommerce&tab=search&type=term');
            ?>
            <div class="ai-flash-tune-notice-bar ai-flash-tune-mb-8">
                <div class="ai-flash-tune-notice-content">
                    <i class="fas fa-plug" aria-hidden="true"></i>
                    <span><strong><?php echo esc_html(__('Action Required:', 'ai-flash-tune')); ?></strong> <?php echo esc_html(__('AI Flash Tune requires WooCommerce. Please install or activate it to begin tracking live data.', 'ai-flash-tune')); ?></span>
                </div>
                <a href="<?php echo esc_url($aiflt_install_url); ?>" class="ai-flash-tune-notice-button">
                    <?php echo esc_html(__('Install WooCommerce', 'ai-flash-tune')); ?>
                </a>
            </div>
        <?php endif; ?>
        <!-- Add a class to the content wrapper when WooCommerce is inactive -->
        <div class="ai-flash-tune-page-content-wrapper <?php echo !$aiflt_is_wc_active ? 'ai-flash-tune-is-disabled' : ''; ?>">
            <div class="ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-flex-center ai-flash-tune-mb-8 ai-flash-tune-page-header">
                <span class="ai-flash-tune-main-title"><?php echo esc_html(__('Dashboard Overview', 'ai-flash-tune')); ?></span>
                <div class="ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-space-x-4 ai-flash-tune-header-actions">
                    <span id="ai-flash-tune-last-updated-text" class="ai-flash-tune-text-gray-600 ai-flash-tune-text-sm ai-flash-tune-last-updated"><?php echo esc_html($aiflt_dashboard_metrics['last_updated']); ?></span>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=ai_flash_tune')); ?>" class="ai-flash-tune-bg-blue-500 hover:ai-flash-tune-bg-blue-600 ai-flash-tune-text-white ai-flash-tune-font-semibold ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-rounded-lg ai-flash-tune-shadow-md ai-flash-tune-refresh-button">
                        <i class="fas fa-sync-alt ai-flash-tune-mr-2" aria-hidden="true"></i> <?php echo esc_html(__('Refresh Data', 'ai-flash-tune')); ?>
                    </a>
                </div>
            </div>

            <?php
            // --- NEW: Data Collection Notice ---
            // Check if the plugin has been active for less than, say, 3 days
            // Or check if there's very little data (e.g., less than 100 sessions)
            // For simplicity, let's use a time-based check for now.
            $aiflt_install_time = get_option('aiflt_activation_time', time()); // You'd need to set this option on activation
            $aiflt_days_active = (time() - $aiflt_install_time) / DAY_IN_SECONDS;

            // Show the notice for the first 3 days
            if ($aiflt_days_active < 3) :
            ?>
                <div class="ai-flash-tune-notice-bar ai-flash-tune-notice-info ai-flash-tune-mb-8">
                    <div class="ai-flash-tune-notice-content">
                        <i class="fas fa-info-circle" aria-hidden="true"></i>
                        <span><strong><?php echo esc_html(__('Getting Started:', 'ai-flash-tune')); ?></strong> <?php echo esc_html(__('AI Flash Tune is now collecting data about your visitors. Initial insights might be limited. Suggestions will become more accurate as more data is gathered over the next few days.', 'ai-flash-tune')); ?></span>
                    </div>
                </div>
            <?php
            endif;
            // --- END: Data Collection Notice ---
            ?>
            
            <div id="ai-flash-tune-dashboard-insights-container" class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-md-2 ai-flash-tune-grid-cols-lg-4 ai-flash-tune-mb-8 ai-flash-tune-key-insights">
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                    <div>
                        <span class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Total Sessions (Last 7 Days)', 'ai-flash-tune')); ?></span>
                        <span class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo esc_html($aiflt_dashboard_metrics['total_sessions']); ?></span>
                    </div>
                    <i class="fas fa-users ai-flash-tune-text-green-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                    <div>
                        <span class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Conversion Rate', 'ai-flash-tune')); ?></span>
                        <span class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo esc_html($aiflt_dashboard_metrics['conversion_rate']); ?>%</span>
                    </div>
                    <i class="fas fa-percent ai-flash-tune-text-blue-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                    <div>
                        <span class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Abandoned Carts', 'ai-flash-tune')); ?></span>
                        <span class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo esc_html($aiflt_dashboard_metrics['abandoned_carts']); ?></span>
                    </div>
                    <i class="fas fa-shopping-basket ai-flash-tune-text-red-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
                </div>
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                    <div>
                        <span class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Avg. Page Speed (LCP)', 'ai-flash-tune')); ?></span>
                        <span class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo esc_html($aiflt_dashboard_metrics['page_speed']); ?>s</span>
                    </div>
                    <i class="fas fa-tachometer-alt ai-flash-tune-text-yellow-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
                </div>
            </div>
            <div class="ai-flash-tune-card ai-flash-tune-mb-8">
                <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title"><?php echo esc_html(__('Performance Alerts', 'ai-flash-tune')); ?></span>
                <?php switch ($aiflt_page_speed_data['status']) :
                    case 'warning': ?>
                        <div class="ai-flash-tune-alert-message ai-flash-tune-alert-warning">
                            <i class="fas fa-exclamation-triangle ai-flash-tune-mr-2" aria-hidden="true"></i>
                            <span><?php echo esc_html(__('The following pages are slower than the recommended 2.5s threshold, which may be impacting your conversion rates:', 'ai-flash-tune')); ?></span>
                        </div>
                        <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-mt-4">
                            <?php foreach ($aiflt_page_speed_data['alerts'] as $aiflt_alert): ?>
                                <li>
                                    <strong><?php echo esc_html($aiflt_alert['name']); ?>:</strong>
                                    <?php 
                                    printf(
                                        /* translators: %s: The average page speed in seconds. */
                                        esc_html__('Average speed is %s seconds.', 'ai-flash-tune'),
                                        '<strong>' . esc_html($aiflt_alert['speed']) . 's</strong>'
                                    );
                                    ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <?php break; ?>

                    <?php case 'good': ?>
                        <div class="ai-flash-tune-alert-message ai-flash-tune-alert-success">
                            <i class="fas fa-check-circle ai-flash-tune-mr-2" aria-hidden="true"></i>
                            <span><?php echo esc_html(__('Great job! Your key pages are loading quickly.', 'ai-flash-tune')); ?></span>
                        </div>
                        <?php break; ?>

                    <?php case 'no_data': ?>
                    <?php default: ?>
                        <div class="ai-flash-tune-empty-state-message" style="text-align: left; padding: 1.5rem; margin-top: 1rem; border-style: solid;">
                            <div class="ai-flash-tune-flex" style="align-items: flex-start; gap: 1rem;">
                                <i class="fas fa-tachometer-alt ai-flash-tune-text-indigo-500" style="font-size: 1.75rem; margin-top: 5px;"></i>
                                <div>
                                    <p class="ai-flash-tune-empty-state-title" style="margin-bottom: 0.25rem;"><?php echo esc_html(__('Collecting Page Speed Data', 'ai-flash-tune')); ?></p>
                                    <p class="ai-flash-tune-empty-state-text"><?php echo esc_html(__('Once your store has visitor traffic, this report will alert you to any key pages that are loading slower than the recommended threshold.', 'ai-flash-tune')); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php break; ?>
                <?php endswitch; ?>
            </div>
            <div class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-lg-3 ai-flash-tune-mb-8">
                <div class="ai-flash-tune-lg-col-span-2 ai-flash-tune-card ai-flash-tune-drop-off-analysis">
                    <?php
                    // Check if the drop-off rate is greater than 0
                    if ( isset($aiflt_top_drop_off_metrics['drop_off_rate']) && (float) $aiflt_top_drop_off_metrics['drop_off_rate'] > 0 ) :
                    ?>

                        <span class="ai-flash-tune-flex ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                            <i class="fas fa-exclamation-triangle ai-flash-tune-text-red-500 ai-flash-tune-mr-2"></i><?php echo esc_html(__('What to Fix Now: Top Drop-Off Point', 'ai-flash-tune')); ?>
                        </span>
                        <div class="ai-flash-tune-flex ai-flash-tune-space-x-4 ai-flash-tune-mb-4">
                            <span class="ai-flash-tune-text-red-600 ai-flash-tune-text-2xl ai-flash-tune-font-bold ai-flash-tune-drop-off-page">
                                <?php echo esc_html($aiflt_top_drop_off_metrics['page_name']); ?>
                            </span>
                            <span class="ai-flash-tune-text-gray-600 ai-flash-tune-text-lg ai-flash-tune-drop-off-rate">
                                (<?php echo esc_html($aiflt_top_drop_off_metrics['drop_off_rate']); ?>% <?php echo esc_html(__('Drop-Off Rate', 'ai-flash-tune')); ?>)
                            </span>
                        </div>
                        <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-drop-off-description"><?php echo wp_kses_post($aiflt_top_drop_off_metrics['ai_insights']); ?></p>
                        <div class="ai-flash-tune-grid ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-sm-3 ai-flash-tune-gap-4 ai-flash-tune-text-center ai-flash-tune-mb-6">
                            <div class="ai-flash-tune-p-3 ai-flash-tune-bg-red-100 ai-flash-tune-rounded-lg ai-flash-tune-behavior-item">
                                <i class="fas fa-mouse-pointer ai-flash-tune-text-red-500 ai-flash-tune-text-2xl ai-flash-tune-mb-2"></i>
                                <span class="ai-flash-tune-text-lg ai-flash-tune-font-semibold">
                                    <?php echo esc_html(__('Rage Clicks:', 'ai-flash-tune')); ?>
                                    <i class="fas fa-question-circle ai-flash-tune-tooltip-icon" data-tooltip="<?php echo esc_attr(__('Users repeatedly clicking the same area in a short time, indicating frustration.', 'ai-flash-tune')); ?>"></i>
                                    <?php echo esc_html($aiflt_top_drop_off_metrics['rage_clicks']); ?>
                                </span>
                                <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600"><?php echo esc_html(__('Users repeatedly clicking', 'ai-flash-tune')); ?></p>
                            </div>
                            <div class="ai-flash-tune-p-3 ai-flash-tune-bg-yellow-100 ai-flash-tune-rounded-lg ai-flash-tune-behavior-item">
                                <i class="fas fa-stopwatch ai-flash-tune-text-yellow-500 ai-flash-tune-text-2xl ai-flash-tune-mb-2"></i>
                                <span class="ai-flash-tune-text-lg ai-flash-tune-font-semibold">
                                    <?php echo esc_html(__('Scroll Stops:', 'ai-flash-tune')); ?>
                                    <i class="fas fa-question-circle ai-flash-tune-tooltip-icon" data-tooltip="<?php echo esc_attr(__('Users scrolling to a specific point and stopping for several seconds, indicating hesitation or confusion.', 'ai-flash-tune')); ?>"></i>
                                    <?php echo esc_html($aiflt_top_drop_off_metrics['scroll_stops']); ?>
                                </span>
                                <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600"><?php echo esc_html(__('Users pausing on form fields', 'ai-flash-tune')); ?></p>
                            </div>
                            <div class="ai-flash-tune-p-3 ai-flash-tune-bg-purple-100 ai-flash-tune-rounded-lg ai-flash-tune-behavior-item">
                                <i class="fas fa-undo ai-flash-tune-text-purple-500 ai-flash-tune-text-2xl ai-flash-tune-mb-2"></i>
                                <span class="ai-flash-tune-text-lg ai-flash-tune-font-semibold">
                                    <?php echo esc_html(__('Quick Bounces:', 'ai-flash-tune')); ?>
                                    <i class="fas fa-question-circle ai-flash-tune-tooltip-icon" data-tooltip="<?php echo esc_attr(__('Users leaving the page very quickly after arriving, indicating the content was not what they expected.', 'ai-flash-tune')); ?>"></i>
                                    <?php echo esc_html($aiflt_top_drop_off_metrics['quick_bounces']); ?>
                                </span>
                                <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600"><?php echo esc_html(__('Users leaving immediately', 'ai-flash-tune')); ?></p>
                            </div>
                        </div>
                        <a id="aift-view-suggestion-btn" class="ai-flash-tune-bg-red-600 hover:ai-flash-tune-bg-red-700 ai-flash-tune-text-white ai-flash-tune-font-semibold ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-rounded-lg ai-flash-tune-shadow-md ai-flash-tune-cta-button" href="#">
                            <i class="fas fa-lightbulb ai-flash-tune-mr-2"></i> <?php echo esc_html(__('View Basic Suggestion', 'ai-flash-tune')); ?>
                        </a>
                    <?php
                    // Else: If the drop-off rate is 0 or less
                    else :
                    ?>
                        <span class="ai-flash-tune-flex ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                            <i class="fas fa-check-circle ai-flash-tune-text-green-500 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Funnel Health Status', 'ai-flash-tune')); ?>
                        </span>
                        <div class="ai-flash-tune-empty-state-message" style="text-align: left; padding: 1.5rem; margin-top: 1rem; border-style: solid; border-color: #d1fae5; background-color: #f0fdf4;">
                             <div class="ai-flash-tune-flex" style="align-items: flex-start; gap: 1rem;">
                                <i class="fas fa-thumbs-up ai-flash-tune-text-green-500" style="font-size: 1.75rem; margin-top: 5px;"></i>
                                <div>
                                    <p class="ai-flash-tune-empty-state-title" style="margin-bottom: 0.25rem;"><?php echo esc_html__('No Major Drop-Offs Detected!', 'ai-flash-tune'); ?></p>
                                    <p class="ai-flash-tune-empty-state-text"><?php echo esc_html__('Based on the current data, your funnel doesn\'t show any single stage with a critically high drop-off rate. Keep monitoring performance as you gather more visitor data.', 'ai-flash-tune'); ?></p>
                                </div>
                            </div>
                        </div>

                    <?php
                    endif;
                    ?>
                </div>
                <!-- AI Insight Report Section -->
                <div class="ai-flash-tune-card <?php echo !$aiflt_is_ai_analysis_addon_active ? 'ai-flash-tune-relative ai-flash-tune-pro-feature-card' : ''; ?>">
                    <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                        <?php echo $aiflt_is_ai_analysis_addon_active ? esc_html__('Full AI Analysis', 'ai-flash-tune') : esc_html(__('Limited AI Insight Report', 'ai-flash-tune')); ?>
                    </span>
                    <?php if ($aiflt_is_ai_analysis_addon_active): ?>
                        <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4"><?php echo esc_html__('Your latest full analysis report. Generate a new one for the most up-to-date insights.', 'ai-flash-tune'); ?></p>
                        <div id="aiftaa-dashboard-report-content" class="ai-flash-tune-bg-gray-100 ai-flash-tune-p-4 ai-flash-tune-rounded-lg ai-flash-tune-text-gray-700 ai-flash-tune-text-sm">
                            <?php if ($aiflt_ai_report && isset($aiflt_ai_report['report'])) {
                                // Display a truncated summary
                                $aiflt_summary = wp_strip_all_tags($aiflt_ai_report['report']);
                                echo esc_html(wp_trim_words($aiflt_summary, 40, '...'));
                            } else {
                                echo '<em>' . esc_html__( 'No report generated yet. Click ', 'ai-flash-tune' ) . '<strong>' . esc_html__( 'Generate Now', 'ai-flash-tune' ) . '</strong>' . esc_html__( ' to get your first analysis.', 'ai-flash-tune' ) . '</em>';
                            } ?>
                        </div>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=aiftaa-analysis-dashboard')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue ai-flash-tune-mt-4">
                            <?php echo esc_html__('View Full Report & Generate New', 'ai-flash-tune'); ?>
                        </a>
                    <?php else: ?>
                        <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-section-description"><?php echo esc_html(__('Your weekly AI analysis for one drop-off point.', 'ai-flash-tune')); ?></p>
                        <div class="ai-flash-tune-bg-gray-100 ai-flash-tune-p-4 ai-flash-tune-rounded-lg ai-flash-tune-text-gray-700 ai-flash-tune-text-sm italic ai-flash-tune-insight-report">
                            <?php echo wp_kses_post( nl2br( $aiflt_ai_report['report'] ) ); ?>
                        </div>
                        <?php if (intval($aiflt_ai_report['next_available']) > 0) {  ?>
                            <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-mt-4">
                                <?php echo esc_html(__('Next report available in', 'ai-flash-tune')).' ';?></strong><?php echo intval($aiflt_ai_report['next_available']); ?></strong><?php echo esc_html(' '.__('days.', 'ai-flash-tune')); ?>
                            </p>
                        <?php } ?>
                    <?php endif; ?>
                </div>
            </div>
            <div id="aift-suggestion-modal-overlay" class="ai-flash-tune-modal-overlay"></div>
            <div id="aift-suggestion-modal" class="ai-flash-tune-modal">
                <div class="ai-flash-tune-modal-header">
                    <h3 class="ai-flash-tune-modal-title"><?php echo esc_html(__('Basic Suggestion', 'ai-flash-tune')); ?></h3>
                    <button id="aift-suggestion-modal-close" class="ai-flash-tune-modal-close">&times;</button>
                </div>
                <div class="ai-flash-tune-modal-content">
                    <p><?php echo esc_html($aiflt_top_drop_off_metrics['basic_suggestion']); ?></p>
                </div>
            </div>
            <div id="ai-flash-tune-dashboard-funnel" class="ai-flash-tune-card ai-flash-tune-mb-8 ai-flash-tune-funnel-section">
                <div class="ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-flex-center ai-flash-tune-mb-4">
                    <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title"><?php echo esc_html(__('Basic Funnel Flow Visualization', 'ai-flash-tune')); ?></span>
                    <?php if ($aiflt_is_wc_active && !$aiflt_funnel_data['is_empty']) : ?>
                        <div class="ai-flash-tune-flex ai-flash-tune-justify-end ai-flash-tune-mb-4 ai-flash-tune-funnel-toggles">
                            <div class="ai-flash-tune-inline-flex ai-flash-tune-rounded-md ai-flash-tune-shadow-sm" role="group">
                                <a href="#" data-device="desktop" class="ai-flash-tune-px-4 ai-flash-tune-py-2 ai-flash-tune-text-sm ai-flash-tune-font-medium ai-flash-tune-text-blue-700 ai-flash-tune-bg-white ai-flash-tune-border ai-flash-tune-border-gray-200 ai-flash-tune-rounded-l-lg ai-flash-tune-funnel-toggle-button active">
                                    <?php echo esc_html(__('Desktop', 'ai-flash-tune')); ?>
                                </a>
                                <a href="#" data-device="mobile" class="ai-flash-tune-px-4 ai-flash-tune-py-2 ai-flash-tune-text-sm ai-flash-tune-font-medium ai-flash-tune-text-gray-900 ai-flash-tune-bg-white ai-flash-tune-border ai-flash-tune-rounded-r-lg ai-flash-tune-border-gray-200 ai-flash-tune-funnel-toggle-button">
                                    <?php echo esc_html(__('Mobile', 'ai-flash-tune')); ?>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if (!$aiflt_is_wc_active || $aiflt_funnel_data['is_empty']) : ?>
                    <?php // If WC is inactive OR there's no data, show the empty message and NO TABS. ?>
                    <div class="ai-flash-tune-empty-state-message" style="width: 100%;">
                        <i class="fas fa-chart-line ai-flash-tune-empty-state-icon"></i>
                        <p class="ai-flash-tune-empty-state-title"><?php echo esc_html(__('Collecting Funnel Data', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-empty-state-text"><?php echo esc_html(__('Your funnel visualization will appear here once your store has some visitor traffic.', 'ai-flash-tune')); ?></p>
                    </div>
                <?php else : ?>
                    <?php // If we have data, show the TABS and the initial DESKTOP VIEW. ?>
                    <div id="ai-flash-tune-funnel-flow-dashboard" class="ai-flash-tune-flex ai-flash-tune-flex-wrap ai-flash-tune-flex-center ai-flash-tune-funnel-flow">
                        <div class="ai-flash-tune-funnel-step ai-flash-tune-funnel-step-item">
                            <i class="fas fa-home ai-flash-tune-text-indigo-600 ai-flash-tune-text-3xl ai-flash-tune-mb-2"></i>
                            <p class="ai-flash-tune-font-medium ai-flash-tune-step-label"><?php echo esc_html(__('Landing Page', 'ai-flash-tune')); ?></p>
                            <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value"><?php echo number_format(esc_html($aiflt_funnel_data['landing_page_visits'])); ?> <?php echo esc_html(__('Visitors', 'ai-flash-tune')); ?></p>
                            <br>
                        </div>
                        <div class="ai-flash-tune-funnel-arrow"></div>
                        <div class="ai-flash-tune-funnel-step ai-flash-tune-funnel-step-item">
                            <i class="fas fa-box-open ai-flash-tune-text-indigo-600 ai-flash-tune-text-3xl ai-flash-tune-mb-2"></i>
                            <p class="ai-flash-tune-font-medium ai-flash-tune-step-label"><?php echo esc_html(__('Product Page', 'ai-flash-tune')); ?></p>
                            <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value">
                                <?php echo esc_html( number_format_i18n( (int) $aiflt_funnel_data['product_page_views'] ) ); ?>
                                <?php echo esc_html__( 'Views', 'ai-flash-tune' ); ?>
                            </p>
                            <p class="ai-flash-tune-text-xs ai-flash-tune-text-green-600 ai-flash-tune-step-value">
                                <?php
                                echo esc_html( round($aiflt_funnel_data['conversion_product'], 2))."% ".esc_html__( 'Conversion', 'ai-flash-tune' );
                                ?>
                            </p>
                        </div>
                        <div class="ai-flash-tune-funnel-arrow"></div>
                        <div class="ai-flash-tune-funnel-step ai-flash-tune-funnel-step-item">
                            <i class="fas fa-shopping-cart ai-flash-tune-text-indigo-600 ai-flash-tune-text-3xl ai-flash-tune-mb-2"></i>
                            <p class="ai-flash-tune-font-medium ai-flash-tune-step-label"><?php echo esc_html(__('Cart Page', 'ai-flash-tune')); ?></p>
                            <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value">
                                <?php echo esc_html( number_format_i18n( (int) $aiflt_funnel_data['cart_entries'] ) ); ?>
                                <?php echo esc_html__( 'Carts', 'ai-flash-tune' );
                                ?>
                            </p>
                            <p class="ai-flash-tune-text-xs ai-flash-tune-text-green-600 ai-flash-tune-step-value">
                                <?php
                                echo esc_html( round($aiflt_funnel_data['conversion_cart'], 2))."% ".esc_html__( 'Conversion', 'ai-flash-tune' );
                                ?>
                            </p>
                        </div>
                        <div class="ai-flash-tune-funnel-arrow"></div>
                        <div class="ai-flash-tune-funnel-step ai-flash-tune-funnel-step-item">
                            <i class="fas fa-credit-card ai-flash-tune-text-indigo-600 ai-flash-tune-text-3xl ai-flash-tune-mb-2"></i>
                            <p class="ai-flash-tune-font-medium ai-flash-tune-step-label"><?php echo esc_html(__('Checkout Page', 'ai-flash-tune')); ?></p>
                            <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-step-value">
                                <?php echo esc_html(number_format_i18n( (int) $aiflt_funnel_data['checkout_starts'] )); ?>
                                <?php echo esc_html__( 'Checkouts', 'ai-flash-tune' );
                                ?>
                            </p>
                            <p class="ai-flash-tune-text-xs ai-flash-tune-text-green-600 ai-flash-tune-step-value">
                                <?php
                                echo esc_html( round($aiflt_funnel_data['conversion_checkout'], 2))."% ".esc_html__( 'Conversion', 'ai-flash-tune' );
                                ?>
                            </p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-lg-2 ai-flash-tune-mb-8">
                <div class="ai-flash-tune-card ai-flash-tune-low-performers">
                    <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                        <i class="fas fa-search-dollar ai-flash-tune-text-indigo-600 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Low-Performing Product Finder', 'ai-flash-tune')); ?>
                    </span>
                    <?php if (!empty($aiflt_low_performing_products)) : ?>
                        <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-section-description"><?php echo esc_html(__('Flags high-traffic products that aren\'t selling, giving you a clear focus for optimization.', 'ai-flash-tune')); ?></p>
                        <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-text-gray-700 ai-flash-tune-space-y-2 ai-flash-tune-low-performer-list">
                            <?php foreach ($aiflt_low_performing_products as $aiflt_product) : ?>
                                <li>
                                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=product-detail&product_id=' . $aiflt_product['product_id'] ) ); ?>" class="ai-flash-tune-text-indigo-600 hover:ai-flash-tune-text-indigo-900">
                                        "<?php echo esc_html( $aiflt_product['product_name'] ); ?>"
                                    </a> - 
                                    <?php
                                    echo esc_html(
                                        sprintf(
                                            /* translators: 1: Number of views, 2: Number of sales */
                                            __( '%1$d views, %2$d sales', 'ai-flash-tune' ),
                                            $aiflt_product['views'],
                                            $aiflt_product['sales']
                                        )
                                    );
                                    ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                        <a class="ai-flash-tune-btn ai-flash-tune-btn-blue" href="<?php echo esc_url(admin_url('admin.php?page=products&status_filter=Low-Performing')); ?>">
                            <?php echo esc_html(__('View All Low-Performers', 'ai-flash-tune')); ?>
                        </a>
                    <?php else : ?>
                        <?php if ($aiflt_has_products) : ?>
                            <?php // Case 1: Products exist, but none are low-performing. ?>
                            <div class="ai-flash-tune-empty-state-message" style="text-align: left; padding: 0.7rem; margin-top: 1rem; border-style: solid;">
                                 <div class="ai-flash-tune-flex" style="align-items: flex-start; gap: 1rem;">
                                    <i class="fas fa-check-circle ai-flash-tune-text-green-500" style="font-size: 1.75rem; margin-top: 5px;"></i>
                                    <div>
                                        <p class="ai-flash-tune-empty-state-title" style="margin-bottom: 0.25rem;"><?php echo esc_html__('No Critical Issues Found', 'ai-flash-tune'); ?></p>
                                        <p class="ai-flash-tune-empty-state-text"><?php echo esc_html__('Our scan for products with high traffic but critically low sales found no issues. This is a great sign!', 'ai-flash-tune'); ?></p>
                                    </div>
                                </div>
                            </div>
                            <a class="ai-flash-tune-btn ai-flash-tune-btn-blue ai-flash-tune-mt-4" href="<?php echo esc_url(admin_url('admin.php?page=products')); ?>">
                                <?php echo esc_html(__('Review All Product Performance', 'ai-flash-tune')); ?>
                            </a>
                        <?php else : ?>
                            <?php // Case 2: No products exist in the store at all. ?>
                            <div class="ai-flash-tune-empty-state-message" style="text-align: left; padding: 0.7rem; margin-top: 1rem; border-style: solid;">
                                 <div class="ai-flash-tune-flex" style="align-items: flex-start; gap: 1rem;">
                                    <i class="fas fa-box-open ai-flash-tune-text-indigo-500" style="font-size: 1.75rem; margin-top: 5px;"></i>
                                    <div>
                                        <p class="ai-flash-tune-empty-state-title" style="margin-bottom: 0.25rem;"><?php echo esc_html__('No Products to Analyze', 'ai-flash-tune'); ?></p>
                                        <?php if (!$aiflt_is_wc_active) { ?>
                                            <p class="ai-flash-tune-empty-state-text"><?php echo esc_html__('This report will automatically find opportunities once you add products to your store.', 'ai-flash-tune'); ?></p>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <?php if ($aiflt_is_wc_active) { ?>
                                <a target="_blank" class="ai-flash-tune-btn ai-flash-tune-btn-blue ai-flash-tune-mt-4" href="<?php echo esc_url(admin_url('post-new.php?post_type=product')); ?>">
                                    <i class="fas fa-plus ai-flash-tune-mr-2"></i> <?php echo esc_html(__('Add Your First Product', 'ai-flash-tune')); ?>
                                </a>
                            <?php } ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <?php if ($aiflt_is_smart_suggestions_addon_active): ?>
                    <div class="ai-flash-tune-page-content-wrapper <?php echo !$aiflt_is_wc_active ? 'ai-flash-tune-is-disabled' : ''; ?>">
                        <div class="ai-flash-tune-grid ai-flash-tune-gap-6 ai-flash-tune-grid-cols-1 lg:ai-flash-tune-grid-cols-2">
                            <div class="ai-flash-tune-card <?php echo !$aiflt_is_smart_suggestions_addon_active ? 'ai-flash-tune-relative ai-flash-tune-pro-feature-card' : ''; ?>">
                                <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                                    <i class="fas fa-magic ai-flash-tune-text-indigo-600 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Smart Fix Suggestions Engine', 'ai-flash-tune')); ?>
                                </span>
                                <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4"><?php echo esc_html(__('Get personalized, AI-powered suggestions to fix conversion leaks across your store.', 'ai-flash-tune')); ?></p>
                                <div class="ai-flash-tune-bg-gray-100 ai-flash-tune-p-4 ai-flash-tune-rounded-lg ai-flash-tune-text-gray-700 ai-flash-tune-text-sm">
                                    <em><?php echo esc_html__('Click the button below to go to the Smart Suggestions dashboard and generate actionable insights for your products, checkout, and more.', 'ai-flash-tune'); ?></em>
                                </div>
                                <a href="<?php echo esc_url(admin_url('admin.php?page=aiftss-suggestions-dashboard')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue ai-flash-tune-mt-4">
                                    <?php echo esc_html__('Get Suggestions', 'ai-flash-tune'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="ai-flash-tune-card ai-flash-tune-checkout-detector">
                    <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                        <i class="fas fa-clipboard-list ai-flash-tune-text-indigo-600 ai-flash-tune-mr-2"></i><?php echo esc_html(__('Checkout Field Overload Detector', 'ai-flash-tune')); ?>
                    </span>
                    <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-section-description"><?php echo esc_html(__('Warns if checkout form has too many fields or friction.', 'ai-flash-tune')); ?></p>
                    <div class="ai-flash-tune-flex <?php echo esc_attr($aiflt_checkout_detector_data['css_class']); ?> ai-flash-tune-font-semibold ai-flash-tune-text-lg ai-flash-tune-detector-status ai-flash-tune-card-title">
                        <i class="<?php echo esc_attr($aiflt_checkout_detector_data['icon_class']); ?> ai-flash-tune-mr-2"></i> <span class="ai-flash-tune-detector-text"><?php echo esc_html($aiflt_checkout_detector_data['message']); ?></span>
                    </div>
                    <?php if ($aiflt_checkout_detector_data['status'] === 'High Friction') : ?>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-mt-2"><?php echo esc_html(__('Your checkout form has more fields than recommended. This can lead to higher abandonment rates.', 'ai-flash-tune')); ?></p>
                    <?php endif; ?>
                </div>
                <?php if ($aiflt_is_checkout_optimizer_addon_active): ?>
                    <div class="ai-flash-tune-card <?php echo !$aiflt_is_checkout_optimizer_addon_active ? 'ai-flash-tune-relative ai-flash-tune-pro-feature-card' : ''; ?>">
                        <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                            <i class="fas fa-rocket ai-flash-tune-text-indigo-600 ai-flash-tune-mr-2"></i>
                            <?php echo esc_html(__('AI Checkout Optimizer', 'ai-flash-tune')); ?>
                        </span>
                        <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4"><?php echo esc_html__('Get a detailed AI analysis of your checkout fields and user experience to reduce abandonment.', 'ai-flash-tune'); ?></p>
                        <a href="<?php echo esc_url(admin_url('admin.php?page=aiftco-optimizer-dashboard')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue">
                            <?php echo esc_html__('Analyze My Checkout', 'ai-flash-tune'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
