<?php
if (!defined('ABSPATH')) die('Restricted Access');
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ai-flash-tune'));
}
// Sanitize and retrieve the current page from the URL
$c = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : '';
?>
<button id="aift-sidebar-toggle" class="ai-flash-tune-sidebar-toggle"><i class="fas fa-bars"></i></button>
<div class="ai-flash-tune-sidebar-overlay"></div>
<div class="ai-flash-tune-sidebar">
    <div class="ai-flash-tune-sidebar-logo">
        <a title="<?php echo esc_attr(__('AIFlashTune Dashboard', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=ai_flash_tune')) ?>" class="ai-flash-tune-sidebar-logo-img-wrp">
            <img src="<?php echo esc_url(AIFLT_PLUGIN_URL . 'assets/images/logo.png'); ?>" alt="<?php echo esc_attr(__('AIFlashTune Logo', 'ai-flash-tune')); ?>" />
        </a>
    </div>
    <nav class="ai-flash-tune-sidebar-nav">
        <a title="<?php echo esc_attr(__('Dashboard', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=ai_flash_tune'))?>" class="ai-flash-tune-nav-link <?php if($c == 'ai_flash_tune' || $c == '') echo esc_attr('active'); ?>">
            <i class="fas fa-tachometer-alt ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Dashboard', 'ai-flash-tune')); ?></span>
        </a>
        <a title="<?php echo esc_attr(__('Funnel Analysis', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=funnelanalysis'))?>" class="ai-flash-tune-nav-link <?php if($c == 'funnelanalysis' ) echo esc_attr('active'); ?>">
            <i class="fas fa-chart-line ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Funnel Analysis', 'ai-flash-tune')); ?></span>
        </a>

        <?php // --- Conditionally show the AI Analysis link if the addon is active ---
        if (class_exists('AIFTAA_Logic')) : ?>
            <a title="<?php echo esc_attr(__('AI Analysis', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=aiftaa-analysis-dashboard'))?>" class="ai-flash-tune-nav-link <?php if($c == 'aiftaa-analysis-dashboard' ) echo esc_attr('active'); ?>">
                <i class="fas fa-brain ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('AI Analysis', 'ai-flash-tune')); ?></span>
            </a>
        <?php endif; ?>

        <a title="<?php echo esc_attr(__('Products', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=products'))?>" class="ai-flash-tune-nav-link <?php if($c == 'products' || $c == 'product-detail' ) echo esc_attr('active'); ?>">
            <i class="fas fa-box ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Products', 'ai-flash-tune')); ?></span>
        </a>
        <a title="<?php echo esc_attr(__('Abandoned Carts', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=abandonedcarts'))?>" class="ai-flash-tune-nav-link <?php if($c == 'abandonedcarts' ) echo esc_attr('active'); ?>">
            <i class="fas fa-shopping-cart ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Abandoned Carts', 'ai-flash-tune')); ?></span>
        </a>
        <?php // --- Conditionally show the Email Log link if the addon is active ---
        if (class_exists('AIFTCR_Logic')) : ?>
            <a title="<?php echo esc_attr(__('Email Log', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=aiftcr-email-log'))?>" class="ai-flash-tune-nav-link <?php if($c == 'aiftcr-email-log' ) echo esc_attr('active'); ?>">
                <i class="fas fa-history ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Email Log', 'ai-flash-tune')); ?></span>
            </a>
        <?php endif; ?>
        <?php // --- Conditionally show the Smart Suggestions link if the addon is active ---
        if (class_exists('AIFTSS_Logic')) : ?>
            <a title="<?php echo esc_attr(__('Smart Suggestions', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=aiftss-suggestions-dashboard'))?>" class="ai-flash-tune-nav-link <?php if($c == 'aiftss-suggestions-dashboard' ) echo esc_attr('active'); ?>">
                <i class="fas fa-magic ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Smart Suggestions', 'ai-flash-tune')); ?></span>
            </a>
        <?php endif; ?>
        <?php // --- NEW: Conditionally show the Checkout Optimizer link ---
        if (class_exists('AIFTCO_Logic')) : ?>
            <a title="<?php echo esc_attr(__('Checkout Optimizer', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=aiftco-optimizer-dashboard'))?>" class="ai-flash-tune-nav-link <?php if($c == 'aiftco-optimizer-dashboard' ) echo esc_attr('active'); ?>">
                <i class="fas fa-cash-register ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Checkout Optimizer', 'ai-flash-tune')); ?></span>
            </a>
        <?php endif; ?>
        <a title="<?php echo esc_attr(__('Settings', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=aiflt_settings'))?>" class="ai-flash-tune-nav-link <?php if($c == 'aiflt_settings' ) echo esc_attr('active'); ?>">
            <i class="fas fa-cogs ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Settings', 'ai-flash-tune')); ?></span>
        </a>
        <a title="<?php echo esc_attr(__('Privacy Tools', 'ai-flash-tune')); ?>" href="<?php echo esc_url(admin_url('admin.php?page=privacy-tools'))?>" class="ai-flash-tune-nav-link <?php if($c == 'privacy-tools' ) echo esc_attr('active'); ?>">
            <i class="fas fa-user-shield ai-flash-tune-nav-icon"></i> <span class="ai-flash-tune-nav-text"><?php echo esc_html(__('Privacy Tools', 'ai-flash-tune')); ?></span>
        </a>
    </nav>
</div>
