<?php
if (!defined('ABSPATH')) die('Restricted Access');
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'ai-flash-tune'));
}
$aiflt_page_title = __('Abandoned Carts', 'ai-flash-tune');
$aiflt_is_predictor_addon_active = is_plugin_active('ai-flash-tune-abandonment-predictor/ai-flash-tune-abandonment-predictor.php');
$aiflt_is_cart_recovery_active = is_plugin_active('ai-flash-tune-cart-recovery/ai-flash-tune-cart-recovery.php');

// Check for WooCommerce dependency at the top of the view file.
if (aiflt_is_woocommerce_active()) {
    
    // --- NEW LOGIC START: Determine the effective default start date ---
    $aiflt_plugin_install_time = get_option('aiflt_activation_time', time());
    $aiflt_default_start_timestamp = strtotime('-29 days'); 
    $aiflt_min_valid_start_timestamp = $aiflt_plugin_install_time;

    // Determine the earliest valid default date by taking the LATER of the two timestamps.
    $aiflt_effective_start_timestamp = max($aiflt_default_start_timestamp, $aiflt_min_valid_start_timestamp);
    $aiflt_effective_default_start_date = gmdate('Y-m-d', $aiflt_effective_start_timestamp);
    // --- NEW LOGIC END ---
    
    // Handle pagination parameters
    $aiflt_current_page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
    $aiflt_items_per_page = 10;
    $aiflt_offset = ($aiflt_current_page - 1) * $aiflt_items_per_page;

    // Sanitize and set default filter parameters from GET
    // CRITICAL FIX: Use the calculated effective default start date.
    $aiflt_start_date = isset($_GET['start_date']) && !empty($_GET['start_date']) ? sanitize_text_field(wp_unslash($_GET['start_date'])) : $aiflt_effective_default_start_date;
    
    $aiflt_end_date = isset($_GET['end_date']) && !empty($_GET['end_date']) ? sanitize_text_field($_GET['end_date']) : gmdate('Y-m-d');
    $aiflt_customer_type = isset($_GET['customer_type']) ? sanitize_text_field($_GET['customer_type']) : 'all';

    // Pass all filters to the logic functions
    $aiflt_abandoned_data = AIFLT_Abandoned_Carts_Logic::get_abandoned_carts($aiflt_start_date, $aiflt_end_date, $aiflt_items_per_page, $aiflt_offset, $aiflt_customer_type);
    $aiflt_carts = $aiflt_abandoned_data['carts'];
    $aiflt_total_carts = $aiflt_abandoned_data['total_carts'];
    $aiflt_total_pages = ceil($aiflt_total_carts / $aiflt_items_per_page);
    
    $aiflt_metrics = AIFLT_Abandoned_Carts_Logic::get_abandoned_carts_metrics($aiflt_start_date, $aiflt_end_date, $aiflt_customer_type);
    $aiflt_total_abandoned = $aiflt_metrics['total_abandoned_carts'];
    $aiflt_total_lost_revenue = $aiflt_metrics['total_lost_revenue'];
    $aiflt_recovery_rate = $aiflt_metrics['recovery_rate'];
    $aiflt_latest_prediction = get_transient('aiftap_latest_prediction');
}
?>
<div class="ai-flash-tune-admin-wrapper">
    <?php include_once('ai-flash-tune-admin-sidebar.php'); ?>
    <div class="ai-flash-tune-main-content">
        <div class="ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-flex-center ai-flash-tune-mb-8 ai-flash-tune-page-header">
            <span class="ai-flash-tune-main-title"><?php echo esc_html($aiflt_page_title); ?></span>
            <?php
            // Check for WooCommerce dependency at the top of the view file.
            if (aiflt_is_woocommerce_active()) { ?>
                <div class="ai-flash-tune-header-actions-wrapper">
                    <div class="ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-space-x-4 ai-flash-tune-header-actions">
                        <span class="ai-flash-tune-text-gray-600 ai-flash-tune-text-sm ai-flash-tune-last-updated">
                            <?php echo esc_html(gmdate('M d, Y', strtotime($aiflt_start_date))) . ' - ' . esc_html(gmdate('M d, Y', strtotime($aiflt_end_date))); ?>
                        </span>
                        <a class="ai-flash-tune-bg-blue-500 hover:ai-flash-tune-bg-blue-600 ai-flash-tune-text-white ai-flash-tune-font-semibold ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-rounded-lg ai-flash-tune-shadow-md ai-flash-tune-date-range-toggle" href="#">
                            <i class="fas fa-filter ai-flash-tune-mr-2" aria-hidden="true"></i> <?php echo esc_html(__('Filters', 'ai-flash-tune')); ?>
                        </a>
                    </div>
                    <div id="ai-flash-tune-date-range-form-wrapper" class="ai-flash-tune-card ai-flash-tune-date-range-form hidden">
                        <form method="get" class="ai-flash-tune-flex --ai-flash-tune-space-x-4">
                            <input type="hidden" name="page" value="abandonedcarts" />
                            <div class="ai-flash-tune-date-range-field">
                                <label for="aift-start-date"><?php echo esc_html__('Start Date', 'ai-flash-tune'); ?></label>
                                <input type="text" id="aift-start-date" name="start_date" value="<?php echo esc_attr($aiflt_start_date); ?>" />
                            </div>
                            <div class="ai-flash-tune-date-range-field">
                                <label for="aift-end-date"><?php echo esc_html__('End Date', 'ai-flash-tune'); ?></label>
                                <input type="text" id="aift-end-date" name="end_date" value="<?php echo esc_attr($aiflt_end_date); ?>" />
                            </div>
                            <div class="ai-flash-tune-date-range-field">
                                <label for="customer_type"><?php echo esc_html__('Customer Type', 'ai-flash-tune'); ?></label>
                                <select name="customer_type" id="customer_type">
                                    <option value="all" <?php selected($aiflt_customer_type, 'all'); ?>><?php echo esc_html__('All Customers', 'ai-flash-tune'); ?></option>
                                    <option value="guest" <?php selected($aiflt_customer_type, 'guest'); ?>><?php echo esc_html__('Guests Only', 'ai-flash-tune'); ?></option>
                                    <option value="registered" <?php selected($aiflt_customer_type, 'registered'); ?>><?php echo esc_html__('Registered Only', 'ai-flash-tune'); ?></option>
                                </select>
                            </div>
                            <input type="submit" value="<?php echo esc_attr(__('Apply', 'ai-flash-tune')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue" />
                        </form>
                    </div>
                </div>
                <?php
            } ?>
        </div>
        <?php
        // Check for WooCommerce dependency at the top of the view file.
        if (!aiflt_is_woocommerce_active()) {
            $aiflt_install_url = admin_url('plugin-install.php?s=woocommerce&tab=search&type=term');
            $aiflt_wc_status = aiflt_get_woocommerce_status(); // Call the helper function
            ?>
            <div class="ai-flash-tune-wc-required-notice">
                <i class="fas fa-plug ai-flash-tune-notice-icon" aria-hidden="true"></i>
                <p class="ai-flash-tune-notice-title"><?php echo esc_html__('WooCommerce is Required', 'ai-flash-tune'); ?></p>
                <p class="ai-flash-tune-notice-text"><?php echo esc_html__('This page requires WooCommerce to be installed and active to display abandoned cart data. Please install or activate WooCommerce to continue.', 'ai-flash-tune'); ?></p>
                <a href="<?php echo esc_url($aiflt_wc_status['action_url']); ?>" class="ai-flash-tune-notice-button">
                    <?php echo esc_html($aiflt_wc_status['button_text']); ?>
                </a>
            </div>
            <?php
            return; // Stop rendering the rest of the page.
        } ?>
        <div class="ai-flash-tune-grid ai-flash-tune-grid-cols-1 ai-flash-tune-grid-cols-md-2 ai-flash-tune-grid-cols-lg-3 ai-flash-tune-gap-6 ai-flash-tune-mb-8 ai-flash-tune-insight-grid">
            <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                <div>
                    <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Total Abandoned Carts', 'ai-flash-tune')); ?></p>
                    <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo esc_html(number_format_i18n($aiflt_total_abandoned)); ?></p>
                </div>
                <i class="fas fa-shopping-basket ai-flash-tune-text-red-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
            </div>
            <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                <div>
                    <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Total Lost Revenue', 'ai-flash-tune')); ?></p>
                    <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo wp_kses_post(wc_price($aiflt_total_lost_revenue)); ?></p>
                </div>
                <i class="fas fa-dollar-sign ai-flash-tune-text-orange-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
            </div>
            <?php if ($aiflt_is_cart_recovery_active): ?>
                <div class="ai-flash-tune-card ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-justify-between ai-flash-tune-insight-card">
                    <div>
                        <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-500 ai-flash-tune-insight-label"><?php echo esc_html(__('Recovery Rate', 'ai-flash-tune')); ?></p>
                        <p class="ai-flash-tune-text-3xl ai-flash-tune-font-bold ai-flash-tune-text-gray-900 ai-flash-tune-data-value"><?php echo esc_html($aiflt_recovery_rate); ?></p>
                    </div>
                    <i class="fas fa-undo-alt ai-flash-tune-text-green-500 ai-flash-tune-text-4xl ai-flash-tune-insight-icon" aria-hidden="true"></i>
                </div>
            <?php endif; ?>
        </div>
        <div class="ai-flash-tune-card ai-flash-tune-mb-8 ai-flash-tune-carts-section">
            <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title"><?php echo esc_html(__('Abandoned Cart Tracker', 'ai-flash-tune')); ?></span>
            <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-section-description"><?php echo esc_html(__('Tracks abandoned carts & shows cart contents (no auto-recovery).', 'ai-flash-tune')); ?></p>
            <div class="ai-flash-tune-table-wrp">
                <table class="ai-flash-tune-min-w-full ai-flash-tune-divide-y ai-flash-tune-divide-gray-200 ai-flash-tune-carts-table">
                     <thead class="ai-flash-tune-bg-gray-50">
                        <tr>
                            <th scope="col" class="ai-flash-tune-px-6 ai-flash-tune-py-3 ai-flash-tune-text-left ai-flash-tune-text-xs ai-flash-tune-font-medium ai-flash-tune-text-gray-500 ai-flash-tune-uppercase ai-flash-tune-tracking-wider"><?php echo esc_html(__('Customer', 'ai-flash-tune')); ?></th>
                            <th scope="col" class="ai-flash-tune-px-6 ai-flash-tune-py-3 ai-flash-tune-text-left ai-flash-tune-text-xs ai-flash-tune-font-medium ai-flash-tune-text-gray-500 ai-flash-tune-uppercase ai-flash-tune-tracking-wider"><?php echo esc_html(__('Cart Contents', 'ai-flash-tune')); ?></th>
                            <th scope="col" class="ai-flash-tune-px-6 ai-flash-tune-py-3 ai-flash-tune-text-left ai-flash-tune-text-xs ai-flash-tune-font-medium ai-flash-tune-text-gray-500 ai-flash-tune-uppercase ai-flash-tune-tracking-wider"><?php echo esc_html(__('Cart Total', 'ai-flash-tune')); ?></th>
                            <th scope="col" class="ai-flash-tune-px-6 ai-flash-tune-py-3 ai-flash-tune-text-left ai-flash-tune-text-xs ai-flash-tune-font-medium ai-flash-tune-text-gray-500 ai-flash-tune-uppercase ai-flash-tune-tracking-wider"><?php echo esc_html(__('Abandoned On', 'ai-flash-tune')); ?></th>
                            <th scope="col" class="ai-flash-tune-px-6 ai-flash-tune-py-3 ai-flash-tune-text-left ai-flash-tune-text-xs ai-flash-tune-font-medium ai-flash-tune-text-gray-500 ai-flash-tune-uppercase ai-flash-tune-tracking-wider"><?php echo esc_html(__('Status', 'ai-flash-tune')); ?></th>
                            <th scope="col" class="ai-flash-tune-px-6 ai-flash-tune-py-3 ai-flash-tune-text-left ai-flash-tune-text-xs ai-flash-tune-font-medium ai-flash-tune-text-gray-500 ai-flash-tune-uppercase ai-flash-tune-tracking-wider"><?php echo esc_html(__('Action', 'ai-flash-tune')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="ai-flash-tune-bg-white ai-flash-tune-divide-y ai-flash-tune-divide-gray-200">
                        <?php if (empty($aiflt_carts)) { ?>
                            <tr class="ai-flash-tune-cart-row">
                                <td colspan="5" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-text-center ai-flash-tune-text-sm ai-flash-tune-text-gray-500"><?php echo esc_html(__('No abandoned carts found for the selected criteria.', 'ai-flash-tune')); ?></td>
                            </tr>
                        <?php } else { ?>
                            <?php foreach ($aiflt_carts as $aiflt_cart) { 
                                $aiflt_contents_list = $aiflt_cart['contents'];
                                $aiflt_item_count = count($aiflt_contents_list);
                                $aiflt_display_text = __('N/A', 'ai-flash-tune');
                                $aiflt_tooltip_text = '';

                                if ($aiflt_item_count > 0) {
                                    $aiflt_first_item = $aiflt_contents_list[0]['name'] . ' (x' . $aiflt_contents_list[0]['quantity'] . ')';
                                    if ($aiflt_item_count > 1) {
                                        $aiflt_display_text = sprintf('%s + %d more', $aiflt_first_item, $aiflt_item_count - 1);
                                    } else {
                                        $aiflt_display_text = $aiflt_first_item;
                                    }
                                    // Create a tooltip text with each item on a new line
                                    $aiflt_tooltip_items = [];
                                    foreach ($aiflt_contents_list as $aiflt_item) {
                                        $aiflt_tooltip_items[] = $aiflt_item['name'] . ' (x' . $aiflt_item['quantity'] . ')';
                                    }
                                    $aiflt_tooltip_text = implode("&#10;", $aiflt_tooltip_items); // &#10; is a newline character for tooltips
                                }
                                ?>
                                <tr class="ai-flash-tune-cart-row">
                                    <td data-label="<?php echo esc_attr__('Customer', 'ai-flash-tune'); ?>" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-whitespace-nowrap ai-flash-tune-text-sm ai-flash-tune-font-medium ai-flash-tune-text-gray-900"><?php echo esc_html($aiflt_cart['customer']); ?></td>
                                    <td data-label="<?php echo esc_attr__('Contents', 'ai-flash-tune'); ?>" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-whitespace-nowrap ai-flash-tune-text-sm ai-flash-tune-text-gray-500" title="<?php echo esc_attr($aiflt_tooltip_text); ?>">
                                        <?php echo esc_html($aiflt_display_text); ?>
                                    </td>
                                    <td data-label="<?php echo esc_attr__('Total', 'ai-flash-tune'); ?>" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-whitespace-nowrap ai-flash-tune-text-sm ai-flash-tune-text-gray-500"><?php echo wp_kses_post($aiflt_cart['total']); ?></td>
                                    <td data-label="<?php echo esc_attr__('Abandoned On', 'ai-flash-tune'); ?>" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-whitespace-nowrap ai-flash-tune-text-sm ai-flash-tune-text-gray-500"><?php echo esc_html($aiflt_cart['abandoned_on']); ?></td>
                                    <td data-label="<?php echo esc_attr__('Status', 'ai-flash-tune'); ?>" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-whitespace-nowrap ai-flash-tune-text-sm">
                                        <span class="ai-flash-tune-px-2 ai-flash-tune-inline-flex ai-flash-tune-text-xs ai-flash-tune-leading-5 ai-flash-tune-font-semibold ai-flash-tune-rounded-full ai-flash-tune-bg-red-100 ai-flash-tune-text-red-800 ai-flash-tune-status-badge"><?php echo esc_html($aiflt_cart['status']); ?></span>
                                    </td>
                                    <td data-label="<?php echo esc_attr__('Actions', 'ai-flash-tune'); ?>" class="ai-flash-tune-px-6 ai-flash-tune-py-4 ai-flash-tune-whitespace-nowrap ai-flash-tune-text-sm">
                                    <?php
                                        if (!empty($aiflt_cart['customer_email']) && $aiflt_cart['customer'] !== 'Guest') {
                                            if (!empty($aiflt_cart['customer_email']) && $aiflt_cart['customer'] !== 'Guest') {
                                                $aiflt_subject = esc_html__('You left something in your cart at ', 'ai-flash-tune') . get_bloginfo('name');    
                                                // Part 1: Greeting and Introduction
                                                $aiflt_raw_body = esc_html__("Hi ", 'ai-flash-tune') . esc_html( $aiflt_cart['customer'] ). ". " . esc_html__("We noticed you left some items in your shopping cart. If you would like to complete your purchase, your cart is waiting for you right where you left it.", 'ai-flash-tune');
                                            
                                                // Part 2: Cart Link Line
                                                $aiflt_raw_body .= "\n\n" . esc_html__("Click here to return to your cart:", 'ai-flash-tune');
                                                $aiflt_raw_body .= wc_get_cart_url();
                                                
                                                // Part 3: Sign-off
                                                $aiflt_raw_body .= "\n\n" . esc_html__("Thank you,", 'ai-flash-tune' ) . "\n" . esc_html__( "The", 'ai-flash-tune' ) . ' ';
                                                $aiflt_raw_body .= get_bloginfo('name');
                                                $aiflt_raw_body .= esc_html__(" Team", 'ai-flash-tune');

                                                $aiflt_mailto_link = 'mailto:' . esc_attr($aiflt_cart['customer_email']) 
                                                             . '?subject=' . rawurlencode($aiflt_subject) 
                                                             . '&body=' . rawurlencode($aiflt_raw_body);
                                                             
                                                // Ensure the final link is escaped (already using esc_url, which is correct)
                                                echo '<a href="' . esc_url($aiflt_mailto_link) . '" class="ai-flash-tune-btn ai-flash-tune-btn-green">' . esc_html__('Recover', 'ai-flash-tune') . '</a>';
                                            }
                                        }
                                    ?>
                                    </td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($aiflt_total_pages > 1): ?>
                <div class="ai-flash-tune-flex ai-flash-tune-justify-between ai-flash-tune-items-center ai-flash-tune-pt-4">
                    <p class="ai-flash-tune-text-sm ai-flash-tune-text-gray-700">
                        <?php
                        printf(
                            /* translators: 1: First item number, 2: Last item number, 3: Total items */
                            esc_html__( 'Showing %1$d to %2$d of %3$d carts', 'ai-flash-tune' ),
                            absint( $aiflt_offset + 1 ),
                            absint( min( ( $aiflt_offset + $aiflt_items_per_page ), $aiflt_total_carts ) ),
                            absint( $aiflt_total_carts )
                        );
                        ?>
                    </p>
                    <nav class="ai-flash-tune-pagination-nav">
                        <ul class="ai-flash-tune-flex ai-flash-tune-space-x-2">
                            <?php if ($aiflt_current_page > 1): ?>
                                <li><a href="<?php echo esc_url(add_query_arg('paged', $aiflt_current_page - 1)); ?>" class="ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-border ai-flash-tune-rounded-lg ai-flash-tune-text-gray-700 ai-flash-tune-bg-white hover:ai-flash-tune-bg-gray-100">&laquo; <?php esc_html_e('Previous', 'ai-flash-tune'); ?></a></li>
                            <?php endif; ?>
                            
                            <?php // This is a simplified pagination. For more complex scenarios, you might use paginate_links().
                            for ($i = 1; $i <= $aiflt_total_pages; $i++): ?>
                                <li><a href="<?php echo esc_url(add_query_arg('paged', $i)); ?>" class="ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-border ai-flash-tune-rounded-lg <?php echo ($i === $aiflt_current_page) ? 'ai-flash-tune-bg-indigo-500 ai-flash-tune-text-white' : 'ai-flash-tune-bg-white hover:ai-flash-tune-bg-gray-100 ai-flash-tune-text-gray-700'; ?>"><?php echo esc_html($i); ?></a></li>
                            <?php endfor; ?>

                            <?php if ($aiflt_current_page < $aiflt_total_pages): ?>
                                <li><a href="<?php echo esc_url(add_query_arg('paged', $aiflt_current_page + 1)); ?>" class="ai-flash-tune-py-2 ai-flash-tune-px-4 ai-flash-tune-border ai-flash-tune-rounded-lg ai-flash-tune-text-gray-700 ai-flash-tune-bg-white hover:ai-flash-tune-bg-gray-100"><?php esc_html_e('Next', 'ai-flash-tune'); ?> &raquo;</a></li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
            <?php endif; ?>
        </div>
        <div class="ai-flash-tune-flex ai-flash-tune-flex-wrap ai-flash-tune-grid-cols-lg-2 ai-flash-tune-gap-6 ai-flash-tune-mb-8">
            <?php
            // --- REVISED: Check if the Cart Recovery Addon is active ---
            if (class_exists('AIFTCR_Logic')) :
                // If active, get its settings to display the current status.
                $aiflt_recovery_options = get_option('aiftcr_settings');
                $aiflt_is_bot_enabled = isset($aiflt_recovery_options['enable_bot']) && $aiflt_recovery_options['enable_bot'] == 1;
            ?>
                <div class="ai-flash-tune-card ai-flash-tune-recovery-bot-card">
                    <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                        <i class="fas fa-robot ai-flash-tune-text-green-500 ai-flash-tune-mr-2" aria-hidden="true"></i><?php echo esc_html(__('Abandoned Cart Recovery Bot', 'ai-flash-tune')); ?>
                    </span>
                    <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4 ai-flash-tune-section-description"><?php echo esc_html(__('Automated email reminders are actively running to recover lost sales.', 'ai-flash-tune')); ?></p>
                    
                    <?php if ($aiflt_is_bot_enabled) : ?>
                        <div class="ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-bg-green-100 ai-flash-tune-text-green-800 ai-flash-tune-text-sm ai-flash-tune-font-medium ai-flash-tune-px-2_5 ai-flash-tune-py-0_5 ai-flash-tune-rounded-full ai-flash-tune-mb-4" style="width: fit-content;">
                            <i class="fas fa-check-circle ai-flash-tune-mr-2" aria-hidden="true"></i>
                            <?php echo esc_html__('Status: Active', 'ai-flash-tune'); ?>
                        </div>
                        <p class="ai-flash-tune-text-gray-600 ai-flash-tune-text-sm ai-flash-tune-mb-4"><?php echo esc_html__('The bot is currently monitoring for abandoned carts and sending emails according to your schedule.', 'ai-flash-tune'); ?></p>
                    <?php else : ?>
                        <div class="ai-flash-tune-flex ai-flash-tune-flex-center ai-flash-tune-bg-red-100 ai-flash-tune-text-red-800 ai-flash-tune-text-sm ai-flash-tune-font-medium ai-flash-tune-px-2_5 ai-flash-tune-py-0_5 ai-flash-tune-rounded-full ai-flash-tune-mb-4" style="width: fit-content;">
                            <i class="fas fa-exclamation-triangle ai-flash-tune-mr-2" aria-hidden="true"></i>
                            <?php echo esc_html__('Status: Inactive', 'ai-flash-tune'); ?>
                        </div>
                        <p class="ai-flash-tune-text-gray-600 ai-flash-tune-text-sm ai-flash-tune-mb-4"><?php echo esc_html__('The addon is active, but the recovery bot is currently disabled. You can enable it in the settings.', 'ai-flash-tune'); ?></p>
                    <?php endif; ?>

                    <a href="<?php echo esc_url(admin_url('admin.php?page=aiflt_settings&tab=cart-recovery')); ?>" class="ai-flash-tune-btn ai-flash-tune-btn-blue">
                        <i class="fas fa-cogs ai-flash-tune-mr-2" aria-hidden="true"></i>
                        <?php echo esc_html(__('Configure Recovery Settings', 'ai-flash-tune')); ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php if ($aiflt_is_predictor_addon_active): ?>
                <div class="ai-flash-tune-card ai-flash-tune-reason-predictor-card <?php echo !$aiflt_is_predictor_addon_active ? 'ai-flash-tune-relative ai-flash-tune-pro-feature-card' : ''; ?>">
                    <span class="ai-flash-tune-text-xl ai-flash-tune-font-semibold ai-flash-tune-text-gray-800 ai-flash-tune-mb-4 ai-flash-tune-card-title">
                        <i class="fas fa-search-dollar ai-flash-tune-text-orange-500 ai-flash-tune-mr-2" aria-hidden="true"></i><?php echo esc_html(__('Cart Abandon Reason Predictor', 'ai-flash-tune')); ?>
                    </span>
                    <div id="aiftap-main-content">
                        <p class="ai-flash-tune-text-gray-700 ai-flash-tune-mb-4"><?php echo esc_html__('Our AI has analyzed your data to predict the most likely causes for cart abandonment.', 'ai-flash-tune'); ?></p>
                        <div id="aiftap-prediction-container" class="ai-flash-tune-bg-gray-100 ai-flash-tune-p-4 ai-flash-tune-rounded-lg ai-flash-tune-text-gray-700 ai-flash-tune-text-sm">
                           <?php if ($aiflt_latest_prediction && $aiflt_latest_prediction['status'] === 'success'):
                                echo wp_kses_post($aiflt_latest_prediction['prediction']);
                           else: ?>
                                <em><?php echo esc_html__('Click the button to get your AI-powered prediction.', 'ai-flash-tune'); ?></em>
                           <?php endif; ?>
                        </div>
                        
                        <div id="aiftap-metrics-container" class="ai-flash-tune-mt-4" <?php if (!$aiflt_latest_prediction) echo 'style="display:none;"'; ?>>
                            <h4 class="ai-flash-tune-font-semibold ai-flash-tune-text-gray-800"><?php echo esc_html__('Key Data Influencing Prediction:', 'ai-flash-tune'); ?></h4>
                            <ul class="ai-flash-tune-list-disc ai-flash-tune-list-inside ai-flash-tune-text-sm ai-flash-tune-text-gray-600 ai-flash-tune-mt-2">
                               <?php if ($aiflt_latest_prediction && isset($aiflt_latest_prediction['metrics'])): ?>
                                   <?php foreach ($aiflt_latest_prediction['metrics'] as $aiflt_label => $aiflt_value): ?>
                                       <li><strong><?php echo esc_html($aiflt_label); ?>:</strong> <?php echo wp_kses_post($aiflt_value); ?></li>
                                   <?php endforeach; ?>
                               <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <button id="aiftap-get-prediction-btn" class="ai-flash-tune-btn ai-flash-tune-btn-blue ai-flash-tune-mt-4">
                        <?php echo esc_html__('Get/Refresh Prediction', 'ai-flash-tune'); ?>
                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>