<?php
if (!defined('ABSPATH')) die('Restricted Access');

class AIFLT_Settings_Logic {

    /**
     * Handles the AJAX request to save plugin settings.
     */
    public static function save_settings_callback() {
        check_ajax_referer('aiflt-save-settings-nonce', '_ajax_nonce');
        if (!current_user_can('manage_options')) {
            wp_send_json_error(__('You do not have permission to perform this action.', 'ai-flash-tune'));
        }

        // --- Core Options: Update ONLY if General Settings tab was active/submitted ---
        // Use the API Key field as the proxy check for the General tab's submission state.
        if (isset($_POST['aiflt_ai_api_key'])) { 
            
            // --- 1. Save API/License Fields (Text/Selects) ---
            update_option('aiflt_ai_api_key', sanitize_text_field($_POST['aiflt_ai_api_key']));
            update_option('aiflt_ai_model', sanitize_text_field($_POST['aiflt_ai_model']));
            update_option('aiflt_data_retention', sanitize_text_field($_POST['aiflt_data_retention']));

            // --- 2. Save Checkbox Fields (Capture the OFF state) ---
            // These are guaranteed to be present as '0' or '1' if the tab was submitted.
            $aiflt_delete_data = isset($_POST['aiflt_delete_data_on_uninstall']) ? '1' : '0';
            update_option('aiflt_delete_data_on_uninstall', $aiflt_delete_data);
            
            $anonymize_ip = isset($_POST['aiflt_anonymize_ip']) ? '1' : '0';
            update_option('aiflt_anonymize_ip', $anonymize_ip);
            
            // FIX: This ensures 'aiflt_enable_tracking' is only updated when the General tab is open.
            $enable_tracking = isset($_POST['aiflt_enable_tracking']) ? '1' : '0';
            update_option('aiflt_enable_tracking', $enable_tracking);
            
            // --- 3. Save Array/Textarea Fields ---
            
            // Excluded Roles (Array)
            $excluded_roles = [];
            if (isset($_POST['aiflt_excluded_roles']) && is_array($_POST['aiflt_excluded_roles'])) {
                foreach ($_POST['aiflt_excluded_roles'] as $role) {
                    $excluded_roles[] = sanitize_key($role);
                }
            }
            update_option('aiflt_excluded_roles', $excluded_roles);
            
            // Excluded IPs (Textarea)
            if (isset($_POST['aiflt_excluded_ips'])) {
                $ips_array = explode("\n", trim($_POST['aiflt_excluded_ips']));
                $sanitized_ips = [];
                foreach ($ips_array as $ip) {
                    $trimmed_ip = trim($ip);
                    if (!empty($trimmed_ip)) {
                        $sanitized_ips[] = sanitize_text_field($trimmed_ip);
                    }
                }
                update_option('aiflt_excluded_ips', implode("\n", $sanitized_ips));
            }
        }


        // --- Trigger Addon Save Action (Addons handle their own saving logic) ---
        // This action allows the Recovery Bot tab (a different tab) to save its settings.
        do_action('aiflt_save_addon_settings', $_POST);

        wp_send_json_success(__('Settings saved successfully!', 'ai-flash-tune'));
    }

    // Ensure the companion get_settings function uses the AIFLT_ prefixes as well
    public static function get_settings() {
        $settings = array(
            'ai_api_key' => get_option('aiflt_ai_api_key', ''),
            'ai_model' => get_option('aiflt_ai_model', 'gpt-4o-mini'),
            'data_retention' => get_option('aiflt_data_retention', '30'),
            'delete_data_on_uninstall' => get_option('aiflt_delete_data_on_uninstall', '0'),
            'anonymize_ip' => get_option('aiflt_anonymize_ip', '0'),
            'enable_tracking' => get_option('aiflt_enable_tracking', '1'),
            'excluded_roles' => get_option('aiflt_excluded_roles', ['administrator']),
            'excluded_ips' => get_option('aiflt_excluded_ips', ''),
        );
        return $settings;
    }
}
