<?php
if (!defined('ABSPATH')) die('Restricted Access');

/**
 * Checks if the database needs to be updated and triggers the update script.
 * This function is called from the main plugin file.
 */
function aiflt_update_db_check() {
    $current_db_version = get_option('aiflt_db_version', '1.0');

    if (version_compare($current_db_version, AIFLT_DB_VERSION, '<')) {
        // If the stored version is lower than the new version, run the update.
        aiflt_run_database_updates($current_db_version);
        // After running the update, save the new version number.
        update_option('aiflt_db_version', AIFLT_DB_VERSION);
    }
}

/**
 * Contains the actual database modification queries using the reliable dbDelta() function.
 * @param string $from_version The version we are updating from.
 */
function aiflt_run_database_updates($from_version) {
    global $wpdb;
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    $charset_collate = $wpdb->get_charset_collate();
    
    
}