<?php
/**
 * Uninstall file - Cleanup plugin data when uninstalled
 *
 * @package AI_Editor_Post_Switcher
 */

// If uninstall is not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Get plugin settings
$settings = get_option('ai_editor_post_switcher_settings');

// Check if data should be deleted
if (!empty($settings['delete_on_uninstall'])) {
    // Delete plugin options
    delete_option('ai_editor_post_types');
    delete_option('ai_editor_post_switcher_settings');
    
    // Delete transients
    delete_transient('ai_editor_allowed_post_types');
    delete_transient('ai_editor_compatible_post_types');
}
