/**
 * Admin changelog height adjustment script + Saved badge fade
 * 
 * @package AI_Editor_Post_Switcher
 */

document.addEventListener('DOMContentLoaded', function() {
    // Adjust changelog container height
    function adjustChangelogHeight() {
        const container = document.querySelector('.ai-changelog-container');
        if (!container) return;

        const rect = container.getBoundingClientRect();
        const distanceFromTop = rect.top;
        const availableHeight = window.innerHeight - distanceFromTop - 100;

        container.style.maxHeight = Math.max(availableHeight, 200) + 'px';
        container.style.overflowY = 'scroll';
    }

    if (document.querySelector('.ai-changelog-container')) {
        adjustChangelogHeight();
        window.addEventListener('resize', adjustChangelogHeight);

        const tabs = document.querySelectorAll('.nav-tab');
        tabs.forEach(function(tab) {
            tab.addEventListener('click', function() {
                setTimeout(adjustChangelogHeight, 100);
            });
        });
    }

    // Show saved badge if present
    const badge = document.getElementById('ai-editor-saved-badge');
    if (badge) {
        badge.style.display = 'inline-block';
        setTimeout(() => {
            badge.style.display = 'none';
        }, 3000);
    }
});
