<?php
/**
 * Admin Helper Functions
 *
 * @package AI_Editor_Post_Switcher
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Class AI_Editor_Admin_Helpers
 * Shared helper methods for admin pages
 */
class AI_Editor_Admin_Helpers {
    /**
     * Get plugin settings with defaults
     * 
     * @return array Settings with default values applied
     */
    public static function get_plugin_settings() {
        // Default settings
        $defaults = array(
            'delete_on_uninstall' => 0,
            'enable_first_last' => 1  // Set to 1 (true) by default
        );
        
        // Get saved settings
        $settings = get_option('ai_editor_post_switcher_settings', array());
        
        // Merge with defaults
        return wp_parse_args($settings, $defaults);
    }
    
    /**
     * Get compatible post types
     *
     * @return array
     */
    public static function get_compatible_post_types() {
        // Try to get from cache first
        $cache_key = 'ai_editor_compatible_post_types';
        $post_types = get_transient($cache_key);
        
        if (false !== $post_types) {
            return $post_types;
        }
        
        // Get all post types compatible with Gutenberg
        $post_types = get_post_types(array(
            'show_in_rest' => true,
            'show_ui'      => true,
        ), 'objects');
        
        // Filter post types that support the editor
        $filtered = array_filter($post_types, function($type) {
            return post_type_supports($type->name, 'editor');
        });
        
        // Cache for a day
        set_transient($cache_key, $filtered, DAY_IN_SECONDS);
        
        return $filtered;
    }
}