<?php
/**
 * Plugin Name: AI Editor Post Switcher
 * Description: Navigate easily between posts, pages, or CPTs in the Gutenberg editor via buttons added to the editor header.
 * Version: 1.1.2.1
 * Author: 4wpai
 * Plugin URI: https://4wp.ai
 * Text Domain: ai-editor-post-switcher
 * Domain Path: /languages
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Requires PHP: 7.0
 * 
 * @package AI_Editor_Post_Switcher
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main plugin class
 */
class AI_Editor_Post_Switcher {
	/**
	 * Plugin instance
	 *
	 * @var AI_Editor_Post_Switcher
	 */
	private static $instance = null;
	
	/**
	 * Get plugin instance
	 *
	 * @return AI_Editor_Post_Switcher
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	
	/**
	 * Constructor
	 */
	private function __construct() {
		// Define constants
		$this->define_constants();
		
		// Include required files
		$this->includes();
		
		// Setup hooks
		$this->setup_hooks();
	}
	
	/**
	 * Define plugin constants
	 */
	private function define_constants() {
		define( 'AI_EDITOR_PLUGIN_FILE', __FILE__ );
		define( 'AI_EDITOR_BASENAME', plugin_basename( __FILE__ ) );
		define( 'AI_EDITOR_PATH', plugin_dir_path( __FILE__ ) );
		define( 'AI_EDITOR_URL', plugin_dir_url( __FILE__ ) );

		// Use get_plugin_data() to get version as recommended by WordPress
		if ( ! function_exists( 'get_plugin_data' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		
		$plugin_data = get_plugin_data( __FILE__, false, false );
		$version = ! empty( $plugin_data['Version'] ) ? $plugin_data['Version'] : 'unknown';
		define( 'AI_EDITOR_VERSION', $version );
	}
	
	/**
	 * Include required files
	 */
	private function includes() {
		// Core files
		require_once AI_EDITOR_PATH . 'includes/class-nonce-manager.php';
		
		// Original files
		require_once AI_EDITOR_PATH . 'includes/class-editor-integration.php';
		require_once AI_EDITOR_PATH . 'includes/sort-editlink.php';
		require_once AI_EDITOR_PATH . 'includes/class-posts-search.php';
		
		// Main admin page (coordinator)
		require_once AI_EDITOR_PATH . 'includes/class-admin-page.php';
	}

	/**
	 * Setup hooks
	 */
	private function setup_hooks() {
		// Activation/Deactivation
		register_activation_hook( AI_EDITOR_PLUGIN_FILE, array( $this, 'activate' ) );
		
		// No longer need to load text domain manually as of WordPress 4.6
		// WordPress.org will handle this automatically
		
		// Initialize classes
		new AI_Editor_Admin_Page();
		new AI_Editor_Integration();
	}
	
	/**
	 * Plugin activation
	 */
	public function activate() {
		if ( false === get_option( 'ai_editor_post_types' ) ) {
			update_option( 'ai_editor_post_types', array( 'post', 'page' ) );
		}
		
		// Clear rewrite rules
		flush_rewrite_rules();
	}
}

/**
 * Returns the main instance of AI_Editor_Post_Switcher
 *
 * @return AI_Editor_Post_Switcher
 */
function ai_editor_post_switcher() {
	return AI_Editor_Post_Switcher::get_instance();
}

// Initialize the plugin
ai_editor_post_switcher();