<?php
/**
 * Uninstall handler — removes all plugin data on deletion.
 *
 * @package AIDF
 * @since   1.0.0
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Remove plugin options.
delete_option( 'aidf_settings' );

// Remove any transients.
delete_transient( 'aidf_activation_redirect' );

// Remove welcome notice dismissal from all users.
delete_metadata( 'user', 0, 'aidf_welcome_dismissed', '', true );

// Flush rewrite rules to remove our custom rules.
flush_rewrite_rules();
