<?php
/**
 * Template: llms.txt (ADF-001) — AI-readable business identity.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity = $data['identity'];
$content  = $data['content'];
$site     = $data['site'];
$pages    = $data['pages'];
$settings = $data['settings'];

// H1 — Business name (required).
echo '# ' . esc_html( $identity['name'] ) . "\n\n";

// Blockquote — Tagline/description (recommended).
if ( ! empty( $identity['tagline'] ) ) {
	echo '> ' . esc_html( $identity['tagline'] ) . "\n\n";
}

// Website URL.
echo '- Website: [' . esc_html( $identity['url'] ) . '](' . esc_url( $identity['url'] ) . ')' . "\n";

// Contact section (required).
echo "\n## Contact\n\n";

if ( ! empty( $identity['email'] ) ) {
	echo '- Email: ' . esc_html( $identity['email'] ) . "\n";
}

if ( ! empty( $identity['phone'] ) ) {
	echo '- Phone: ' . esc_html( $identity['phone'] ) . "\n";
}

if ( ! empty( $identity['contact_url'] ) ) {
	echo '- [Contact Page](' . esc_url( $identity['contact_url'] ) . ')' . "\n";
}

// Location.
$location_parts = array_filter(
	array( $identity['city'], $identity['postcode'], $identity['region'], $identity['country'] )
);

if ( ! empty( $location_parts ) ) {
	echo '- Location: ' . esc_html( implode( ', ', $location_parts ) ) . "\n";
}

// Services (recommended).
if ( ! empty( $identity['services'] ) ) {
	echo "\n## What We Do\n\n";
	foreach ( $identity['services'] as $service ) {
		if ( ! empty( $service['url'] ) ) {
			echo '- [' . esc_html( $service['name'] ) . '](' . esc_url( $service['url'] ) . ')' . "\n";
		} else {
			echo '- ' . esc_html( $service['name'] ) . "\n";
		}
	}
}

// What we do NOT do (recommended).
if ( ! empty( $identity['not_services'] ) ) {
	echo "\n## What We Do Not Do\n\n";
	foreach ( $identity['not_services'] as $not_service ) {
		echo '- ' . esc_html( $not_service ) . "\n";
	}
}

// Service areas.
if ( ! empty( $identity['service_areas'] ) ) {
	echo "\n## Service Areas\n\n";
	foreach ( $identity['service_areas'] as $area ) {
		echo '- ' . esc_html( $area ) . "\n";
	}
}

if ( ! empty( $identity['not_service_areas'] ) ) {
	echo "\n## Areas Not Covered\n\n";
	foreach ( $identity['not_service_areas'] as $area ) {
		echo '- ' . esc_html( $area ) . "\n";
	}
}

// Key information.
$key_info = array();

if ( ! empty( $identity['industry'] ) ) {
	$key_info[] = array( 'Industry', $identity['industry'] );
}

if ( ! empty( $identity['business_type'] ) ) {
	$key_info[] = array( 'Business Type', $identity['business_type'] );
}

if ( ! empty( $identity['founded'] ) ) {
	$key_info[] = array( 'Founded', $identity['founded'] );
}

if ( ! empty( $identity['employees'] ) ) {
	$key_info[] = array( 'Employees', $identity['employees'] );
}

if ( ! empty( $identity['customer_type'] ) ) {
	$key_info[] = array( 'Customer Type', $identity['customer_type'] );
}

if ( ! empty( $identity['offering_type'] ) ) {
	$key_info[] = array( 'Offering', $identity['offering_type'] );
}

if ( ! empty( $identity['is_ecommerce'] ) ) {
	$key_info[] = array( 'E-commerce', 'Yes — this website sells products or services online' );
}

if ( ! empty( $key_info ) ) {
	echo "\n## Key Information\n\n";
	foreach ( $key_info as $item ) {
		echo '- ' . esc_html( $item[0] ) . ': ' . esc_html( $item[1] ) . "\n";
	}
}

// Key people.
if ( ! empty( $content['key_people'] ) ) {
	echo "\n## Key People\n\n";
	foreach ( $content['key_people'] as $person ) {
		echo '- ';
		if ( ! empty( $person['url'] ) ) {
			echo '[' . esc_html( $person['name'] ) . '](' . esc_url( $person['url'] ) . ')';
		} else {
			echo esc_html( $person['name'] );
		}
		if ( ! empty( $person['role'] ) ) {
			echo ' — ' . esc_html( $person['role'] );
		}
		echo "\n";
	}
}

// Social media profiles.
if ( ! empty( $identity['social_links'] ) ) {
	echo "\n## Social Media\n\n";
	foreach ( $identity['social_links'] as $link ) {
		echo '- [' . esc_html( $link ) . '](' . esc_url( $link ) . ')' . "\n";
	}
}

// Pages — Top-level site pages.
if ( ! empty( $pages ) || ! empty( $identity['products_url'] ) ) {
	echo "\n## Pages\n\n";

	if ( ! empty( $identity['products_url'] ) ) {
		echo '- [Products / Pricing](' . esc_url( $identity['products_url'] ) . ')' . "\n";
	}

	if ( ! empty( $pages ) ) {
		foreach ( $pages as $page ) {
			echo '- [' . esc_html( $page['title'] ) . '](' . esc_url( $page['url'] ) . ')' . "\n";
		}
	}
}

// AI Discovery Files — list other active files.
$active = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();

if ( count( $active ) > 1 ) {
	echo "\n## AI Discovery Files\n\n";

	$file_types = AIDF_Plugin::get_file_types();

	foreach ( $active as $slug ) {
		if ( 'llms-txt' === $slug || ! isset( $file_types[ $slug ] ) ) {
			continue;
		}
		$meta = $file_types[ $slug ];
		echo '- [' . esc_html( $meta['filename'] ) . '](' . esc_url( home_url( '/' . $meta['filename'] ) ) . ') — ' . esc_html( $meta['description'] ) . "\n";
	}
}

// RSS feed.
if ( ! empty( $site['rss_url'] ) ) {
	echo "\n## Feed\n\n";
	echo '- [RSS Feed](' . esc_url( $site['rss_url'] ) . ')' . "\n";
}

// Attribution footer (Markdown files use footer placement to avoid heading conflicts).
// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Pre-built internal string.
echo AIDF_Generator::get_footer_attribution( 'llms-txt' );
