<?php
/**
 * Template: llms.html (ADF-003) — Human-readable reference version.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity = $data['identity'];
$site     = $data['site'];
$settings = $data['settings'];

?>
<!DOCTYPE html>
<html lang="<?php echo esc_attr( $site['language'] ); ?>">
<head>
	<meta charset="<?php echo esc_attr( $site['charset'] ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="robots" content="noindex, nofollow">
	<title><?php echo esc_html( $identity['name'] ); ?> — AI Discovery File</title>
	<style>
		*{margin:0;padding:0;box-sizing:border-box}
		body{font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,sans-serif;line-height:1.6;max-width:720px;margin:2rem auto;padding:0 1.5rem;color:#1a1a1a}
		h1{font-size:1.8rem;margin-bottom:.5rem}
		h2{font-size:1.2rem;margin:1.5rem 0 .5rem;color:#333;border-bottom:1px solid #e5e5e5;padding-bottom:.25rem}
		blockquote{border-left:3px solid #e77d15;padding:.5rem 1rem;margin:1rem 0;color:#555;font-style:italic}
		ul{margin:.5rem 0;padding-left:1.5rem}
		li{margin:.25rem 0}
		a{color:#e77d15;text-decoration:none}
		a:hover{text-decoration:underline}
		.logo{max-width:200px;height:auto;margin:1rem 0}
		.meta{color:#666;font-size:.875rem;margin-top:2rem;padding-top:1rem;border-top:1px solid #e5e5e5}
	</style>
</head>
<body>

<?php if ( ! empty( $identity['logo_url'] ) ) : ?>
<img src="<?php echo esc_url( $identity['logo_url'] ); ?>" alt="<?php echo esc_attr( $identity['name'] ); ?> logo" title="<?php echo esc_attr( $identity['name'] ); ?>" class="logo">
<?php endif; ?>

<h1><?php echo esc_html( $identity['name'] ); ?></h1>

<?php if ( ! empty( $identity['tagline'] ) ) : ?>
<blockquote><?php echo esc_html( $identity['tagline'] ); ?></blockquote>
<?php endif; ?>

<p><a href="<?php echo esc_url( $identity['url'] ); ?>"><?php echo esc_html( $identity['url'] ); ?></a></p>

<h2>Contact</h2>
<ul>
<?php if ( ! empty( $identity['email'] ) ) : ?>
	<li>Email: <a href="mailto:<?php echo esc_attr( $identity['email'] ); ?>"><?php echo esc_html( $identity['email'] ); ?></a></li>
<?php endif; ?>
<?php if ( ! empty( $identity['phone'] ) ) : ?>
	<li>Phone: <?php echo esc_html( $identity['phone'] ); ?></li>
<?php endif; ?>
<?php
$location_parts = array_filter( array( $identity['city'], $identity['postcode'], $identity['region'], $identity['country'] ) );
if ( ! empty( $location_parts ) ) :
	?>
	<li>Location: <?php echo esc_html( implode( ', ', $location_parts ) ); ?></li>
<?php endif; ?>
</ul>

<?php if ( ! empty( $identity['services'] ) ) : ?>
<h2>What We Do</h2>
<ul>
	<?php foreach ( $identity['services'] as $service ) : ?>
	<li>
		<?php if ( ! empty( $service['url'] ) ) : ?>
			<a href="<?php echo esc_url( $service['url'] ); ?>"><?php echo esc_html( $service['name'] ); ?></a>
		<?php else : ?>
			<?php echo esc_html( $service['name'] ); ?>
		<?php endif; ?>
	</li>
	<?php endforeach; ?>
</ul>
<?php endif; ?>

<?php if ( ! empty( $identity['not_services'] ) ) : ?>
<h2>What We Do Not Do</h2>
<ul>
	<?php foreach ( $identity['not_services'] as $not_service ) : ?>
	<li><?php echo esc_html( $not_service ); ?></li>
	<?php endforeach; ?>
</ul>
<?php endif; ?>

<?php if ( ! empty( $identity['service_areas'] ) ) : ?>
<h2>Service Areas</h2>
<ul>
	<?php foreach ( $identity['service_areas'] as $area ) : ?>
	<li><?php echo esc_html( $area ); ?></li>
	<?php endforeach; ?>
</ul>
<?php endif; ?>

<?php if ( ! empty( $identity['not_service_areas'] ) ) : ?>
<h2>Areas Not Covered</h2>
<ul>
	<?php foreach ( $identity['not_service_areas'] as $area ) : ?>
	<li><?php echo esc_html( $area ); ?></li>
	<?php endforeach; ?>
</ul>
<?php endif; ?>

<?php if ( ! empty( $identity['social_links'] ) ) : ?>
<h2>Social Media</h2>
<ul>
	<?php foreach ( $identity['social_links'] as $link ) : ?>
	<li><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $link ); ?></a></li>
	<?php endforeach; ?>
</ul>
<?php endif; ?>

<div class="meta">
	<p>This is a machine-readable AI Discovery File for <strong><?php echo esc_html( $identity['name'] ); ?></strong>.</p>
	<p>
		See also: <a href="<?php echo esc_url( home_url( '/llms.txt' ) ); ?>">llms.txt</a>
		<?php
	$active = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
	if ( in_array( 'identity-json', $active, true ) ) : ?>
		| <a href="<?php echo esc_url( home_url( '/identity.json' ) ); ?>">identity.json</a>
		<?php endif; ?>
	</p>
	<?php if ( ! empty( $settings['spec_attribution'] ) ) : ?>
	<p><small>Generated per the <a href="https://www.ai-visibility.org.uk/specifications/llms-html/">llms.html Specification (ADF-003)</a>.</small></p>
	<?php endif; ?>
</div>

</body>
</html>
<?php
