<?php
/**
 * Template: identity.json (ADF-006) — Structured business identity.
 *
 * @package AIDF
 * @since   1.0.0
 *
 * @var array<string, mixed> $data Collected site data.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables scoped to including method.

$identity = $data['identity'];
$content  = $data['content'];
$settings = $data['settings'];

$output = array(
	'name' => $identity['name'],
	'url'  => $identity['url'],
);

// Legal name if different.
if ( ! empty( $identity['legal_name'] ) && $identity['legal_name'] !== $identity['name'] ) {
	$output['legal_name'] = $identity['legal_name'];
}

// Description.
if ( ! empty( $identity['tagline'] ) ) {
	$output['description'] = $identity['tagline'];
}

// Contact.
$contact = array();

if ( ! empty( $identity['email'] ) ) {
	$contact['email'] = $identity['email'];
}

if ( ! empty( $identity['phone'] ) ) {
	$contact['phone'] = $identity['phone'];
}

if ( ! empty( $identity['contact_url'] ) ) {
	$contact['url'] = $identity['contact_url'];
}

if ( ! empty( $contact ) ) {
	$output['contact'] = $contact;
}

// Location.
$location = array();

if ( ! empty( $identity['address'] ) ) {
	$location['address'] = $identity['address'];
}

if ( ! empty( $identity['postcode'] ) ) {
	$location['postcode'] = $identity['postcode'];
}

if ( ! empty( $identity['city'] ) ) {
	$location['city'] = $identity['city'];
}

if ( ! empty( $identity['region'] ) ) {
	$location['region'] = $identity['region'];
}

if ( ! empty( $identity['country'] ) ) {
	$location['country'] = $identity['country'];
}

if ( ! empty( $location ) ) {
	$output['location'] = $location;
}

// Services.
if ( ! empty( $identity['services'] ) ) {
	$output['services'] = $identity['services'];
}

if ( ! empty( $identity['not_services'] ) ) {
	$output['not_services'] = $identity['not_services'];
}

// Industry.
if ( ! empty( $identity['industry'] ) ) {
	$output['industry'] = $identity['industry'];
}

// Founded.
if ( ! empty( $identity['founded'] ) ) {
	$output['founded'] = $identity['founded'];
}

// Employee count.
if ( ! empty( $identity['employees'] ) ) {
	$output['employees'] = $identity['employees'];
}

// Business type.
if ( ! empty( $identity['business_type'] ) ) {
	$output['business_type'] = $identity['business_type'];
}

// Identifiers (company number, VAT).
$identifiers = array();

if ( ! empty( $identity['company_number'] ) ) {
	$identifiers['company_number'] = $identity['company_number'];

	if ( ! empty( $identity['company_jurisdiction'] ) ) {
		$identifiers['jurisdiction'] = $identity['company_jurisdiction'];
	}
}

if ( ! empty( $identity['vat_number'] ) ) {
	$identifiers['vat_number'] = $identity['vat_number'];
}

if ( ! empty( $identifiers ) ) {
	$output['identifiers'] = $identifiers;
}

// Customer type.
if ( ! empty( $identity['customer_type'] ) ) {
	$output['customer_type'] = $identity['customer_type'];
}

// Offering type.
if ( ! empty( $identity['offering_type'] ) ) {
	$output['offering_type'] = $identity['offering_type'];
}

// E-commerce flag.
if ( ! empty( $identity['is_ecommerce'] ) ) {
	$output['is_ecommerce'] = true;
}

// Service areas.
if ( ! empty( $identity['service_areas'] ) ) {
	$output['service_areas'] = $identity['service_areas'];
}

if ( ! empty( $identity['not_service_areas'] ) ) {
	$output['not_service_areas'] = $identity['not_service_areas'];
}

// Operating hours.
if ( ! empty( $identity['operating_hours'] ) ) {
	$output['operating_hours'] = $identity['operating_hours'];
}

// Social links.
if ( ! empty( $identity['social_links'] ) ) {
	$output['social'] = $identity['social_links'];
}

// Logo.
if ( ! empty( $identity['logo_url'] ) ) {
	$output['logo'] = $identity['logo_url'];
}

// Key people.
if ( ! empty( $content['key_people'] ) ) {
	$output['key_people'] = $content['key_people'];
}

// Legal pages.
$legal = array();

if ( ! empty( $identity['privacy_policy_url'] ) ) {
	$legal['privacy_policy'] = $identity['privacy_policy_url'];
}

if ( ! empty( $identity['terms_url'] ) ) {
	$legal['terms_of_service'] = $identity['terms_url'];
}

if ( ! empty( $legal ) ) {
	$output['legal'] = $legal;
}

// Language.
$output['language'] = $data['technical']['language'];

// Updated timestamp.
$output['updated'] = wp_date( 'Y-m-d' );

// Cross-references.
$active   = isset( $settings['active_files'] ) ? (array) $settings['active_files'] : array();
$see_also = array();

if ( in_array( 'llms-txt', $active, true ) ) {
	$see_also[] = home_url( '/llms.txt' );
}

if ( in_array( 'brand-txt', $active, true ) ) {
	$see_also[] = home_url( '/brand.txt' );
}

if ( ! empty( $see_also ) ) {
	$output['see_also'] = $see_also;
}

// Spec attribution.
$attribution = AIDF_Generator::get_json_attribution( 'identity-json' );

if ( ! empty( $attribution ) ) {
	$output = array_merge( $output, $attribution );
}

echo wp_json_encode( $output, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE );
